/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import androidx.annotation.NonNull;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.interop.InternalAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.android.AndroidAppCheckTokenProvider;
import com.google.firebase.database.android.AndroidAuthTokenProvider;
import com.google.firebase.database.core.DatabaseConfig;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.core.TokenProvider;
import com.google.firebase.inject.Deferred;
import java.util.HashMap;
import java.util.Map;

class FirebaseDatabaseComponent {
    private final Map<RepoInfo, FirebaseDatabase> instances = new HashMap<RepoInfo, FirebaseDatabase>();
    private final FirebaseApp app;
    private final TokenProvider authProvider;
    private final TokenProvider appCheckProvider;

    FirebaseDatabaseComponent(@NonNull FirebaseApp app, Deferred<InternalAuthProvider> authProvider, Deferred<InternalAppCheckTokenProvider> appCheckProvider) {
        this.app = app;
        this.authProvider = new AndroidAuthTokenProvider(authProvider);
        this.appCheckProvider = new AndroidAppCheckTokenProvider(appCheckProvider);
    }

    @NonNull
    synchronized FirebaseDatabase get(RepoInfo repo) {
        FirebaseDatabase database = this.instances.get(repo);
        if (database == null) {
            DatabaseConfig config = new DatabaseConfig();
            if (!this.app.isDefaultApp()) {
                config.setSessionPersistenceKey(this.app.getName());
            }
            config.setFirebaseApp(this.app);
            config.setAuthTokenProvider(this.authProvider);
            config.setAppCheckTokenProvider(this.appCheckProvider);
            database = new FirebaseDatabase(this.app, repo, config);
            this.instances.put(repo, database);
        }
        return database;
    }
}

