/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import androidx.annotation.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ServerValue {
    @NonNull
    public static final Map<String, String> TIMESTAMP = ServerValue.createScalarServerValuePlaceholder("timestamp");

    @NonNull
    public static final Object increment(long delta) {
        return ServerValue.createParameterizedServerValuePlaceholder("increment", delta);
    }

    @NonNull
    public static final Object increment(double delta) {
        return ServerValue.createParameterizedServerValuePlaceholder("increment", delta);
    }

    private static Map<String, String> createScalarServerValuePlaceholder(String key) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(".sv", key);
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, Map<String, Object>> createParameterizedServerValuePlaceholder(String name, Object value) {
        HashMap<String, Object> op = new HashMap<String, Object>();
        op.put(name, value);
        HashMap result = new HashMap();
        result.put(".sv", Collections.unmodifiableMap(op));
        return Collections.unmodifiableMap(result);
    }
}

