/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.utilities.ImmutableTree;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CompoundWrite
implements Iterable<Map.Entry<Path, Node>> {
    private static final CompoundWrite EMPTY = new CompoundWrite(new ImmutableTree<Object>(null));
    private final ImmutableTree<Node> writeTree;

    private CompoundWrite(ImmutableTree<Node> writeTree) {
        this.writeTree = writeTree;
    }

    public static CompoundWrite emptyWrite() {
        return EMPTY;
    }

    public static CompoundWrite fromValue(Map<String, Object> merge) {
        ImmutableTree<Node> writeTree = ImmutableTree.emptyInstance();
        for (Map.Entry<String, Object> entry : merge.entrySet()) {
            ImmutableTree<Node> tree = new ImmutableTree<Node>(NodeUtilities.NodeFromJSON(entry.getValue()));
            writeTree = writeTree.setTree(new Path(entry.getKey()), tree);
        }
        return new CompoundWrite(writeTree);
    }

    public static CompoundWrite fromChildMerge(Map<ChildKey, Node> merge) {
        ImmutableTree<Node> writeTree = ImmutableTree.emptyInstance();
        for (Map.Entry<ChildKey, Node> entry : merge.entrySet()) {
            ImmutableTree<Node> tree = new ImmutableTree<Node>(entry.getValue());
            writeTree = writeTree.setTree(new Path(entry.getKey()), tree);
        }
        return new CompoundWrite(writeTree);
    }

    public static CompoundWrite fromPathMerge(Map<Path, Node> merge) {
        ImmutableTree<Node> writeTree = ImmutableTree.emptyInstance();
        for (Map.Entry<Path, Node> entry : merge.entrySet()) {
            ImmutableTree<Node> tree = new ImmutableTree<Node>(entry.getValue());
            writeTree = writeTree.setTree(entry.getKey(), tree);
        }
        return new CompoundWrite(writeTree);
    }

    public CompoundWrite addWrite(Path path, Node node) {
        if (path.isEmpty()) {
            return new CompoundWrite(new ImmutableTree<Node>(node));
        }
        Path rootMostPath = this.writeTree.findRootMostPathWithValue(path);
        if (rootMostPath != null) {
            Path relativePath = Path.getRelative(rootMostPath, path);
            Node value = this.writeTree.get(rootMostPath);
            ChildKey back = relativePath.getBack();
            if (back != null && back.isPriorityChildName() && value.getChild(relativePath.getParent()).isEmpty()) {
                return this;
            }
            value = value.updateChild(relativePath, node);
            return new CompoundWrite(this.writeTree.set(rootMostPath, value));
        }
        ImmutableTree<Node> subtree = new ImmutableTree<Node>(node);
        ImmutableTree<Node> newWriteTree = this.writeTree.setTree(path, subtree);
        return new CompoundWrite(newWriteTree);
    }

    public CompoundWrite addWrite(ChildKey key, Node node) {
        return this.addWrite(new Path(key), node);
    }

    public CompoundWrite addWrites(final Path path, CompoundWrite updates) {
        return updates.writeTree.fold(this, new ImmutableTree.TreeVisitor<Node, CompoundWrite>(){

            @Override
            public CompoundWrite onNodeValue(Path relativePath, Node value, CompoundWrite accum) {
                return accum.addWrite(path.child(relativePath), value);
            }
        });
    }

    public CompoundWrite removeWrite(Path path) {
        if (path.isEmpty()) {
            return EMPTY;
        }
        ImmutableTree<Node> newWriteTree = this.writeTree.setTree(path, ImmutableTree.emptyInstance());
        return new CompoundWrite(newWriteTree);
    }

    public boolean hasCompleteWrite(Path path) {
        return this.getCompleteNode(path) != null;
    }

    public Node rootWrite() {
        return this.writeTree.getValue();
    }

    public Node getCompleteNode(Path path) {
        Path rootMost = this.writeTree.findRootMostPathWithValue(path);
        if (rootMost != null) {
            return this.writeTree.get(rootMost).getChild(Path.getRelative(rootMost, path));
        }
        return null;
    }

    public List<NamedNode> getCompleteChildren() {
        ArrayList<NamedNode> children = new ArrayList<NamedNode>();
        if (this.writeTree.getValue() != null) {
            for (NamedNode entry : this.writeTree.getValue()) {
                children.add(new NamedNode(entry.getName(), entry.getNode()));
            }
        } else {
            for (Map.Entry entry : this.writeTree.getChildren()) {
                ImmutableTree childTree = (ImmutableTree)entry.getValue();
                if (childTree.getValue() == null) continue;
                children.add(new NamedNode((ChildKey)entry.getKey(), (Node)childTree.getValue()));
            }
        }
        return children;
    }

    public CompoundWrite childCompoundWrite(Path path) {
        if (path.isEmpty()) {
            return this;
        }
        Node shadowingNode = this.getCompleteNode(path);
        if (shadowingNode != null) {
            return new CompoundWrite(new ImmutableTree<Node>(shadowingNode));
        }
        return new CompoundWrite(this.writeTree.subtree(path));
    }

    public Map<ChildKey, CompoundWrite> childCompoundWrites() {
        HashMap<ChildKey, CompoundWrite> children = new HashMap<ChildKey, CompoundWrite>();
        for (Map.Entry entries : this.writeTree.getChildren()) {
            children.put((ChildKey)entries.getKey(), new CompoundWrite((ImmutableTree)entries.getValue()));
        }
        return children;
    }

    public boolean isEmpty() {
        return this.writeTree.isEmpty();
    }

    private Node applySubtreeWrite(Path relativePath, ImmutableTree<Node> writeTree, Node node) {
        if (writeTree.getValue() != null) {
            return node.updateChild(relativePath, writeTree.getValue());
        }
        Node priorityWrite = null;
        for (Map.Entry childTreeEntry : writeTree.getChildren()) {
            ImmutableTree childTree = (ImmutableTree)childTreeEntry.getValue();
            ChildKey childKey = (ChildKey)childTreeEntry.getKey();
            if (childKey.isPriorityChildName()) {
                Utilities.hardAssert(childTree.getValue() != null, "Priority writes must always be leaf nodes");
                priorityWrite = (Node)childTree.getValue();
                continue;
            }
            node = this.applySubtreeWrite(relativePath.child(childKey), childTree, node);
        }
        if (!node.getChild(relativePath).isEmpty() && priorityWrite != null) {
            node = node.updateChild(relativePath.child(ChildKey.getPriorityKey()), priorityWrite);
        }
        return node;
    }

    public Node apply(Node node) {
        return this.applySubtreeWrite(Path.getEmptyPath(), this.writeTree, node);
    }

    public Map<String, Object> getValue(final boolean exportFormat) {
        final HashMap<String, Object> writes = new HashMap<String, Object>();
        this.writeTree.foreach(new ImmutableTree.TreeVisitor<Node, Void>(){

            @Override
            public Void onNodeValue(Path relativePath, Node value, Void accum) {
                writes.put(relativePath.wireFormat(), value.getValue(exportFormat));
                return null;
            }
        });
        return writes;
    }

    @Override
    public Iterator<Map.Entry<Path, Node>> iterator() {
        return this.writeTree.iterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return ((CompoundWrite)o).getValue(true).equals(this.getValue(true));
    }

    public int hashCode() {
        return this.getValue(true).hashCode();
    }

    public String toString() {
        return "CompoundWrite{" + this.getValue(true).toString() + "}";
    }
}

