/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.database.DatabaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class DatabaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> zzbGX = new HashMap<Integer, String>();
    private static final Map<String, Integer> zzbGY;
    private final int zzbGZ;
    private final String message;
    private final String zzbHa;

    public static DatabaseError zzhL(String string) {
        return DatabaseError.zzah(string, null);
    }

    public static DatabaseError zzah(String string, String string2) {
        return DatabaseError.zzp(string, string2, null);
    }

    public static DatabaseError zznw(int n) {
        if (!zzbGX.containsKey(n)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Invalid Firebase Database error code: ").append(n).toString());
        }
        String string = zzbGX.get(n);
        return new DatabaseError(n, string, null);
    }

    public static DatabaseError zzp(String string, String string2, String string3) {
        Integer n = zzbGY.get(string.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string4 = string2 == null ? zzbGX.get(n) : string2;
        return new DatabaseError(n, string4, string3);
    }

    public static DatabaseError fromException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = String.valueOf(zzbGX.get(-11));
        String string2 = String.valueOf(stringWriter.toString());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        return new DatabaseError(-11, string3);
    }

    private DatabaseError(int n, String string) {
        this(n, string, null);
    }

    private DatabaseError(int n, String string, String string2) {
        this.zzbGZ = n;
        this.message = string;
        this.zzbHa = string2 == null ? "" : string2;
    }

    public int getCode() {
        return this.zzbGZ;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.zzbHa;
    }

    public String toString() {
        String string = String.valueOf(this.message);
        return string.length() != 0 ? "DatabaseError: ".concat(string) : new String("DatabaseError: ");
    }

    public DatabaseException toException() {
        String string = String.valueOf(this.message);
        return new DatabaseException(string.length() != 0 ? "Firebase Database error: ".concat(string) : new String("Firebase Database error: "));
    }

    static {
        zzbGX.put(-1, "The transaction needs to be run again with current data");
        zzbGX.put(-2, "The server indicated that this operation failed");
        zzbGX.put(-3, "This client does not have permission to perform this operation");
        zzbGX.put(-4, "The operation had to be aborted due to a network disconnect");
        zzbGX.put(-6, "The supplied auth token has expired");
        zzbGX.put(-7, "The supplied auth token was invalid");
        zzbGX.put(-8, "The transaction had too many retries");
        zzbGX.put(-9, "The transaction was overridden by a subsequent set");
        zzbGX.put(-10, "The service is unavailable");
        zzbGX.put(-11, "User code called from the Firebase Database runloop threw an exception:\n");
        zzbGX.put(-24, "The operation could not be performed due to a network error");
        zzbGX.put(-25, "The write was canceled by the user.");
        zzbGX.put(-999, "An unknown error occurred");
        zzbGY = new HashMap<String, Integer>();
        zzbGY.put("datastale", -1);
        zzbGY.put("failure", -2);
        zzbGY.put("permission_denied", -3);
        zzbGY.put("disconnected", -4);
        zzbGY.put("expired_token", -6);
        zzbGY.put("invalid_token", -7);
        zzbGY.put("maxretries", -8);
        zzbGY.put("overriddenbyset", -9);
        zzbGY.put("unavailable", -10);
        zzbGY.put("network_error", -24);
        zzbGY.put("write_canceled", -25);
    }
}

