/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahk;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzaif;
import com.google.android.gms.internal.zzaiw;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzaja;
import com.google.android.gms.internal.zzajm;
import com.google.android.gms.internal.zzajx;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzakf;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzakm;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzalf;
import com.google.android.gms.internal.zzalj;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzalo;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class zzagg
implements zzaiw {
    private static final Charset pb = Charset.forName("UTF-8");
    private final SQLiteDatabase aPX;
    private final zzajx aPY;
    private boolean aPZ;
    private long aQa = 0L;

    public zzagg(Context context, zzahk zzahk2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        zza zza2 = new zza(context, string2);
        this.aPX = zza2.getWritableDatabase();
        this.aPY = zzahk2.zzrh("Persistence");
    }

    @Override
    public void zza(zzahr zzahr2, zzakm zzakm2, long l) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzbe(zzakm2.getValue(true));
        this.zza(zzahr2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Persisted user overwrite in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(zzahr zzahr2, zzahi zzahi2, long l) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzbe(zzahi2.zzcs(true));
        this.zza(zzahr2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Persisted user merge in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zzbv(long l) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        int n = this.aPX.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3), new Object[0]);
        }
    }

    @Override
    public List<zzaif> zzcmw() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzaif> arrayList = new ArrayList<zzaif>();
        try (Cursor cursor = this.aPX.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzaif> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzaif zzaif2;
                Iterable<zzakl> iterable;
                Object object;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzahr(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    object = new ArrayList<byte[]>();
                    do {
                        object.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = this.zzao((List<byte[]>)object);
                }
                object = new String(byArray, pb);
                Object object2 = zzalf.zzrr((String)object);
                if ("o".equals(string)) {
                    iterable = zzakn.zzbs(object2);
                    zzaif2 = new zzaif(l2, (zzahr)((Object)arrayList2), (zzakm)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzahi.zzbx((Map)object2);
                    zzaif2 = new zzaif(l2, (zzahr)((Object)arrayList2), (zzahi)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzaif2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.aPY.zzcum()) {
                this.aPY.zzh(String.format("Loaded %d writes in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void zza(zzahr zzahr2, long l, String string, byte[] byArray) {
        this.zzcna();
        this.aPX.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzagg.zzc(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzagg.zzc(zzahr2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.aPX.insertWithOnConflict("writes", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("path", zzagg.zzc(zzahr2));
            contentValues.put("type", string);
            contentValues.put("part", null);
            contentValues.put("node", byArray);
            this.aPX.insertWithOnConflict("writes", null, contentValues, 5);
        }
    }

    @Override
    public zzakm zza(zzahr zzahr2) {
        return this.zzb(zzahr2);
    }

    @Override
    public void zza(zzahr zzahr2, zzakm zzakm2) {
        this.zzcna();
        this.zza(zzahr2, zzakm2, false);
    }

    @Override
    public void zzb(zzahr zzahr2, zzakm zzakm2) {
        this.zzcna();
        this.zza(zzahr2, zzakm2, true);
    }

    private void zza(zzahr zzahr2, zzakm zzakm2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzahr2);
            n = this.zzc(zzahr2, zzakm2);
        } else {
            n2 = 0;
            n = 0;
            for (zzakl zzakl2 : zzakm2) {
                n2 += this.zza("serverCache", zzahr2.zza(zzakl2.zzcvs()));
                n += this.zzc(zzahr2.zza(zzakl2.zzcvs()), zzakl2.zzcmq());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzahr2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public void zza(zzahr zzahr2, zzahi zzahi2) {
        this.zzcna();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzahr, zzakm> entry : zzahi2) {
            n2 += this.zza("serverCache", zzahr2.zzh(entry.getKey()));
            n += this.zzc(zzahr2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzahr2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public long zzcmx() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.aPX.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public void zza(zzaiy zzaiy2) {
        this.zzcna();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzaiy2.id));
        contentValues.put("path", zzagg.zzc(zzaiy2.aWS.zzcmu()));
        contentValues.put("queryParams", zzaiy2.aWS.zzctz().zzctx());
        contentValues.put("lastUse", Long.valueOf(zzaiy2.aWT));
        contentValues.put("complete", Boolean.valueOf(zzaiy2.aWU));
        contentValues.put("active", Boolean.valueOf(zzaiy2.aWV));
        this.aPX.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Saved new tracked query in %dms", l2), new Object[0]);
        }
    }

    @Override
    public void zzbw(long l) {
        this.zzcna();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.aPX.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.aPX.delete("trackedKeys", string3, new String[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<zzaiy> zzcmy() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzaiy> arrayList = new ArrayList<zzaiy>();
        try (Cursor cursor = this.aPX.query("trackedQueries", stringArray, null, null, null, null, "id");){
            ArrayList<zzaiy> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzahr(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzalf.zzrq((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                zzajm zzajm2 = zzajm.zzb(arrayList2, map);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzaiy zzaiy2 = new zzaiy(l2, zzajm2, l3, bl, bl2);
                arrayList.add(zzaiy2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.aPY.zzcum()) {
                this.aPY.zzh(String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public void zzbx(long l) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.aPX.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Reset active tracked queries in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzaka> set) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.aPX.delete("trackedKeys", string2, new String[]{string});
        for (zzaka zzaka2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzaka2.asString());
            this.aPX.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzaka> set, Set<zzaka> set2) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzaka zzaka2 : set2) {
            this.aPX.delete("trackedKeys", string, new String[]{string2, zzaka2.asString()});
        }
        for (zzaka zzaka2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzaka2.asString());
            this.aPX.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public Set<zzaka> zzby(long l) {
        return this.zzh(Collections.singleton(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<zzaka> zzh(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(this.zzp(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.aPX.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzaka.zzrm(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.aPY.zzcum()) {
                this.aPY.zzh(String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2), new Object[0]);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public void zza(zzahr zzahr2, zzaix zzaix2) {
        Object object;
        String string;
        Iterable<Object> iterable;
        Iterable<zzaka> iterable2;
        if (!zzaix2.zzcsr()) {
            return;
        }
        this.zzcna();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzahr2, new String[]{"rowid", "path"});
        zzaja<Object> zzaja2 = new zzaja<Object>(null);
        zzaja<Object> zzaja3 = new zzaja<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzahr(cursor.getString(1));
            if (!zzahr2.zzi((zzahr)iterable2)) {
                iterable = String.valueOf(zzahr2);
                string = String.valueOf(iterable2);
                this.aPY.warn(new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string).append(". Ignoring.").toString());
                continue;
            }
            iterable = zzahr.zza(zzahr2, (zzahr)iterable2);
            if (zzaix2.zzw((zzahr)iterable)) {
                zzaja2 = zzaja2.zzb((zzahr)iterable, l2);
                continue;
            }
            if (zzaix2.zzx((zzahr)iterable)) {
                zzaja3 = zzaja3.zzb((zzahr)iterable, l2);
                continue;
            }
            string = String.valueOf(zzahr2);
            object = String.valueOf(iterable2);
            this.aPY.warn(new StringBuilder(88 + String.valueOf(string).length() + String.valueOf(object).length()).append("We are pruning at ").append(string).append(" and have data at ").append((String)object).append(" that isn't marked for pruning or keeping. Ignoring.").toString());
        }
        int n = 0;
        int n2 = 0;
        if (!zzaja2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzahr2, zzahr.zzcqy(), zzaja2, zzaja3, zzaix2, (List<zzall<zzahr, zzakm>>)iterable2);
            iterable = zzaja2.values();
            object = String.valueOf(this.zzp((Collection<Long>)iterable));
            string = new StringBuilder(11 + String.valueOf(object).length()).append("rowid IN (").append((String)object).append(")").toString();
            this.aPX.delete("serverCache", string, null);
            for (zzall zzall2 : iterable2) {
                this.zzc(zzahr2.zzh((zzahr)zzall2.getFirst()), (zzakm)zzall2.zzcwr());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3), new Object[0]);
        }
    }

    private void zza(zzahr zzahr2, final zzahr zzahr3, zzaja<Long> zzaja2, final zzaja<Long> zzaja3, zzaix zzaix2, final List<zzall<zzahr, zzakm>> list) {
        if (zzaja2.getValue() != null) {
            int n = zzaix2.zza(0, new zzaja.zza<Void, Integer>(){

                @Override
                public Integer zza(zzahr zzahr2, Void void_, Integer n) {
                    return zzaja3.zzak(zzahr2) == null ? n + 1 : n;
                }
            });
            if (n > 0) {
                zzahr zzahr4 = zzahr2.zzh(zzahr3);
                if (this.aPY.zzcum()) {
                    this.aPY.zzh(String.format("Need to rewrite %d nodes below path %s", n, zzahr4), new Object[0]);
                }
                final zzakm zzakm2 = this.zzb(zzahr4);
                zzaix2.zza(null, new zzaja.zza<Void, Void>(){

                    @Override
                    public Void zza(zzahr zzahr2, Void void_, Void void_2) {
                        if (zzaja3.zzak(zzahr2) == null) {
                            list.add(new zzall<zzahr, zzakm>(zzahr3.zzh(zzahr2), zzakm2.zzao(zzahr2)));
                        }
                        return null;
                    }
                });
            }
        } else {
            for (Map.Entry<zzaka, zzaja<Long>> entry : zzaja2.zzcsx()) {
                zzaka zzaka2 = entry.getKey();
                zzaix zzaix3 = zzaix2.zzd(entry.getKey());
                this.zza(zzahr2, zzahr3.zza(zzaka2), entry.getValue(), zzaja3.zze(zzaka2), zzaix3, list);
            }
        }
    }

    @Override
    public void zzcmz() {
        this.zzcna();
        long l = System.currentTimeMillis();
        int n = this.aPX.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Deleted %d (all) write(s) in %dms", n, l2), new Object[0]);
        }
    }

    @Override
    public void beginTransaction() {
        zzalo.zzb(!this.aPZ, "runInTransaction called when an existing transaction is already in progress.");
        if (this.aPY.zzcum()) {
            this.aPY.zzh("Starting transaction.", new Object[0]);
        }
        this.aPX.beginTransaction();
        this.aPZ = true;
        this.aQa = System.currentTimeMillis();
    }

    @Override
    public void endTransaction() {
        this.aPX.endTransaction();
        this.aPZ = false;
        long l = System.currentTimeMillis() - this.aQa;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Transaction completed. Elapsed: %dms", l), new Object[0]);
        }
    }

    @Override
    public void setTransactionSuccessful() {
        this.aPX.setTransactionSuccessful();
    }

    private void zzcna() {
        zzalo.zzb(this.aPZ, "Transaction expected to already be in progress.");
    }

    private int zzc(zzahr zzahr2, zzakm zzakm2) {
        long l = zzalj.zzs(zzakm2);
        if (zzakm2 instanceof zzakb && l > 16384L) {
            if (this.aPY.zzcum()) {
                this.aPY.zzh(String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzahr2, l, 16384), new Object[0]);
            }
            int n = 0;
            for (zzakl zzakl2 : zzakm2) {
                n += this.zzc(zzahr2.zza(zzakl2.zzcvs()), zzakl2.zzcmq());
            }
            if (!zzakm2.zzcux().isEmpty()) {
                this.zzd(zzahr2.zza(zzaka.zzcur()), zzakm2.zzcux());
                ++n;
            }
            this.zzd(zzahr2, zzakf.zzcvi());
            return ++n;
        }
        this.zzd(zzahr2, zzakm2);
        return 1;
    }

    private String zza(zzahr zzahr2, int n) {
        String string = String.valueOf(zzagg.zzc(zzahr2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private void zzd(zzahr zzahr2, zzakm zzakm2) {
        byte[] byArray = this.zzbe(zzakm2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzagg.zzc(byArray, 262144);
            if (this.aPY.zzcum()) {
                n = list.size();
                this.aPY.zzh(new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString(), new Object[0]);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", this.zza(zzahr2, n));
                contentValues.put("value", list.get(n));
                this.aPX.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("path", zzagg.zzc(zzahr2));
            contentValues.put("value", byArray);
            this.aPX.insertWithOnConflict("serverCache", null, contentValues, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private zzakm zzb(zzahr zzahr2) {
        zzahr zzahr3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzahr2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzakm zzakm2 = zzakf.zzcvi();
        boolean bl = false;
        HashMap<zzahr, void> hashMap = new HashMap<zzahr, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzahr3 = new zzahr(((String)object2).substring(0, ((String)object2).length() - ".part-0000".length()));
                int n = this.zza(zzahr3, arrayList, i);
                if (this.aPY.zzcum()) {
                    this.aPY.zzh(new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString(), new Object[0]);
                }
                zzakm zzakm3 = this.zzat(this.zzao(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzakm zzakm4 = this.zzat((byte[])arrayList2.get(i));
                zzahr3 = new zzahr((String)arrayList.get(i));
            }
            if (zzahr3.zzcre() != null && zzahr3.zzcre().zzcut()) {
                hashMap.put(zzahr3, object);
                continue;
            }
            if (zzahr3.zzi(zzahr2)) {
                zzalo.zzb(!bl, "Descendants of path must come after ancestors.");
                zzakm2 = object.zzao(zzahr.zza(zzahr3, zzahr2));
                continue;
            }
            if (zzahr2.zzi(zzahr3)) {
                bl = true;
                object2 = zzahr.zza(zzahr2, zzahr3);
                zzakm2 = zzakm2.zzl((zzahr)object2, (zzakm)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzahr3, zzahr2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzahr3 = (zzahr)entry.getKey();
            zzakm2 = zzakm2.zzl(zzahr.zza(zzahr2, zzahr3), (zzakm)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.aPY.zzcum()) {
            this.aPY.zzh(String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzalj.zzt(zzakm2), zzahr2, l7, l2, l4, l6), new Object[0]);
        }
        return zzakm2;
    }

    private int zza(zzahr zzahr2, List<String> list, int n) {
        int n2;
        String string = zzagg.zzc(zzahr2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(this.zza(zzahr2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private Cursor zza(zzahr zzahr2, String[] stringArray) {
        String string = zzagg.zzc(zzahr2);
        String string2 = zzagg.zzqt(string);
        String[] stringArray2 = new String[zzahr2.size() + 3];
        String string3 = zzagg.zzb(zzahr2, stringArray2);
        String string4 = String.valueOf(string3);
        String string5 = String.valueOf(" OR (path > ? AND path < ?)");
        string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        stringArray2[zzahr2.size() + 1] = string;
        stringArray2[zzahr2.size() + 2] = string2;
        String string6 = "path";
        return this.aPX.query("serverCache", stringArray, string3, stringArray2, null, null, string6);
    }

    private static String zzc(zzahr zzahr2) {
        if (zzahr2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzahr2.toString()).concat("/");
    }

    private static String zzqt(String string) {
        assert (string.endsWith("/")) : "Path keys must end with a '/'";
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        int n = 48;
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private static String zzb(zzahr zzahr2, String[] stringArray) {
        assert (stringArray.length >= zzahr2.size() + 1);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzahr2.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray[n] = zzagg.zzc(zzahr2);
            zzahr2 = zzahr2.zzcrd();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray[n] = zzagg.zzc(zzahr.zzcqy());
        return stringBuilder.toString();
    }

    private int zza(String string, zzahr zzahr2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzagg.zzc(zzahr2);
        String string4 = zzagg.zzqt(string3);
        return this.aPX.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzc(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / n + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(n, byArray.length - i * n);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * n, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private byte[] zzao(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private byte[] zzbe(Object object) {
        try {
            return zzalf.zzbu((Object)object).getBytes(pb);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private zzakm zzat(byte[] byArray) {
        try {
            Object object = zzalf.zzrr((String)new String(byArray, pb));
            return zzakn.zzbs(object);
        }
        catch (IOException iOException) {
            String string = new String(byArray, pb);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private String zzp(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }

    private static class zza
    extends SQLiteOpenHelper {
        public zza(Context context, String string) {
            super(context, string, null, 2);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            sQLiteDatabase.execSQL("CREATE TABLE writes (id INTEGER, path TEXT, type TEXT, part INTEGER, node BLOB, UNIQUE (id, part));");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            assert (n2 == 2) : "Why is onUpgrade() called with a different version?";
            if (n > 1) {
                throw new AssertionError((Object)new StringBuilder(40).append("We don't handle upgrading to ").append(n2).toString());
            }
            this.zzd(sQLiteDatabase, "serverCache");
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            this.zzd(sQLiteDatabase, "complete");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
        }

        private void zzd(SQLiteDatabase sQLiteDatabase, String string) {
            String string2 = String.valueOf(string);
            sQLiteDatabase.execSQL(string2.length() != 0 ? "DROP TABLE IF EXISTS ".concat(string2) : new String("DROP TABLE IF EXISTS "));
        }
    }
}

