/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaka;
import com.google.firebase.database.DatabaseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class zzahr
implements Comparable<zzahr>,
Iterable<zzaka> {
    private final zzaka[] aTM;
    private final int start;
    private final int end;
    private static final zzahr aTN = new zzahr("");

    public static zzahr zza(zzahr zzahr2, zzahr zzahr3) {
        zzaka zzaka2 = zzahr2.zzcrb();
        zzaka zzaka3 = zzahr3.zzcrb();
        if (zzaka2 == null) {
            return zzahr3;
        }
        if (zzaka2.equals(zzaka3)) {
            return zzahr.zza(zzahr2.zzcrc(), zzahr3.zzcrc());
        }
        String string = String.valueOf(zzahr3);
        String string2 = String.valueOf(zzahr2);
        throw new DatabaseException(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("INTERNAL ERROR: ").append(string).append(" is not contained in ").append(string2).toString());
    }

    public static zzahr zzcqy() {
        return aTN;
    }

    public zzahr(zzaka ... zzakaArray) {
        this.aTM = Arrays.copyOf(zzakaArray, zzakaArray.length);
        this.start = 0;
        this.end = zzakaArray.length;
        for (zzaka zzaka2 : zzakaArray) {
            assert (zzaka2 != null) : "Can't construct a path with a null value!";
        }
    }

    public zzahr(List<String> list) {
        this.aTM = new zzaka[list.size()];
        int n = 0;
        for (String string : list) {
            this.aTM[n++] = zzaka.zzrm(string);
        }
        this.start = 0;
        this.end = list.size();
    }

    public zzahr(String string) {
        String[] stringArray = string.split("/");
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.length() <= 0) continue;
            ++n;
        }
        this.aTM = new zzaka[n];
        int n2 = 0;
        for (String string3 : stringArray) {
            if (string3.length() <= 0) continue;
            this.aTM[n2++] = zzaka.zzrm(string3);
        }
        this.start = 0;
        this.end = this.aTM.length;
    }

    private zzahr(zzaka[] zzakaArray, int n, int n2) {
        this.aTM = zzakaArray;
        this.start = n;
        this.end = n2;
    }

    public zzahr zzh(zzahr zzahr2) {
        int n = this.size() + zzahr2.size();
        zzaka[] zzakaArray = new zzaka[n];
        System.arraycopy(this.aTM, this.start, zzakaArray, 0, this.size());
        System.arraycopy(zzahr2.aTM, zzahr2.start, zzakaArray, this.size(), zzahr2.size());
        return new zzahr(zzakaArray, 0, n);
    }

    public zzahr zza(zzaka zzaka2) {
        int n = this.size();
        zzaka[] zzakaArray = new zzaka[n + 1];
        System.arraycopy(this.aTM, this.start, zzakaArray, 0, n);
        zzakaArray[n] = zzaka2;
        return new zzahr(zzakaArray, 0, n + 1);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.aTM[i].asString());
        }
        return stringBuilder.toString();
    }

    public String zzcqz() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            if (i > this.start) {
                stringBuilder.append("/");
            }
            stringBuilder.append(this.aTM[i].asString());
        }
        return stringBuilder.toString();
    }

    public List<String> zzcra() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (zzaka zzaka2 : this) {
            arrayList.add(zzaka2.asString());
        }
        return arrayList;
    }

    public zzaka zzcrb() {
        if (this.isEmpty()) {
            return null;
        }
        return this.aTM[this.start];
    }

    public zzahr zzcrc() {
        int n = this.start;
        if (!this.isEmpty()) {
            ++n;
        }
        return new zzahr(this.aTM, n, this.end);
    }

    public zzahr zzcrd() {
        if (this.isEmpty()) {
            return null;
        }
        return new zzahr(this.aTM, this.start, this.end - 1);
    }

    public zzaka zzcre() {
        if (!this.isEmpty()) {
            return this.aTM[this.end - 1];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.start >= this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public Iterator<zzaka> iterator() {
        return new Iterator<zzaka>(){
            int offset;
            {
                this.offset = zzahr.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.offset < zzahr.this.end;
            }

            public zzaka zzcrf() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements.");
                }
                zzaka zzaka2 = zzahr.this.aTM[this.offset];
                ++this.offset;
                return zzaka2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove component from immutable Path!");
            }

            @Override
            public /* synthetic */ Object next() {
                return this.zzcrf();
            }
        };
    }

    public boolean zzi(zzahr zzahr2) {
        if (this.size() > zzahr2.size()) {
            return false;
        }
        int n = this.start;
        int n2 = zzahr2.start;
        while (n < this.end) {
            if (!this.aTM[n].equals(zzahr2.aTM[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof zzahr)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        zzahr zzahr2 = (zzahr)object;
        if (this.size() != zzahr2.size()) {
            return false;
        }
        int n = this.start;
        for (int i = zzahr2.start; n < this.end && i < zzahr2.end; ++n, ++i) {
            if (this.aTM[n].equals(zzahr2.aTM[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.start; i < this.end; ++i) {
            n = n * 37 + this.aTM[i].hashCode();
        }
        return n;
    }

    public int zzj(zzahr zzahr2) {
        int n;
        int n2 = this.start;
        for (n = zzahr2.start; n2 < this.end && n < zzahr2.end; ++n2, ++n) {
            int n3 = this.aTM[n2].zzi(zzahr2.aTM[n]);
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 == this.end && n == zzahr2.end) {
            return 0;
        }
        if (n2 == this.end) {
            return -1;
        }
        return 1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zzj((zzahr)object);
    }
}

