/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Log;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.Exclude;
import com.google.firebase.database.GenericTypeIndicator;
import com.google.firebase.database.IgnoreExtraProperties;
import com.google.firebase.database.PropertyName;
import com.google.firebase.database.ThrowOnExtraProperties;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class zzalq {
    private static final ConcurrentMap<Class<?>, zza<?>> bat = new ConcurrentHashMap();

    public static Object zzbx(Object object) {
        return zzalq.zzby(object);
    }

    public static <T> T zza(Object object, Class<T> clazz) {
        return zzalq.zzb(object, clazz);
    }

    public static <T> T zza(Object object, GenericTypeIndicator<T> genericTypeIndicator) {
        Class<?> clazz = genericTypeIndicator.getClass();
        Type type = clazz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!parameterizedType.getRawType().equals(GenericTypeIndicator.class)) {
                String string = String.valueOf(type);
                throw new DatabaseException(new StringBuilder(47 + String.valueOf(string).length()).append("Not a direct subclass of GenericTypeIndicator: ").append(string).toString());
            }
            Type type2 = parameterizedType.getActualTypeArguments()[0];
            return zzalq.zza(object, type2);
        }
        String string = String.valueOf(type);
        throw new DatabaseException(new StringBuilder(47 + String.valueOf(string).length()).append("Not a direct subclass of GenericTypeIndicator: ").append(string).toString());
    }

    private static <T> Object zzby(T t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Number) {
            if (t instanceof Float) {
                return ((Float)t).doubleValue();
            }
            if (t instanceof Short) {
                throw new DatabaseException("Shorts are not supported, please use int or long");
            }
            if (t instanceof Byte) {
                throw new DatabaseException("Bytes are not supported, please use int or long");
            }
            return t;
        }
        if (t instanceof String) {
            return t;
        }
        if (t instanceof Boolean) {
            return t;
        }
        if (t instanceof Character) {
            throw new DatabaseException("Characters are not supported, please strings");
        }
        if (t instanceof Map) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)t).entrySet()) {
                Object k = entry.getKey();
                if (k instanceof String) {
                    String string = (String)k;
                    hashMap.put(string, zzalq.zzby(entry.getValue()));
                    continue;
                }
                throw new DatabaseException("Maps with non-string keys are not supported");
            }
            return hashMap;
        }
        if (t instanceof Collection) {
            if (t instanceof List) {
                List list = (List)t;
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                for (Object e : list) {
                    arrayList.add(zzalq.zzby(e));
                }
                return arrayList;
            }
            throw new DatabaseException("Serializing Collections is not supported, please use Lists instead");
        }
        if (t.getClass().isArray()) {
            throw new DatabaseException("Serializing Arrays is not supported, please use Lists instead");
        }
        Class<?> clazz = t.getClass();
        zza<?> zza2 = zzalq.zzj(clazz);
        return zza2.zzcg(t);
    }

    private static <T> T zza(Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return zzalq.zza(object, (ParameterizedType)type);
        }
        if (type instanceof Class) {
            return zzalq.zzb(object, (Class)type);
        }
        if (type instanceof WildcardType) {
            throw new DatabaseException("Generic wildcard types are not supported");
        }
        if (type instanceof GenericArrayType) {
            throw new DatabaseException("Generic Arrays are not supported, please use Lists instead");
        }
        String string = String.valueOf(type);
        throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("Unknown type encountered: ").append(string).toString());
    }

    private static <T> T zzb(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            return zzalq.zzc(object, clazz);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)zzalq.zzce(object);
        }
        if (clazz.isArray()) {
            throw new DatabaseException("Converting to Arrays is not supported, please use Listsinstead");
        }
        if (clazz.getTypeParameters().length > 0) {
            String string = String.valueOf(clazz.getName());
            throw new DatabaseException(new StringBuilder(75 + String.valueOf(string).length()).append("Class ").append(string).append(" has generic type parameters, please use GenericTypeIndicator instead").toString());
        }
        if (clazz.equals(Object.class)) {
            return (T)object;
        }
        return zzalq.zzd(object, clazz);
    }

    private static <T> T zza(Object object, ParameterizedType parameterizedType) {
        Class clazz = (Class)parameterizedType.getRawType();
        if (List.class.isAssignableFrom(clazz)) {
            Type type = parameterizedType.getActualTypeArguments()[0];
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<T> arrayList = new ArrayList<T>(list.size());
                for (Object e : list) {
                    arrayList.add(zzalq.zza(e, type));
                }
                return (T)arrayList;
            }
            String string = String.valueOf(object.getClass());
            throw new DatabaseException(new StringBuilder(47 + String.valueOf(string).length()).append("Expected a List while deserializing, but got a ").append(string).toString());
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Type type = parameterizedType.getActualTypeArguments()[0];
            Type type2 = parameterizedType.getActualTypeArguments()[1];
            if (!type.equals(String.class)) {
                String string = String.valueOf(type);
                throw new DatabaseException(new StringBuilder(70 + String.valueOf(string).length()).append("Only Maps with string keys are supported, but found Map with key type ").append(string).toString());
            }
            Map<String, Object> map = zzalq.zzbz(object);
            HashMap<String, T> hashMap = new HashMap<String, T>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), zzalq.zza(entry.getValue(), type2));
            }
            return (T)hashMap;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            throw new DatabaseException("Collections are not supported, please use Lists instead");
        }
        Map<String, Object> map = zzalq.zzbz(object);
        zza zza2 = zzalq.zzj(clazz);
        HashMap hashMap = new HashMap();
        TypeVariable<Class<T>>[] typeVariableArray = zza2.bau.getTypeParameters();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (typeArray.length != typeVariableArray.length) {
            throw new IllegalStateException("Mismatched lengths for type variables and actual types");
        }
        for (int i = 0; i < typeVariableArray.length; ++i) {
            hashMap.put(typeVariableArray[i], typeArray[i]);
        }
        return zza2.zze(map, hashMap);
    }

    private static <T> T zzc(Object object, Class<T> clazz) {
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return (T)zzalq.zzca(object);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return (T)zzalq.zzcd(object);
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return (T)zzalq.zzcc(object);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return (T)zzalq.zzcb(object);
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return (T)Float.valueOf(zzalq.zzcc(object).floatValue());
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            throw new DatabaseException("Deserializing to shorts is not supported");
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            throw new DatabaseException("Deserializing to bytes is not supported");
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            throw new DatabaseException("Deserializing to char is not supported");
        }
        String string = String.valueOf(clazz);
        throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("Unknown primitive type: ").append(string).toString());
    }

    private static <T> zza<T> zzj(Class<T> clazz) {
        zza<T> zza2 = (zza<T>)bat.get(clazz);
        if (zza2 == null) {
            zza2 = new zza<T>(clazz);
            bat.put(clazz, zza2);
        }
        return zza2;
    }

    private static Map<String, Object> zzbz(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        String string = String.valueOf(object.getClass());
        throw new DatabaseException(new StringBuilder(46 + String.valueOf(string).length()).append("Expected a Map while deserializing, but got a ").append(string).toString());
    }

    private static Integer zzca(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long || object instanceof Double) {
            double d = ((Number)object).doubleValue();
            if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                return ((Number)object).intValue();
            }
            throw new DatabaseException(new StringBuilder(124).append("Numeric value out of 32-bit integer range: ").append(d).append(". Did you mean to use a long or double instead of an int?").toString());
        }
        String string = String.valueOf(object.getClass().getName());
        throw new DatabaseException(new StringBuilder(41 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to int").toString());
    }

    private static Long zzcb(Object object) {
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                return d.longValue();
            }
            String string = String.valueOf(d);
            throw new DatabaseException(new StringBuilder(89 + String.valueOf(string).length()).append("Numeric value out of 64-bit long range: ").append(string).append(". Did you mean to use a double instead of a long?").toString());
        }
        String string = String.valueOf(object.getClass().getName());
        throw new DatabaseException(new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to long").toString());
    }

    private static Double zzcc(Object object) {
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            Double d = ((Long)object).doubleValue();
            if (d.longValue() == l.longValue()) {
                return d;
            }
            String string = String.valueOf(object);
            throw new DatabaseException(new StringBuilder(97 + String.valueOf(string).length()).append("Loss of precision while converting number to double: ").append(string).append(". Did you mean to use a 64-bit long instead?").toString());
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        String string = String.valueOf(object.getClass().getName());
        throw new DatabaseException(new StringBuilder(44 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to double").toString());
    }

    private static Boolean zzcd(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = String.valueOf(object.getClass().getName());
        throw new DatabaseException(new StringBuilder(43 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to boolean").toString());
    }

    private static String zzce(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        String string = String.valueOf(object.getClass().getName());
        throw new DatabaseException(new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to String").toString());
    }

    private static <T> T zzd(Object object, Class<T> clazz) {
        zza<T> zza2 = zzalq.zzj(clazz);
        if (object instanceof Map) {
            return zza2.zzcc(zzalq.zzbz(object));
        }
        String string = String.valueOf(object.getClass().getName());
        String string2 = String.valueOf(clazz.getName());
        throw new DatabaseException(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Can't convert object of type ").append(string).append(" to type ").append(string2).toString());
    }

    private static class zza<T> {
        private final Class<T> bau;
        private final Constructor<T> bav;
        private final boolean baw;
        private final boolean bax;
        private final Map<String, String> bay;
        private final Map<String, Method> baz;
        private final Map<String, Method> baA;
        private final Map<String, Field> baB;

        public zza(Class<T> clazz) {
            String string;
            this.bau = clazz;
            this.baw = clazz.isAnnotationPresent(ThrowOnExtraProperties.class);
            this.bax = !clazz.isAnnotationPresent(IgnoreExtraProperties.class);
            this.bay = new HashMap<String, String>();
            this.baA = new HashMap<String, Method>();
            this.baz = new HashMap<String, Method>();
            this.baB = new HashMap<String, Field>();
            Constructor<T> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = null;
            }
            this.bav = constructor;
            for (Method accessibleObject : clazz.getDeclaredMethods()) {
                if (!zza.zza(accessibleObject)) continue;
                string = zza.zzc(accessibleObject);
                this.zzsd(string);
                accessibleObject.setAccessible(true);
                if (this.baz.containsKey(string)) {
                    String string2 = String.valueOf(accessibleObject.getName());
                    throw new DatabaseException(string2.length() != 0 ? "Found conflicting getters for name: ".concat(string2) : new String("Found conflicting getters for name: "));
                }
                this.baz.put(string, accessibleObject);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                if (!zza.zza((Field)accessibleObject)) continue;
                string = zza.zzb((Field)accessibleObject);
                this.zzsd(string);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                String string3;
                if (!zza.zzb((Method)accessibleObject) || (string3 = this.bay.get((string = zza.zzc((Method)accessibleObject)).toLowerCase())) == null) continue;
                if (!string3.equals(string)) {
                    String string4 = String.valueOf(((Method)accessibleObject).getName());
                    throw new DatabaseException(string4.length() != 0 ? "Found setter with invalid case-sensitive name: ".concat(string4) : new String("Found setter with invalid case-sensitive name: "));
                }
                if (this.baA.containsKey(string)) {
                    String string5 = String.valueOf(((Method)accessibleObject).getName());
                    throw new DatabaseException(string5.length() != 0 ? "Found two conflicting setters with name: ".concat(string5) : new String("Found two conflicting setters with name: "));
                }
                ((Method)accessibleObject).setAccessible(true);
                this.baA.put(string, (Method)accessibleObject);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                string = zza.zzb((Field)accessibleObject);
                if (!this.bay.containsKey(string.toLowerCase())) continue;
                ((Field)accessibleObject).setAccessible(true);
                this.baB.put(string, (Field)accessibleObject);
            }
            if (this.bay.isEmpty()) {
                String string6 = String.valueOf(clazz.getName());
                throw new DatabaseException(string6.length() != 0 ? "No properties to serialize found on class ".concat(string6) : new String("No properties to serialize found on class "));
            }
        }

        private void zzsd(String string) {
            String string2 = this.bay.put(string.toLowerCase(), string);
            if (string2 != null && !string.equals(string2)) {
                String string3 = String.valueOf(string.toLowerCase());
                throw new DatabaseException(string3.length() != 0 ? "Found two getters or fields with conflicting case sensitivity for property: ".concat(string3) : new String("Found two getters or fields with conflicting case sensitivity for property: "));
            }
        }

        public T zzcc(Map<String, Object> map) {
            return this.zze(map, Collections.emptyMap());
        }

        public T zze(Map<String, Object> map, Map<TypeVariable<Class<T>>, Type> map2) {
            T t;
            if (this.bav == null) {
                String string = String.valueOf(this.bau.getName());
                throw new DatabaseException(new StringBuilder(49 + String.valueOf(string).length()).append("Class ").append(string).append(" is missing a constructor with no arguments").toString());
            }
            try {
                t = this.bav.newInstance(new Object[0]);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object object;
                Object object2;
                Object object3;
                String string = entry.getKey();
                if (this.baA.containsKey(string)) {
                    object3 = this.baA.get(string);
                    object2 = ((Method)object3).getGenericParameterTypes();
                    if (((Type[])object2).length != 1) {
                        throw new IllegalStateException("Setter does not have exactly one parameter");
                    }
                    object = this.zza(object2[0], map2);
                    Object object4 = zzalq.zza(entry.getValue(), (Type)object);
                    try {
                        ((Method)object3).invoke(t, object4);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new RuntimeException(invocationTargetException);
                    }
                }
                if (this.baB.containsKey(string)) {
                    object3 = this.baB.get(string);
                    object2 = this.zza(((Field)object3).getGenericType(), map2);
                    object = zzalq.zza(entry.getValue(), (Type)object2);
                    try {
                        ((Field)object3).set(t, object);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                }
                object2 = String.valueOf(this.bau.getName());
                object3 = new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(object2).length()).append("No setter/field for ").append(string).append(" found on class ").append((String)object2).toString();
                if (this.bay.containsKey(string.toLowerCase())) {
                    object3 = String.valueOf(object3).concat(" (fields/setters are case sensitive!)");
                }
                if (this.baw) {
                    throw new DatabaseException((String)object3);
                }
                if (!this.bax) continue;
                Log.w((String)"ClassMapper", (String)object3);
            }
            return t;
        }

        private Type zza(Type type, Map<TypeVariable<Class<T>>, Type> map) {
            if (type instanceof TypeVariable) {
                Type type2 = map.get(type);
                if (type2 == null) {
                    String string = String.valueOf(type);
                    throw new IllegalStateException(new StringBuilder(23 + String.valueOf(string).length()).append("Could not resolve type ").append(string).toString());
                }
                return type2;
            }
            return type;
        }

        public Map<String, Object> zzcg(T t) {
            if (!this.bau.isAssignableFrom(t.getClass())) {
                String string = String.valueOf(t.getClass());
                String string2 = String.valueOf(this.bau);
                throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Can't serialize object of class ").append(string).append(" with BeanMapper for class ").append(string2).toString());
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : this.bay.values()) {
                Object object;
                Object object2;
                if (this.baz.containsKey(string)) {
                    object2 = this.baz.get(string);
                    try {
                        object = ((Method)object2).invoke(t, new Object[0]);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new RuntimeException(invocationTargetException);
                    }
                }
                object2 = this.baB.get(string);
                if (object2 == null) {
                    String string3 = String.valueOf(string);
                    throw new IllegalStateException(string3.length() != 0 ? "Bean property without field or getter:".concat(string3) : new String("Bean property without field or getter:"));
                }
                try {
                    object = ((Field)object2).get(t);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                object2 = zzalq.zzby(object);
                hashMap.put(string, object2);
            }
            return hashMap;
        }

        private static boolean zza(Method method) {
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
                return false;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 0) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean zzb(Method method) {
            if (!method.getName().startsWith("set")) {
                return false;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 1) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean zza(Field field) {
            if (!Modifier.isPublic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isTransient(field.getModifiers())) {
                return false;
            }
            return !field.isAnnotationPresent(Exclude.class);
        }

        private static String zzb(Field field) {
            String string = zza.zza((AccessibleObject)field);
            return string != null ? string : field.getName();
        }

        private static String zzc(Method method) {
            String string = zza.zza((AccessibleObject)method);
            return string != null ? string : zza.zzse(method.getName());
        }

        private static String zza(AccessibleObject accessibleObject) {
            if (accessibleObject.isAnnotationPresent(PropertyName.class)) {
                PropertyName propertyName = accessibleObject.getAnnotation(PropertyName.class);
                return propertyName.value();
            }
            return null;
        }

        private static String zzse(String string) {
            int n;
            String[] stringArray = new String[]{"get", "set", "is"};
            String string2 = null;
            Object object = stringArray;
            int n2 = 3;
            for (n = 0; n < 3; ++n) {
                String string3 = object[n];
                if (!string.startsWith(string3)) continue;
                string2 = string3;
            }
            if (string2 == null) {
                String string4 = String.valueOf(string);
                throw new IllegalArgumentException(string4.length() != 0 ? "Unknown Bean prefix for method: ".concat(string4) : new String("Unknown Bean prefix for method: "));
            }
            object = string.substring(string2.length());
            char[] cArray = ((String)object).toCharArray();
            for (n = 0; n < cArray.length && Character.isUpperCase(cArray[n]); ++n) {
                cArray[n] = Character.toLowerCase(cArray[n]);
            }
            return new String(cArray);
        }
    }
}

