/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzahl;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzaht;
import com.google.android.gms.internal.zzahu;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzalo;
import com.google.android.gms.internal.zzalp;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, FirebaseDatabase> aPn = new HashMap<String, FirebaseDatabase>();
    private final FirebaseApp aPo;
    private final zzahu aPp;
    private final zzahl aPq;
    private zzaht aPr;

    public static FirebaseDatabase getInstance() {
        return FirebaseDatabase.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        if (!aPn.containsKey(firebaseApp.getName())) {
            String string = firebaseApp.getOptions().getDatabaseUrl();
            if (string == null) {
                throw new DatabaseException("Failed to get FirebaseDatabase instance: FirebaseApp object has no DatabaseURL in its FirebaseOptions object.");
            }
            zzalm zzalm2 = zzalo.zzrs(string);
            if (!zzalm2.aPz.isEmpty()) {
                String string2 = String.valueOf(zzalm2.aPz.toString());
                throw new DatabaseException(new StringBuilder(114 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Configured Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
            }
            zzahl zzahl2 = new zzahl();
            if (!firebaseApp.zzckb()) {
                zzahl2.zzrk(firebaseApp.getName());
            }
            zzahl2.zze(firebaseApp);
            aPn.put(firebaseApp.getName(), new FirebaseDatabase(firebaseApp, zzalm2.aPp, zzahl2));
        }
        return aPn.get(firebaseApp.getName());
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzahu zzahu2, zzahl zzahl2) {
        this.aPo = firebaseApp;
        this.aPp = zzahu2;
        this.aPq = zzahl2;
    }

    public FirebaseApp getApp() {
        return this.aPo;
    }

    public DatabaseReference getReference() {
        this.zzcmp();
        return new DatabaseReference(this.aPr, zzahr.zzcqy());
    }

    public DatabaseReference getReference(String string) {
        this.zzcmp();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzalp.zzry(string);
        zzahr zzahr2 = new zzahr(string);
        return new DatabaseReference(this.aPr, zzahr2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzcmp();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzalm zzalm2 = zzalo.zzrs(string);
        if (!zzalm2.aPp.aRd.equals(this.aPr.zzcrh().aRd)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.aPr, zzalm2.aPz);
    }

    public void purgeOutstandingWrites() {
        this.zzcmp();
        this.aPr.zzr(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.aPr.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.zzcmp();
        zzahv.zzl(this.aPr);
    }

    public void goOffline() {
        this.zzcmp();
        zzahv.zzk(this.aPr);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzqr("setLogLevel");
        this.aPq.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzqr("setPersistenceEnabled");
        this.aPq.setPersistenceEnabled(bl);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private void zzqr(String string) {
        if (this.aPr != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private synchronized void zzcmp() {
        if (this.aPr == null) {
            this.aPr = zzahv.zza(this.aPq, this.aPp, this);
        }
    }
}

