/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzahm;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzaht;
import com.google.android.gms.internal.zzaih;
import com.google.android.gms.internal.zzaik;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzajm;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzake;
import com.google.android.gms.internal.zzakf;
import com.google.android.gms.internal.zzaki;
import com.google.android.gms.internal.zzakm;
import com.google.android.gms.internal.zzako;
import com.google.android.gms.internal.zzakp;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzaks;
import com.google.android.gms.internal.zzakt;
import com.google.android.gms.internal.zzalo;
import com.google.android.gms.internal.zzalp;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;

public class Query {
    protected final zzaht aPr;
    protected final zzahr aPz;
    protected final zzajl aPC;
    private final boolean aPD;

    Query(zzaht zzaht2, zzahr zzahr2, zzajl zzajl2, boolean bl) throws DatabaseException {
        this.aPr = zzaht2;
        this.aPz = zzahr2;
        this.aPC = zzajl2;
        this.aPD = bl;
        zzalo.zzb(zzajl2.isValid(), "Validation of queries failed.");
    }

    Query(zzaht zzaht2, zzahr zzahr2) {
        this.aPr = zzaht2;
        this.aPz = zzahr2;
        this.aPC = zzajl.aXM;
        this.aPD = false;
    }

    private void zza(zzajl zzajl2) {
        if (zzajl2.zzcts().equals(zzaki.zzcvp())) {
            zzaka zzaka2;
            zzakm zzakm2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzajl2.zzctk()) {
                zzakm2 = zzajl2.zzctl();
                zzaka2 = zzajl2.zzctm();
                if (zzaka2 != zzaka.zzcup() || !(zzakm2 instanceof zzaks)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzajl2.zzctn()) {
                zzakm2 = zzajl2.zzcto();
                zzaka2 = zzajl2.zzctp();
                if (zzaka2 != zzaka.zzcuq() || !(zzakm2 instanceof zzaks)) {
                    throw new IllegalArgumentException(string);
                }
            }
        } else if (zzajl2.zzcts().equals(zzakp.zzcvt()) && (zzajl2.zzctk() && !zzakq.zzp(zzajl2.zzctl()) || zzajl2.zzctn() && !zzakq.zzp(zzajl2.zzcto()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private void zzb(zzajl zzajl2) {
        if (zzajl2.zzctk() && zzajl2.zzctn() && zzajl2.zzctq() && !zzajl2.zzctr()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private void zzcms() {
        if (this.aPC.zzctk()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.aPC.zzctn()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private void zzcmt() {
        if (this.aPD) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzaih(this.aPr, valueEventListener, this.zzcmv()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzahh(this.aPr, childEventListener, this.zzcmv()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(final ValueEventListener valueEventListener) {
        this.zzb(new zzaih(this.aPr, new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot dataSnapshot) {
                Query.this.removeEventListener(this);
                valueEventListener.onDataChange(dataSnapshot);
            }

            @Override
            public void onCancelled(DatabaseError databaseError) {
                valueEventListener.onCancelled(databaseError);
            }
        }, this.zzcmv()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzaih(this.aPr, valueEventListener, this.zzcmv()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzahh(this.aPr, childEventListener, this.zzcmv()));
    }

    private void zza(final zzahm zzahm2) {
        zzaik.zzcsd().zzk(zzahm2);
        this.aPr.zzr(new Runnable(){

            @Override
            public void run() {
                Query.this.aPr.zze(zzahm2);
            }
        });
    }

    private void zzb(final zzahm zzahm2) {
        zzaik.zzcsd().zzi(zzahm2);
        this.aPr.zzr(new Runnable(){

            @Override
            public void run() {
                Query.this.aPr.zzf(zzahm2);
            }
        });
    }

    public void keepSynced(final boolean bl) {
        if (!this.aPz.isEmpty() && this.aPz.zzcrb().equals(zzaka.zzcus())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.aPr.zzr(new Runnable(){

            @Override
            public void run() {
                Query.this.aPr.zza(Query.this.zzcmv(), bl);
            }
        });
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzakm zzakm2 = string != null ? new zzaks(string, zzakq.zzcvu()) : zzakf.zzcvi();
        return this.zza(zzakm2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzake(d, zzakq.zzcvu()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzajz(bl, zzakq.zzcvu()), string);
    }

    private Query zza(zzakm zzakm2, String string) {
        zzalp.zzsb(string);
        if (!zzakm2.zzcuw() && !zzakm2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.aPC.zzctk()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzaka zzaka2 = string != null ? zzaka.zzrm(string) : null;
        zzajl zzajl2 = this.aPC.zza(zzakm2, zzaka2);
        this.zzb(zzajl2);
        this.zza(zzajl2);
        assert (zzajl2.isValid());
        return new Query(this.aPr, this.aPz, zzajl2, this.aPD);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzakm zzakm2 = string != null ? new zzaks(string, zzakq.zzcvu()) : zzakf.zzcvi();
        return this.zzb(zzakm2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzake(d, zzakq.zzcvu()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzajz(bl, zzakq.zzcvu()), string);
    }

    private Query zzb(zzakm zzakm2, String string) {
        zzaka zzaka2;
        zzalp.zzsb(string);
        if (!zzakm2.zzcuw() && !zzakm2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzaka zzaka3 = zzaka2 = string != null ? zzaka.zzrm(string) : null;
        if (this.aPC.zzctn()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzajl zzajl2 = this.aPC.zzb(zzakm2, zzaka2);
        this.zzb(zzajl2);
        this.zza(zzajl2);
        assert (zzajl2.isValid());
        return new Query(this.aPr, this.aPz, zzajl2, this.aPD);
    }

    public Query equalTo(String string) {
        this.zzcms();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzcms();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzcms();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzcms();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzcms();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzcms();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.aPC.zzctq()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.aPr, this.aPz, this.aPC.zzado(n), this.aPD);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.aPC.zzctq()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.aPr, this.aPz, this.aPC.zzadp(n), this.aPD);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzalp.zzrx(string);
        this.zzcmt();
        zzahr zzahr2 = new zzahr(string);
        if (zzahr2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzako zzako2 = new zzako(zzahr2);
        return new Query(this.aPr, this.aPz, this.aPC.zza(zzako2), true);
    }

    public Query orderByPriority() {
        this.zzcmt();
        zzajl zzajl2 = this.aPC.zza(zzakp.zzcvt());
        this.zza(zzajl2);
        return new Query(this.aPr, this.aPz, zzajl2, true);
    }

    public Query orderByKey() {
        this.zzcmt();
        zzajl zzajl2 = this.aPC.zza(zzaki.zzcvp());
        this.zza(zzajl2);
        return new Query(this.aPr, this.aPz, zzajl2, true);
    }

    public Query orderByValue() {
        this.zzcmt();
        return new Query(this.aPr, this.aPz, this.aPC.zza(zzakt.zzcvv()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.aPr, this.zzcmu());
    }

    public zzahr zzcmu() {
        return this.aPz;
    }

    public zzajm zzcmv() {
        return new zzajm(this.aPz, this.aPC);
    }
}

