/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzagi;
import com.google.android.gms.internal.zzagn;
import com.google.android.gms.internal.zzagq;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class zzagh<K, V>
extends zzagi<K, V> {
    private final K[] aQg;
    private final V[] aQh;
    private final Comparator<K> aQi;

    public static <A, B, C> zzagh<A, C> zza(List<A> list, Map<B, C> map, zzagi.zza.zza<A, B> zza2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zza2.zzbj(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzagh<Object, Object>(comparator, objectArray, objectArray2);
    }

    public static <K, V> zzagh<K, V> zza(Map<K, V> map, Comparator<K> comparator) {
        return zzagh.zza(new ArrayList<K>(map.keySet()), map, zzagi.zza.zzcnf(), comparator);
    }

    public zzagh(Comparator<K> comparator) {
        this.aQg = new Object[0];
        this.aQh = new Object[0];
        this.aQi = comparator;
    }

    private zzagh(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.aQg = KArray;
        this.aQh = VArray;
        this.aQi = comparator;
    }

    @Override
    public boolean containsKey(K k) {
        return this.zzbi(k) != -1;
    }

    @Override
    public V get(K k) {
        int n = this.zzbi(k);
        return n != -1 ? (V)this.aQh[n] : null;
    }

    @Override
    public zzagi<K, V> zzbf(K k) {
        int n = this.zzbi(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzagh.zza(this.aQg, n);
        V[] VArray = zzagh.zza(this.aQh, n);
        return new zzagh<K, V>(this.aQi, KArray, VArray);
    }

    @Override
    public zzagi<K, V> zzj(K k, V v) {
        int n = this.zzbi(k);
        if (n != -1) {
            if (this.aQg[n] == k && this.aQh[n] == v) {
                return this;
            }
            K[] KArray = zzagh.zzb(this.aQg, n, k);
            V[] VArray = zzagh.zzb(this.aQh, n, v);
            return new zzagh<K, V>(this.aQi, KArray, VArray);
        }
        if (this.aQg.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.aQg.length + 1);
            for (int i = 0; i < this.aQg.length; ++i) {
                hashMap.put(this.aQg[i], this.aQh[i]);
            }
            hashMap.put(k, v);
            return zzagq.zzc(hashMap, this.aQi);
        }
        int n2 = this.zzbh(k);
        K[] KArray = zzagh.zza(this.aQg, n2, k);
        V[] VArray = zzagh.zza(this.aQh, n2, v);
        return new zzagh<K, V>(this.aQi, KArray, VArray);
    }

    @Override
    public K zzcnb() {
        return this.aQg.length > 0 ? (K)this.aQg[0] : null;
    }

    @Override
    public K zzcnc() {
        return this.aQg.length > 0 ? (K)this.aQg[this.aQg.length - 1] : null;
    }

    @Override
    public int size() {
        return this.aQg.length;
    }

    @Override
    public boolean isEmpty() {
        return this.aQg.length == 0;
    }

    @Override
    public void zza(zzagn.zzb<K, V> zzb2) {
        for (int i = 0; i < this.aQg.length; ++i) {
            zzb2.zzk(this.aQg[i], this.aQh[i]);
        }
    }

    private Iterator<Map.Entry<K, V>> zzh(final int n, final boolean bl) {
        return new Iterator<Map.Entry<K, V>>(){
            int aQj;
            {
                this.aQj = n;
            }

            @Override
            public boolean hasNext() {
                return bl ? this.aQj >= 0 : this.aQj < zzagh.this.aQg.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object object = zzagh.this.aQg[this.aQj];
                Object object2 = zzagh.this.aQh[this.aQj];
                this.aQj = bl ? this.aQj - 1 : this.aQj + 1;
                return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove elements from ImmutableSortedMap");
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.zzh(0, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> zzcnd() {
        return this.zzh(this.aQg.length - 1, true);
    }

    @Override
    public K zzbg(K k) {
        int n = this.zzbi(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        return n > 0 ? (K)this.aQg[n - 1] : null;
    }

    @Override
    public Comparator<K> zzcne() {
        return this.aQi;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private int zzbh(K k) {
        int n;
        for (n = 0; n < this.aQg.length && this.aQi.compare(this.aQg[n], k) < 0; ++n) {
        }
        return n;
    }

    private int zzbi(K k) {
        int n = 0;
        for (K k2 : this.aQg) {
            if (this.aQi.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

