/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahl;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzaht;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzaig;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzakm;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzaln;
import com.google.android.gms.internal.zzalo;
import com.google.android.gms.internal.zzalp;
import com.google.android.gms.internal.zzalq;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzahl aPe;

    DatabaseReference(zzaht zzaht2, zzahr zzahr2) {
        super(zzaht2, zzahr2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzcmu().isEmpty()) {
            zzalp.zzry(string);
        } else {
            zzalp.zzrx(string);
        }
        zzahr zzahr2 = this.zzcmu().zzh(new zzahr(string));
        return new DatabaseReference(this.aPr, zzahr2);
    }

    public DatabaseReference push() {
        String string = zzaln.zzcl(this.aPr.zzcri());
        zzaka zzaka2 = zzaka.zzrm(string);
        return new DatabaseReference(this.aPr, this.zzcmu().zza(zzaka2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzakq.zzbt(null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzakq.zzbt(object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzakq.zzbt(null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzakq.zzbt(object2), completionListener);
    }

    private Task<Void> zza(Object object, zzakm zzakm2, CompletionListener completionListener) {
        zzalp.zzaq(this.zzcmu());
        zzaig.zza(this.zzcmu(), object);
        Object object2 = zzalq.zzbx(object);
        zzalp.zzbw(object2);
        final zzakm zzakm3 = zzakn.zza(object2, zzakm2);
        final zzall<Task<Void>, CompletionListener> zzall2 = zzalo.zzb(completionListener);
        this.aPr.zzr(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aPr.zza(DatabaseReference.this.zzcmu(), zzakm3, (CompletionListener)zzall2.zzcwr());
            }
        });
        return zzall2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzakq.zzbt(object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzakq.zzbt(object), completionListener);
    }

    private Task<Void> zza(final zzakm zzakm2, CompletionListener completionListener) {
        zzalp.zzaq(this.zzcmu());
        final zzall<Task<Void>, CompletionListener> zzall2 = zzalo.zzb(completionListener);
        this.aPr.zzr(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aPr.zza(DatabaseReference.this.zzcmu().zza(zzaka.zzcur()), zzakm2, (CompletionListener)zzall2.zzcwr());
            }
        });
        return zzall2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private Task<Void> zza(final Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<zzahr, zzakm> map2 = zzalp.zzc(this.zzcmu(), map);
        final zzahi zzahi2 = zzahi.zzby(map2);
        final zzall<Task<Void>, CompletionListener> zzall2 = zzalo.zzb(completionListener);
        this.aPr.zzr(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aPr.zza(DatabaseReference.this.zzcmu(), zzahi2, (CompletionListener)zzall2.zzcwr(), (Map<String, Object>)map);
            }
        });
        return zzall2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzalp.zzaq(this.zzcmu());
        return new OnDisconnect(this.aPr, this.zzcmu());
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzalp.zzaq(this.zzcmu());
        this.aPr.zzr(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aPr.zza(DatabaseReference.this.zzcmu(), handler, bl);
            }
        });
    }

    public static void goOffline() {
        DatabaseReference.zza(DatabaseReference.zzcmo());
    }

    static void zza(zzahl zzahl2) {
        zzahv.zzd(zzahl2);
    }

    public static void goOnline() {
        DatabaseReference.zzb(DatabaseReference.zzcmo());
    }

    static void zzb(zzahl zzahl2) {
        zzahv.zze(zzahl2);
    }

    public FirebaseDatabase getDatabase() {
        return this.aPr.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.aPr.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzahr zzahr2 = this.zzcmu().zzcrd();
        if (zzahr2 != null) {
            return new DatabaseReference(this.aPr, zzahr2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.aPr, new zzahr(""));
    }

    public String getKey() {
        if (this.zzcmu().isEmpty()) {
            return null;
        }
        return this.zzcmu().zzcre().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzahl zzcmo() {
        if (aPe == null) {
            aPe = new zzahl();
        }
        return aPe;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

