/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzaho;
import com.google.android.gms.internal.zzaic;
import com.google.android.gms.internal.zzait;
import com.google.android.gms.internal.zzaiu;
import com.google.android.gms.internal.zzaiv;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzajj;
import com.google.android.gms.internal.zzaju;
import com.google.android.gms.internal.zzajx;
import com.google.android.gms.internal.zzajy;
import com.google.android.gms.internal.zzakc;
import com.google.android.gms.internal.zzaki;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzalc;
import com.google.android.gms.internal.zzalg;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzall;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class zzagd
implements zzait {
    private static final Charset pl = Charset.forName("UTF-8");
    private final SQLiteDatabase aPO;
    private final zzaju aPP;
    private boolean aPQ;
    private long aPR = 0L;

    public zzagd(Context context, zzahh zzahh2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        zza zza2 = new zza(context, string2);
        this.aPO = zza2.getWritableDatabase();
        this.aPP = zzahh2.zzrx("Persistence");
    }

    @Override
    public void zza(zzaho zzaho2, zzakj zzakj2, long l) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzbc(zzakj2.getValue(true));
        this.zza(zzaho2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Persisted user overwrite in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(zzaho zzaho2, zzahf zzahf2, long l) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzbc(zzahf2.zzct(true));
        this.zza(zzaho2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Persisted user merge in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zzbx(long l) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        int n = this.aPO.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3), new Object[0]);
        }
    }

    @Override
    public List<zzaic> zzcmw() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzaic> arrayList = new ArrayList<zzaic>();
        try (Cursor cursor = this.aPO.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzaic> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzaic zzaic2;
                Iterable<zzaki> iterable;
                Object object;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzaho(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    object = new ArrayList<byte[]>();
                    do {
                        object.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = this.zzao((List<byte[]>)object);
                }
                object = new String(byArray, pl);
                Object object2 = zzalc.zzsh((String)object);
                if ("o".equals(string)) {
                    iterable = zzakk.zzbq(object2);
                    zzaic2 = new zzaic(l2, (zzaho)((Object)arrayList2), (zzakj)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzahf.zzbx((Map)object2);
                    zzaic2 = new zzaic(l2, (zzaho)((Object)arrayList2), (zzahf)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzaic2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.aPP.zzcuk()) {
                this.aPP.zzi(String.format("Loaded %d writes in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void zza(zzaho zzaho2, long l, String string, byte[] byArray) {
        this.zzcna();
        this.aPO.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzagd.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzagd.zzc(zzaho2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.aPO.insertWithOnConflict("writes", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("path", zzagd.zzc(zzaho2));
            contentValues.put("type", string);
            contentValues.put("part", null);
            contentValues.put("node", byArray);
            this.aPO.insertWithOnConflict("writes", null, contentValues, 5);
        }
    }

    @Override
    public zzakj zza(zzaho zzaho2) {
        return this.zzb(zzaho2);
    }

    @Override
    public void zza(zzaho zzaho2, zzakj zzakj2) {
        this.zzcna();
        this.zza(zzaho2, zzakj2, false);
    }

    @Override
    public void zzb(zzaho zzaho2, zzakj zzakj2) {
        this.zzcna();
        this.zza(zzaho2, zzakj2, true);
    }

    private void zza(zzaho zzaho2, zzakj zzakj2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzaho2);
            n = this.zzc(zzaho2, zzakj2);
        } else {
            n2 = 0;
            n = 0;
            for (zzaki zzaki2 : zzakj2) {
                n2 += this.zza("serverCache", zzaho2.zza(zzaki2.zzcvq()));
                n += this.zzc(zzaho2.zza(zzaki2.zzcvq()), zzaki2.zzcmq());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzaho2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public void zza(zzaho zzaho2, zzahf zzahf2) {
        this.zzcna();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzaho, zzakj> entry : zzahf2) {
            n2 += this.zza("serverCache", zzaho2.zzh(entry.getKey()));
            n += this.zzc(zzaho2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzaho2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public long zzcmx() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.aPO.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public void zza(zzaiv zzaiv2) {
        this.zzcna();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzaiv2.id));
        contentValues.put("path", zzagd.zzc(zzaiv2.aWH.zzcmu()));
        contentValues.put("queryParams", zzaiv2.aWH.zzctx().zzctv());
        contentValues.put("lastUse", Long.valueOf(zzaiv2.aWI));
        contentValues.put("complete", Boolean.valueOf(zzaiv2.aWJ));
        contentValues.put("active", Boolean.valueOf(zzaiv2.aWK));
        this.aPO.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Saved new tracked query in %dms", l2), new Object[0]);
        }
    }

    @Override
    public void zzby(long l) {
        this.zzcna();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.aPO.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.aPO.delete("trackedKeys", string3, new String[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<zzaiv> zzcmy() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzaiv> arrayList = new ArrayList<zzaiv>();
        try (Cursor cursor = this.aPO.query("trackedQueries", stringArray, null, null, null, null, "id");){
            ArrayList<zzaiv> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzaho(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzalc.zzsg((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                zzajj zzajj2 = zzajj.zzb(arrayList2, map);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzaiv zzaiv2 = new zzaiv(l2, zzajj2, l3, bl, bl2);
                arrayList.add(zzaiv2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.aPP.zzcuk()) {
                this.aPP.zzi(String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public void zzbz(long l) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.aPO.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Reset active tracked queries in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzajx> set) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.aPO.delete("trackedKeys", string2, new String[]{string});
        for (zzajx zzajx2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzajx2.asString());
            this.aPO.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzajx> set, Set<zzajx> set2) {
        this.zzcna();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzajx zzajx2 : set2) {
            this.aPO.delete("trackedKeys", string, new String[]{string2, zzajx2.asString()});
        }
        for (zzajx zzajx2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzajx2.asString());
            this.aPO.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public Set<zzajx> zzca(long l) {
        return this.zzh(Collections.singleton(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<zzajx> zzh(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(this.zzp(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.aPO.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzajx.zzsc(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.aPP.zzcuk()) {
                this.aPP.zzi(String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2), new Object[0]);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public void zza(zzaho zzaho2, zzaiu zzaiu2) {
        Object object;
        String string;
        Iterable<Object> iterable;
        Iterable<zzajx> iterable2;
        if (!zzaiu2.zzcsp()) {
            return;
        }
        this.zzcna();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzaho2, new String[]{"rowid", "path"});
        zzaix<Object> zzaix2 = new zzaix<Object>(null);
        zzaix<Object> zzaix3 = new zzaix<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzaho(cursor.getString(1));
            if (!zzaho2.zzi((zzaho)iterable2)) {
                iterable = String.valueOf(zzaho2);
                string = String.valueOf(iterable2);
                this.aPP.warn(new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string).append(". Ignoring.").toString());
                continue;
            }
            iterable = zzaho.zza(zzaho2, (zzaho)iterable2);
            if (zzaiu2.zzw((zzaho)iterable)) {
                zzaix2 = zzaix2.zzb((zzaho)iterable, l2);
                continue;
            }
            if (zzaiu2.zzx((zzaho)iterable)) {
                zzaix3 = zzaix3.zzb((zzaho)iterable, l2);
                continue;
            }
            string = String.valueOf(zzaho2);
            object = String.valueOf(iterable2);
            this.aPP.warn(new StringBuilder(88 + String.valueOf(string).length() + String.valueOf(object).length()).append("We are pruning at ").append(string).append(" and have data at ").append((String)object).append(" that isn't marked for pruning or keeping. Ignoring.").toString());
        }
        int n = 0;
        int n2 = 0;
        if (!zzaix2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzaho2, zzaho.zzcqw(), zzaix2, zzaix3, zzaiu2, (List<zzali<zzaho, zzakj>>)iterable2);
            iterable = zzaix2.values();
            object = String.valueOf(this.zzp((Collection<Long>)iterable));
            string = new StringBuilder(11 + String.valueOf(object).length()).append("rowid IN (").append((String)object).append(")").toString();
            this.aPO.delete("serverCache", string, null);
            for (zzali zzali2 : iterable2) {
                this.zzc(zzaho2.zzh((zzaho)zzali2.getFirst()), (zzakj)zzali2.zzcwp());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3), new Object[0]);
        }
    }

    private void zza(zzaho zzaho2, final zzaho zzaho3, zzaix<Long> zzaix2, final zzaix<Long> zzaix3, zzaiu zzaiu2, final List<zzali<zzaho, zzakj>> list) {
        if (zzaix2.getValue() != null) {
            int n = zzaiu2.zza(0, new zzaix.zza<Void, Integer>(){

                @Override
                public Integer zza(zzaho zzaho2, Void void_, Integer n) {
                    return zzaix3.zzak(zzaho2) == null ? n + 1 : n;
                }
            });
            if (n > 0) {
                zzaho zzaho4 = zzaho2.zzh(zzaho3);
                if (this.aPP.zzcuk()) {
                    this.aPP.zzi(String.format("Need to rewrite %d nodes below path %s", n, zzaho4), new Object[0]);
                }
                final zzakj zzakj2 = this.zzb(zzaho4);
                zzaiu2.zza(null, new zzaix.zza<Void, Void>(){

                    @Override
                    public Void zza(zzaho zzaho2, Void void_, Void void_2) {
                        if (zzaix3.zzak(zzaho2) == null) {
                            list.add(new zzali<zzaho, zzakj>(zzaho3.zzh(zzaho2), zzakj2.zzao(zzaho2)));
                        }
                        return null;
                    }
                });
            }
        } else {
            for (Map.Entry<zzajx, zzaix<Long>> entry : zzaix2.zzcsv()) {
                zzajx zzajx2 = entry.getKey();
                zzaiu zzaiu3 = zzaiu2.zzd(entry.getKey());
                this.zza(zzaho2, zzaho3.zza(zzajx2), entry.getValue(), zzaix3.zze(zzajx2), zzaiu3, list);
            }
        }
    }

    @Override
    public void zzcmz() {
        this.zzcna();
        long l = System.currentTimeMillis();
        int n = this.aPO.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Deleted %d (all) write(s) in %dms", n, l2), new Object[0]);
        }
    }

    @Override
    public void beginTransaction() {
        zzall.zzb(!this.aPQ, "runInTransaction called when an existing transaction is already in progress.");
        if (this.aPP.zzcuk()) {
            this.aPP.zzi("Starting transaction.", new Object[0]);
        }
        this.aPO.beginTransaction();
        this.aPQ = true;
        this.aPR = System.currentTimeMillis();
    }

    @Override
    public void endTransaction() {
        this.aPO.endTransaction();
        this.aPQ = false;
        long l = System.currentTimeMillis() - this.aPR;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Transaction completed. Elapsed: %dms", l), new Object[0]);
        }
    }

    @Override
    public void setTransactionSuccessful() {
        this.aPO.setTransactionSuccessful();
    }

    private void zzcna() {
        zzall.zzb(this.aPQ, "Transaction expected to already be in progress.");
    }

    private int zzc(zzaho zzaho2, zzakj zzakj2) {
        long l = zzalg.zzs(zzakj2);
        if (zzakj2 instanceof zzajy && l > 16384L) {
            if (this.aPP.zzcuk()) {
                this.aPP.zzi(String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzaho2, l, 16384), new Object[0]);
            }
            int n = 0;
            for (zzaki zzaki2 : zzakj2) {
                n += this.zzc(zzaho2.zza(zzaki2.zzcvq()), zzaki2.zzcmq());
            }
            if (!zzakj2.zzcuv().isEmpty()) {
                this.zzd(zzaho2.zza(zzajx.zzcup()), zzakj2.zzcuv());
                ++n;
            }
            this.zzd(zzaho2, zzakc.zzcvg());
            return ++n;
        }
        this.zzd(zzaho2, zzakj2);
        return 1;
    }

    private String zza(zzaho zzaho2, int n) {
        String string = String.valueOf(zzagd.zzc(zzaho2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private void zzd(zzaho zzaho2, zzakj zzakj2) {
        byte[] byArray = this.zzbc(zzakj2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzagd.zzd(byArray, 262144);
            if (this.aPP.zzcuk()) {
                n = list.size();
                this.aPP.zzi(new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString(), new Object[0]);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", this.zza(zzaho2, n));
                contentValues.put("value", list.get(n));
                this.aPO.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("path", zzagd.zzc(zzaho2));
            contentValues.put("value", byArray);
            this.aPO.insertWithOnConflict("serverCache", null, contentValues, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private zzakj zzb(zzaho zzaho2) {
        zzaho zzaho3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzaho2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzakj zzakj2 = zzakc.zzcvg();
        boolean bl = false;
        HashMap<zzaho, void> hashMap = new HashMap<zzaho, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzaho3 = new zzaho(((String)object2).substring(0, ((String)object2).length() - ".part-0000".length()));
                int n = this.zza(zzaho3, arrayList, i);
                if (this.aPP.zzcuk()) {
                    this.aPP.zzi(new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString(), new Object[0]);
                }
                zzakj zzakj3 = this.zzas(this.zzao(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzakj zzakj4 = this.zzas((byte[])arrayList2.get(i));
                zzaho3 = new zzaho((String)arrayList.get(i));
            }
            if (zzaho3.zzcrc() != null && zzaho3.zzcrc().zzcur()) {
                hashMap.put(zzaho3, object);
                continue;
            }
            if (zzaho3.zzi(zzaho2)) {
                zzall.zzb(!bl, "Descendants of path must come after ancestors.");
                zzakj2 = object.zzao(zzaho.zza(zzaho3, zzaho2));
                continue;
            }
            if (zzaho2.zzi(zzaho3)) {
                bl = true;
                object2 = zzaho.zza(zzaho2, zzaho3);
                zzakj2 = zzakj2.zzl((zzaho)object2, (zzakj)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzaho3, zzaho2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzaho3 = (zzaho)entry.getKey();
            zzakj2 = zzakj2.zzl(zzaho.zza(zzaho2, zzaho3), (zzakj)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.aPP.zzcuk()) {
            this.aPP.zzi(String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzalg.zzt(zzakj2), zzaho2, l7, l2, l4, l6), new Object[0]);
        }
        return zzakj2;
    }

    private int zza(zzaho zzaho2, List<String> list, int n) {
        int n2;
        String string = zzagd.zzc(zzaho2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(this.zza(zzaho2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private Cursor zza(zzaho zzaho2, String[] stringArray) {
        String string = zzagd.zzc(zzaho2);
        String string2 = zzagd.zzrj(string);
        String[] stringArray2 = new String[zzaho2.size() + 3];
        String string3 = zzagd.zzb(zzaho2, stringArray2);
        String string4 = String.valueOf(string3);
        String string5 = String.valueOf(" OR (path > ? AND path < ?)");
        string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        stringArray2[zzaho2.size() + 1] = string;
        stringArray2[zzaho2.size() + 2] = string2;
        String string6 = "path";
        return this.aPO.query("serverCache", stringArray, string3, stringArray2, null, null, string6);
    }

    private static String zzc(zzaho zzaho2) {
        if (zzaho2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzaho2.toString()).concat("/");
    }

    private static String zzrj(String string) {
        assert (string.endsWith("/")) : "Path keys must end with a '/'";
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        int n = 48;
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private static String zzb(zzaho zzaho2, String[] stringArray) {
        assert (stringArray.length >= zzaho2.size() + 1);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzaho2.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray[n] = zzagd.zzc(zzaho2);
            zzaho2 = zzaho2.zzcrb();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray[n] = zzagd.zzc(zzaho.zzcqw());
        return stringBuilder.toString();
    }

    private int zza(String string, zzaho zzaho2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzagd.zzc(zzaho2);
        String string4 = zzagd.zzrj(string3);
        return this.aPO.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / n + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(n, byArray.length - i * n);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * n, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private byte[] zzao(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private byte[] zzbc(Object object) {
        try {
            return zzalc.zzbs((Object)object).getBytes(pl);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private zzakj zzas(byte[] byArray) {
        try {
            Object object = zzalc.zzsh((String)new String(byArray, pl));
            return zzakk.zzbq(object);
        }
        catch (IOException iOException) {
            String string = new String(byArray, pl);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private String zzp(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }

    private static class zza
    extends SQLiteOpenHelper {
        public zza(Context context, String string) {
            super(context, string, null, 2);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            sQLiteDatabase.execSQL("CREATE TABLE writes (id INTEGER, path TEXT, type TEXT, part INTEGER, node BLOB, UNIQUE (id, part));");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            assert (n2 == 2) : "Why is onUpgrade() called with a different version?";
            if (n > 1) {
                throw new AssertionError((Object)new StringBuilder(40).append("We don't handle upgrading to ").append(n2).toString());
            }
            this.zzc(sQLiteDatabase, "serverCache");
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            this.zzc(sQLiteDatabase, "complete");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
        }

        private void zzc(SQLiteDatabase sQLiteDatabase, String string) {
            String string2 = String.valueOf(string);
            sQLiteDatabase.execSQL(string2.length() != 0 ? "DROP TABLE IF EXISTS ".concat(string2) : new String("DROP TABLE IF EXISTS "));
        }
    }
}

