/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.util.Base64;
import com.google.android.gms.internal.zzaho;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzalj;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class zzall {
    public static zzalj zzsi(String string) throws DatabaseException {
        String string2 = string;
        try {
            Object object;
            CharSequence charSequence;
            String[] stringArray;
            int n = string2.indexOf("//");
            if (n == -1) {
                throw new URISyntaxException(string2, "Invalid scheme specified");
            }
            int n2 = string2.substring(n + 2).indexOf("/");
            if (n2 != -1) {
                stringArray = string2.substring(n2 += n + 2).split("/");
                charSequence = new StringBuilder();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("")) continue;
                    ((StringBuilder)charSequence).append("/");
                    ((StringBuilder)charSequence).append(URLEncoder.encode(stringArray[i], "UTF-8"));
                }
                String string3 = String.valueOf(string2.substring(0, n2));
                String string4 = String.valueOf(((StringBuilder)charSequence).toString());
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            stringArray = new URI(string2);
            charSequence = stringArray.getPath().replace("+", " ");
            zzalm.zzso((String)charSequence);
            zzaho zzaho2 = new zzaho((String)charSequence);
            String string5 = stringArray.getScheme();
            zzahr zzahr2 = new zzahr();
            zzahr2.aQT = stringArray.getHost().toLowerCase();
            int n3 = stringArray.getPort();
            if (n3 != -1) {
                zzahr2.aQU = string5.equals("https");
                object = String.valueOf(zzahr2.aQT);
                zzahr2.aQT = new StringBuilder(12 + String.valueOf(object).length()).append((String)object).append(":").append(n3).toString();
            } else {
                zzahr2.aQU = true;
            }
            object = zzahr2.aQT.split("\\.");
            zzahr2.zx = object[0].toLowerCase();
            zzahr2.aUM = zzahr2.aQT;
            zzalj zzalj2 = new zzalj();
            zzalj2.aPq = zzaho2;
            zzalj2.aPg = zzahr2;
            return zzalj2;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DatabaseException("Invalid Firebase Database url specified", uRISyntaxException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DatabaseException("Failed to URLEncode the path", unsupportedEncodingException);
        }
    }

    public static String zzsj(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(string.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            return Base64.encodeToString((byte[])byArray, (int)2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Missing SHA-1 MessageDigest provider.", noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 encoding is required for Firebase Database to run!");
        }
    }

    public static String zzsk(String string) {
        String string2 = string;
        if (string.indexOf(92) != -1) {
            string2 = string2.replace("\\", "\\\\");
        }
        if (string.indexOf(34) != -1) {
            string2 = string2.replace("\"", "\\\"");
        }
        String string3 = string2;
        return new StringBuilder(2 + String.valueOf(string3).length()).append("\"").append(string3).append("\"").toString();
    }

    public static String zzm(double d) {
        StringBuilder stringBuilder = new StringBuilder(16);
        byte[] byArray = new byte[8];
        ByteBuffer.wrap(byArray).putDouble(d);
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append(String.format("%02x", byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static Integer zzsl(String string) {
        if (string.length() > 11 || string.length() == 0) {
            return null;
        }
        int n = 0;
        boolean bl = false;
        if (string.charAt(0) == '-') {
            if (string.length() == 1) {
                return null;
            }
            bl = true;
            n = 1;
        }
        long l = 0L;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '0' || c > '9') {
                return null;
            }
            l = l * 10L + (long)(c - 48);
            ++n;
        }
        if (bl) {
            if (-l < Integer.MIN_VALUE) {
                return null;
            }
            return (int)(-l);
        }
        if (l > Integer.MAX_VALUE) {
            return null;
        }
        return (int)l;
    }

    public static int zzac(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return 1;
    }

    public static int zzk(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l == l2) {
            return 0;
        }
        return 1;
    }

    public static void zzcq(boolean bl) {
        zzall.zzb(bl, "");
    }

    public static void zzb(boolean bl, String string) {
        if (!bl) {
            String string2 = String.valueOf(string);
            throw new AssertionError((Object)(string2.length() != 0 ? "hardAssert failed: ".concat(string2) : new String("hardAssert failed: ")));
        }
    }

    public static zzali<Task<Void>, DatabaseReference.CompletionListener> zzb(DatabaseReference.CompletionListener completionListener) {
        if (completionListener == null) {
            final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            DatabaseReference.CompletionListener completionListener2 = new DatabaseReference.CompletionListener(){

                @Override
                public void onComplete(DatabaseError databaseError, DatabaseReference databaseReference) {
                    if (databaseError != null) {
                        taskCompletionSource.setException((Exception)databaseError.toException());
                    } else {
                        taskCompletionSource.setResult(null);
                    }
                }
            };
            return new zzali<Task<Void>, DatabaseReference.CompletionListener>(taskCompletionSource.getTask(), completionListener2);
        }
        return new zzali<Object, DatabaseReference.CompletionListener>(null, completionListener);
    }
}

