/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzahe;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzaho;
import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzaie;
import com.google.android.gms.internal.zzaih;
import com.google.android.gms.internal.zzaji;
import com.google.android.gms.internal.zzajj;
import com.google.android.gms.internal.zzajw;
import com.google.android.gms.internal.zzajx;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzakc;
import com.google.android.gms.internal.zzakf;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzakm;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzakp;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzalm;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;

public class Query {
    protected final zzahq aPi;
    protected final zzaho aPq;
    protected final zzaji aPt;
    private final boolean aPu;

    Query(zzahq zzahq2, zzaho zzaho2, zzaji zzaji2, boolean bl) throws DatabaseException {
        this.aPi = zzahq2;
        this.aPq = zzaho2;
        this.aPt = zzaji2;
        this.aPu = bl;
        zzall.zzb(zzaji2.isValid(), "Validation of queries failed.");
    }

    Query(zzahq zzahq2, zzaho zzaho2) {
        this.aPi = zzahq2;
        this.aPq = zzaho2;
        this.aPt = zzaji.aXC;
        this.aPu = false;
    }

    private void zza(zzaji zzaji2) {
        if (zzaji2.zzctq().equals(zzakf.zzcvn())) {
            zzajx zzajx2;
            zzakj zzakj2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzaji2.zzcti()) {
                zzakj2 = zzaji2.zzctj();
                zzajx2 = zzaji2.zzctk();
                if (zzajx2 != zzajx.zzcun() || !(zzakj2 instanceof zzakp)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzaji2.zzctl()) {
                zzakj2 = zzaji2.zzctm();
                zzajx2 = zzaji2.zzctn();
                if (zzajx2 != zzajx.zzcuo() || !(zzakj2 instanceof zzakp)) {
                    throw new IllegalArgumentException(string);
                }
            }
        } else if (zzaji2.zzctq().equals(zzakm.zzcvr()) && (zzaji2.zzcti() && !zzakn.zzp(zzaji2.zzctj()) || zzaji2.zzctl() && !zzakn.zzp(zzaji2.zzctm()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private void zzb(zzaji zzaji2) {
        if (zzaji2.zzcti() && zzaji2.zzctl() && zzaji2.zzcto() && !zzaji2.zzctp()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private void zzcms() {
        if (this.aPt.zzcti()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.aPt.zzctl()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private void zzcmt() {
        if (this.aPu) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzaie(this.aPi, valueEventListener, this.zzcmv()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzahe(this.aPi, childEventListener, this.zzcmv()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(final ValueEventListener valueEventListener) {
        this.zzb(new zzaie(this.aPi, new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot dataSnapshot) {
                Query.this.removeEventListener(this);
                valueEventListener.onDataChange(dataSnapshot);
            }

            @Override
            public void onCancelled(DatabaseError databaseError) {
                valueEventListener.onCancelled(databaseError);
            }
        }, this.zzcmv()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzaie(this.aPi, valueEventListener, this.zzcmv()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzahe(this.aPi, childEventListener, this.zzcmv()));
    }

    private void zza(final zzahj zzahj2) {
        zzaih.zzcsb().zzk(zzahj2);
        this.aPi.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.aPi.zze(zzahj2);
            }
        });
    }

    private void zzb(final zzahj zzahj2) {
        zzaih.zzcsb().zzi(zzahj2);
        this.aPi.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.aPi.zzf(zzahj2);
            }
        });
    }

    public void keepSynced(final boolean bl) {
        if (!this.aPq.isEmpty() && this.aPq.zzcqz().equals(zzajx.zzcuq())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.aPi.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.aPi.zza(Query.this.zzcmv(), bl);
            }
        });
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzakj zzakj2 = string != null ? new zzakp(string, zzakn.zzcvs()) : zzakc.zzcvg();
        return this.zza(zzakj2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzakb(d, zzakn.zzcvs()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzajw(bl, zzakn.zzcvs()), string);
    }

    private Query zza(zzakj zzakj2, String string) {
        zzalm.zzsr(string);
        if (!zzakj2.zzcuu() && !zzakj2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.aPt.zzcti()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzajx zzajx2 = string != null ? zzajx.zzsc(string) : null;
        zzaji zzaji2 = this.aPt.zza(zzakj2, zzajx2);
        this.zzb(zzaji2);
        this.zza(zzaji2);
        assert (zzaji2.isValid());
        return new Query(this.aPi, this.aPq, zzaji2, this.aPu);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzakj zzakj2 = string != null ? new zzakp(string, zzakn.zzcvs()) : zzakc.zzcvg();
        return this.zzb(zzakj2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzakb(d, zzakn.zzcvs()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzajw(bl, zzakn.zzcvs()), string);
    }

    private Query zzb(zzakj zzakj2, String string) {
        zzajx zzajx2;
        zzalm.zzsr(string);
        if (!zzakj2.zzcuu() && !zzakj2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzajx zzajx3 = zzajx2 = string != null ? zzajx.zzsc(string) : null;
        if (this.aPt.zzctl()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzaji zzaji2 = this.aPt.zzb(zzakj2, zzajx2);
        this.zzb(zzaji2);
        this.zza(zzaji2);
        assert (zzaji2.isValid());
        return new Query(this.aPi, this.aPq, zzaji2, this.aPu);
    }

    public Query equalTo(String string) {
        this.zzcms();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzcms();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzcms();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzcms();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzcms();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzcms();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.aPt.zzcto()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.aPi, this.aPq, this.aPt.zzaex(n), this.aPu);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.aPt.zzcto()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.aPi, this.aPq, this.aPt.zzaey(n), this.aPu);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzalm.zzsn(string);
        this.zzcmt();
        zzaho zzaho2 = new zzaho(string);
        if (zzaho2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzakl zzakl2 = new zzakl(zzaho2);
        return new Query(this.aPi, this.aPq, this.aPt.zza(zzakl2), true);
    }

    public Query orderByPriority() {
        this.zzcmt();
        zzaji zzaji2 = this.aPt.zza(zzakm.zzcvr());
        this.zza(zzaji2);
        return new Query(this.aPi, this.aPq, zzaji2, true);
    }

    public Query orderByKey() {
        this.zzcmt();
        zzaji zzaji2 = this.aPt.zza(zzakf.zzcvn());
        this.zza(zzaji2);
        return new Query(this.aPi, this.aPq, zzaji2, true);
    }

    public Query orderByValue() {
        this.zzcmt();
        return new Query(this.aPi, this.aPq, this.aPt.zza(zzakq.zzcvt()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.aPi, this.zzcmu());
    }

    public zzaho zzcmu() {
        return this.aPq;
    }

    public zzajj zzcmv() {
        return new zzajj(this.aPq, this.aPt);
    }
}

