/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.database.DatabaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class DatabaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> aVG = new HashMap<Integer, String>();
    private static final Map<String, Integer> aVH;
    private final int aVI;
    private final String message;
    private final String aVJ;

    public static DatabaseError zzsb(String string) {
        return DatabaseError.zzbl(string, null);
    }

    public static DatabaseError zzbl(String string, String string2) {
        return DatabaseError.zzo(string, string2, null);
    }

    public static DatabaseError zzagb(int n) {
        if (!aVG.containsKey(n)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Invalid Firebase Database error code: ").append(n).toString());
        }
        String string = aVG.get(n);
        return new DatabaseError(n, string, null);
    }

    public static DatabaseError zzo(String string, String string2, String string3) {
        Integer n = aVH.get(string.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string4 = string2 == null ? aVG.get(n) : string2;
        return new DatabaseError(n, string4, string3);
    }

    public static DatabaseError fromException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = String.valueOf(aVG.get(-11));
        String string2 = String.valueOf(stringWriter.toString());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        return new DatabaseError(-11, string3);
    }

    private DatabaseError(int n, String string) {
        this(n, string, null);
    }

    private DatabaseError(int n, String string, String string2) {
        this.aVI = n;
        this.message = string;
        this.aVJ = string2 == null ? "" : string2;
    }

    public int getCode() {
        return this.aVI;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.aVJ;
    }

    public String toString() {
        String string = String.valueOf(this.message);
        return string.length() != 0 ? "DatabaseError: ".concat(string) : new String("DatabaseError: ");
    }

    public DatabaseException toException() {
        String string = String.valueOf(this.message);
        return new DatabaseException(string.length() != 0 ? "Firebase Database error: ".concat(string) : new String("Firebase Database error: "));
    }

    static {
        aVG.put(-1, "The transaction needs to be run again with current data");
        aVG.put(-2, "The server indicated that this operation failed");
        aVG.put(-3, "This client does not have permission to perform this operation");
        aVG.put(-4, "The operation had to be aborted due to a network disconnect");
        aVG.put(-6, "The supplied auth token has expired");
        aVG.put(-7, "The supplied auth token was invalid");
        aVG.put(-8, "The transaction had too many retries");
        aVG.put(-9, "The transaction was overridden by a subsequent set");
        aVG.put(-10, "The service is unavailable");
        aVG.put(-11, "User code called from the Firebase Database runloop threw an exception:\n");
        aVG.put(-24, "The operation could not be performed due to a network error");
        aVG.put(-25, "The write was canceled by the user.");
        aVG.put(-999, "An unknown error occurred");
        aVH = new HashMap<String, Integer>();
        aVH.put("datastale", -1);
        aVH.put("failure", -2);
        aVH.put("permission_denied", -3);
        aVH.put("disconnected", -4);
        aVH.put("expired_token", -6);
        aVH.put("invalid_token", -7);
        aVH.put("maxretries", -8);
        aVH.put("overriddenbyset", -9);
        aVH.put("unavailable", -10);
        aVH.put("network_error", -24);
        aVH.put("write_canceled", -25);
    }
}

