/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzait;
import com.google.android.gms.internal.zzaiz;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzajc;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, FirebaseDatabase> aVT = new HashMap<String, FirebaseDatabase>();
    private final FirebaseApp aVU;
    private final zzajc aVV;
    private final zzait aVW;
    private zzajb aVX;

    public static FirebaseDatabase getInstance() {
        return FirebaseDatabase.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        if (!aVT.containsKey(firebaseApp.getName())) {
            String string = firebaseApp.getOptions().getDatabaseUrl();
            if (string == null) {
                throw new DatabaseException("Failed to get FirebaseDatabase instance: FirebaseApp object has no DatabaseURL in its FirebaseOptions object.");
            }
            zzamu zzamu2 = zzamw.zzte(string);
            if (!zzamu2.aWf.isEmpty()) {
                String string2 = String.valueOf(zzamu2.aWf.toString());
                throw new DatabaseException(new StringBuilder(114 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Configured Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
            }
            zzait zzait2 = new zzait();
            if (!firebaseApp.zzcnu()) {
                zzait2.zzsw(firebaseApp.getName());
            }
            zzait2.zzf(firebaseApp);
            aVT.put(firebaseApp.getName(), new FirebaseDatabase(firebaseApp, zzamu2.aVV, zzait2));
        }
        return aVT.get(firebaseApp.getName());
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzajc zzajc2, zzait zzait2) {
        this.aVU = firebaseApp;
        this.aVV = zzajc2;
        this.aVW = zzait2;
    }

    public FirebaseApp getApp() {
        return this.aVU;
    }

    public DatabaseReference getReference() {
        this.zzcqv();
        return new DatabaseReference(this.aVX, zzaiz.zzcve());
    }

    public DatabaseReference getReference(String string) {
        this.zzcqv();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzamx.zztk(string);
        zzaiz zzaiz2 = new zzaiz(string);
        return new DatabaseReference(this.aVX, zzaiz2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzcqv();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzamu zzamu2 = zzamw.zzte(string);
        if (!zzamu2.aVV.aXJ.equals(this.aVX.zzcvn().aXJ)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.aVX, zzamu2.aWf);
    }

    public void purgeOutstandingWrites() {
        this.zzcqv();
        this.aVX.zzs(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.aVX.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.zzcqv();
        zzajd.zzl(this.aVX);
    }

    public void goOffline() {
        this.zzcqv();
        zzajd.zzk(this.aVX);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzsc("setLogLevel");
        this.aVW.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzsc("setPersistenceEnabled");
        this.aVW.setPersistenceEnabled(bl);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private void zzsc(String string) {
        if (this.aVX != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private synchronized void zzcqv() {
        if (this.aVX == null) {
            this.aVX = zzajd.zza(this.aVW, this.aVV, this);
        }
    }
}

