/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.android.gms.internal.zzajh;
import com.google.android.gms.internal.zzajj;
import com.google.android.gms.internal.zzajq;
import com.google.android.gms.internal.zzake;
import com.google.android.gms.internal.zzakv;
import com.google.android.gms.internal.zzakw;
import com.google.android.gms.internal.zzakx;
import com.google.android.gms.internal.zzakz;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzalw;
import com.google.android.gms.internal.zzalz;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzame;
import com.google.android.gms.internal.zzamk;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzamm;
import com.google.android.gms.internal.zzane;
import com.google.android.gms.internal.zzani;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzann;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class zzaif
implements zzakv {
    private static final Charset vp = Charset.forName("UTF-8");
    private final SQLiteDatabase aZQ;
    private final zzalw aZR;
    private boolean aZS;
    private long aZT = 0L;

    public zzaif(Context context, zzajj zzajj2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.aZR = zzajj2.zzss("Persistence");
        this.aZQ = this.zzai(context, string2);
    }

    @Override
    public void zza(zzajq zzajq2, zzaml zzaml2, long l) {
        this.zzcri();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzbf(zzaml2.getValue(true));
        this.zza(zzajq2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Persisted user overwrite in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(zzajq zzajq2, zzajh zzajh2, long l) {
        this.zzcri();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzbf(zzajh2.zzda(true));
        this.zza(zzajq2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Persisted user merge in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zzby(long l) {
        this.zzcri();
        long l2 = System.currentTimeMillis();
        int n = this.aZQ.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3), new Object[0]);
        }
    }

    @Override
    public List<zzake> zzcre() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzake> arrayList = new ArrayList<zzake>();
        try (Cursor cursor = this.aZQ.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzake> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzake zzake2;
                Iterable<zzamk> iterable;
                Object object;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzajq(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    object = new ArrayList<byte[]>();
                    do {
                        object.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = this.zzar((List<byte[]>)object);
                }
                object = new String(byArray, vp);
                Object object2 = zzane.zztc((String)object);
                if ("o".equals(string)) {
                    iterable = zzamm.zzbt(object2);
                    zzake2 = new zzake(l2, (zzajq)((Object)arrayList2), (zzaml)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzajh.zzca((Map)object2);
                    zzake2 = new zzake(l2, (zzajq)((Object)arrayList2), (zzajh)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzake2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.aZR.zzcyu()) {
                this.aZR.zzi(String.format("Loaded %d writes in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void zza(zzajq zzajq2, long l, String string, byte[] byArray) {
        this.zzcri();
        this.aZQ.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzaif.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzaif.zzc(zzajq2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.aZQ.insertWithOnConflict("writes", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("path", zzaif.zzc(zzajq2));
            contentValues.put("type", string);
            contentValues.put("part", null);
            contentValues.put("node", byArray);
            this.aZQ.insertWithOnConflict("writes", null, contentValues, 5);
        }
    }

    @Override
    public zzaml zza(zzajq zzajq2) {
        return this.zzb(zzajq2);
    }

    @Override
    public void zza(zzajq zzajq2, zzaml zzaml2) {
        this.zzcri();
        this.zza(zzajq2, zzaml2, false);
    }

    @Override
    public void zzb(zzajq zzajq2, zzaml zzaml2) {
        this.zzcri();
        this.zza(zzajq2, zzaml2, true);
    }

    private void zza(zzajq zzajq2, zzaml zzaml2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzajq2);
            n = this.zzc(zzajq2, zzaml2);
        } else {
            n2 = 0;
            n = 0;
            for (zzamk zzamk2 : zzaml2) {
                n2 += this.zza("serverCache", zzajq2.zza(zzamk2.a()));
                n += this.zzc(zzajq2.zza(zzamk2.a()), zzamk2.zzcqy());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzajq2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public void zza(zzajq zzajq2, zzajh zzajh2) {
        this.zzcri();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzajq, zzaml> entry : zzajh2) {
            n2 += this.zza("serverCache", zzajq2.zzh(entry.getKey()));
            n += this.zzc(zzajq2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzajq2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public long zzcrf() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.aZQ.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public void zza(zzakx zzakx2) {
        this.zzcri();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzakx2.id));
        contentValues.put("path", zzaif.zzc(zzakx2.bgL.zzcrc()));
        contentValues.put("queryParams", zzakx2.bgL.zzcyh().zzcyf());
        contentValues.put("lastUse", Long.valueOf(zzakx2.bgM));
        contentValues.put("complete", Boolean.valueOf(zzakx2.bgN));
        contentValues.put("active", Boolean.valueOf(zzakx2.bgO));
        this.aZQ.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Saved new tracked query in %dms", l2), new Object[0]);
        }
    }

    @Override
    public void zzbz(long l) {
        this.zzcri();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.aZQ.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.aZQ.delete("trackedKeys", string3, new String[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<zzakx> zzcrg() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzakx> arrayList = new ArrayList<zzakx>();
        try (Cursor cursor = this.aZQ.query("trackedQueries", stringArray, null, null, null, null, "id");){
            ArrayList<zzakx> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzajq(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzane.zztb((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                zzall zzall2 = zzall.zzb(arrayList2, map);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzakx zzakx2 = new zzakx(l2, zzall2, l3, bl, bl2);
                arrayList.add(zzakx2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.aZR.zzcyu()) {
                this.aZR.zzi(String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public void zzca(long l) {
        this.zzcri();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.aZQ.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Reset active tracked queries in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzalz> set) {
        this.zzcri();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.aZQ.delete("trackedKeys", string2, new String[]{string});
        for (zzalz zzalz2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzalz2.asString());
            this.aZQ.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzalz> set, Set<zzalz> set2) {
        this.zzcri();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzalz zzalz2 : set2) {
            this.aZQ.delete("trackedKeys", string, new String[]{string2, zzalz2.asString()});
        }
        for (zzalz zzalz2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzalz2.asString());
            this.aZQ.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public Set<zzalz> zzcb(long l) {
        return this.zzh(Collections.singleton(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<zzalz> zzh(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(this.zzp(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.aZQ.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzalz.zzsx(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.aZR.zzcyu()) {
                this.aZR.zzi(String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2), new Object[0]);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public void zza(zzajq zzajq2, zzakw zzakw2) {
        Object object;
        String string;
        Iterable<Object> iterable;
        Iterable<zzalz> iterable2;
        if (!zzakw2.zzcwz()) {
            return;
        }
        this.zzcri();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzajq2, new String[]{"rowid", "path"});
        zzakz<Object> zzakz2 = new zzakz<Object>(null);
        zzakz<Object> zzakz3 = new zzakz<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzajq(cursor.getString(1));
            if (!zzajq2.zzi((zzajq)iterable2)) {
                iterable = String.valueOf(zzajq2);
                string = String.valueOf(iterable2);
                this.aZR.warn(new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string).append(". Ignoring.").toString());
                continue;
            }
            iterable = zzajq.zza(zzajq2, (zzajq)iterable2);
            if (zzakw2.zzw((zzajq)iterable)) {
                zzakz2 = zzakz2.zzb((zzajq)iterable, l2);
                continue;
            }
            if (zzakw2.zzx((zzajq)iterable)) {
                zzakz3 = zzakz3.zzb((zzajq)iterable, l2);
                continue;
            }
            string = String.valueOf(zzajq2);
            object = String.valueOf(iterable2);
            this.aZR.warn(new StringBuilder(88 + String.valueOf(string).length() + String.valueOf(object).length()).append("We are pruning at ").append(string).append(" and have data at ").append((String)object).append(" that isn't marked for pruning or keeping. Ignoring.").toString());
        }
        int n = 0;
        int n2 = 0;
        if (!zzakz2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzajq2, zzajq.zzcvg(), zzakz2, zzakz3, zzakw2, (List<zzank<zzajq, zzaml>>)iterable2);
            iterable = zzakz2.values();
            object = String.valueOf(this.zzp((Collection<Long>)iterable));
            string = new StringBuilder(11 + String.valueOf(object).length()).append("rowid IN (").append((String)object).append(")").toString();
            this.aZQ.delete("serverCache", string, null);
            for (zzank zzank2 : iterable2) {
                this.zzc(zzajq2.zzh((zzajq)zzank2.getFirst()), (zzaml)zzank2.A());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3), new Object[0]);
        }
    }

    private void zza(zzajq zzajq2, final zzajq zzajq3, zzakz<Long> zzakz2, final zzakz<Long> zzakz3, zzakw zzakw2, final List<zzank<zzajq, zzaml>> list) {
        if (zzakz2.getValue() != null) {
            int n = zzakw2.zza(0, new zzakz.zza<Void, Integer>(){

                @Override
                public Integer zza(zzajq zzajq2, Void void_, Integer n) {
                    return zzakz3.zzak(zzajq2) == null ? n + 1 : n;
                }
            });
            if (n > 0) {
                zzajq zzajq4 = zzajq2.zzh(zzajq3);
                if (this.aZR.zzcyu()) {
                    this.aZR.zzi(String.format("Need to rewrite %d nodes below path %s", n, zzajq4), new Object[0]);
                }
                final zzaml zzaml2 = this.zzb(zzajq4);
                zzakw2.zza(null, new zzakz.zza<Void, Void>(){

                    @Override
                    public Void zza(zzajq zzajq2, Void void_, Void void_2) {
                        if (zzakz3.zzak(zzajq2) == null) {
                            list.add(new zzank<zzajq, zzaml>(zzajq3.zzh(zzajq2), zzaml2.zzao(zzajq2)));
                        }
                        return null;
                    }
                });
            }
        } else {
            for (Map.Entry<zzalz, zzakz<Long>> entry : zzakz2.zzcxf()) {
                zzalz zzalz2 = entry.getKey();
                zzakw zzakw3 = zzakw2.zzd(entry.getKey());
                this.zza(zzajq2, zzajq3.zza(zzalz2), entry.getValue(), zzakz3.zze(zzalz2), zzakw3, list);
            }
        }
    }

    @Override
    public void zzcrh() {
        this.zzcri();
        long l = System.currentTimeMillis();
        int n = this.aZQ.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Deleted %d (all) write(s) in %dms", n, l2), new Object[0]);
        }
    }

    @Override
    public void beginTransaction() {
        zzann.zzb(!this.aZS, "runInTransaction called when an existing transaction is already in progress.");
        if (this.aZR.zzcyu()) {
            this.aZR.zzi("Starting transaction.", new Object[0]);
        }
        this.aZQ.beginTransaction();
        this.aZS = true;
        this.aZT = System.currentTimeMillis();
    }

    @Override
    public void endTransaction() {
        this.aZQ.endTransaction();
        this.aZS = false;
        long l = System.currentTimeMillis() - this.aZT;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Transaction completed. Elapsed: %dms", l), new Object[0]);
        }
    }

    @Override
    public void setTransactionSuccessful() {
        this.aZQ.setTransactionSuccessful();
    }

    private SQLiteDatabase zzai(Context context, String string) {
        zza zza2 = new zza(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zza2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException);
            }
            throw sQLiteException;
        }
    }

    private void zzcri() {
        zzann.zzb(this.aZS, "Transaction expected to already be in progress.");
    }

    private int zzc(zzajq zzajq2, zzaml zzaml2) {
        long l = zzani.zzt(zzaml2);
        if (zzaml2 instanceof zzama && l > 16384L) {
            if (this.aZR.zzcyu()) {
                this.aZR.zzi(String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzajq2, l, 16384), new Object[0]);
            }
            int n = 0;
            for (zzamk zzamk2 : zzaml2) {
                n += this.zzc(zzajq2.zza(zzamk2.a()), zzamk2.zzcqy());
            }
            if (!zzaml2.zzczf().isEmpty()) {
                this.zzd(zzajq2.zza(zzalz.zzcyz()), zzaml2.zzczf());
                ++n;
            }
            this.zzd(zzajq2, zzame.zzczq());
            return ++n;
        }
        this.zzd(zzajq2, zzaml2);
        return 1;
    }

    private String zza(zzajq zzajq2, int n) {
        String string = String.valueOf(zzaif.zzc(zzajq2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private void zzd(zzajq zzajq2, zzaml zzaml2) {
        byte[] byArray = this.zzbf(zzaml2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzaif.zzd(byArray, 262144);
            if (this.aZR.zzcyu()) {
                n = list.size();
                this.aZR.zzi(new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString(), new Object[0]);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", this.zza(zzajq2, n));
                contentValues.put("value", list.get(n));
                this.aZQ.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("path", zzaif.zzc(zzajq2));
            contentValues.put("value", byArray);
            this.aZQ.insertWithOnConflict("serverCache", null, contentValues, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private zzaml zzb(zzajq zzajq2) {
        zzajq zzajq3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzajq2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzaml zzaml2 = zzame.zzczq();
        boolean bl = false;
        HashMap<zzajq, void> hashMap = new HashMap<zzajq, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzajq3 = new zzajq(((String)object2).substring(0, ((String)object2).length() - ".part-0000".length()));
                int n = this.zza(zzajq3, arrayList, i);
                if (this.aZR.zzcyu()) {
                    this.aZR.zzi(new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString(), new Object[0]);
                }
                zzaml zzaml3 = this.zzat(this.zzar(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzaml zzaml4 = this.zzat((byte[])arrayList2.get(i));
                zzajq3 = new zzajq((String)arrayList.get(i));
            }
            if (zzajq3.zzcvm() != null && zzajq3.zzcvm().zzczb()) {
                hashMap.put(zzajq3, object);
                continue;
            }
            if (zzajq3.zzi(zzajq2)) {
                zzann.zzb(!bl, "Descendants of path must come after ancestors.");
                zzaml2 = object.zzao(zzajq.zza(zzajq3, zzajq2));
                continue;
            }
            if (zzajq2.zzi(zzajq3)) {
                bl = true;
                object2 = zzajq.zza(zzajq2, zzajq3);
                zzaml2 = zzaml2.zzl((zzajq)object2, (zzaml)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzajq3, zzajq2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzajq3 = (zzajq)entry.getKey();
            zzaml2 = zzaml2.zzl(zzajq.zza(zzajq2, zzajq3), (zzaml)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.aZR.zzcyu()) {
            this.aZR.zzi(String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzani.zzu(zzaml2), zzajq2, l7, l2, l4, l6), new Object[0]);
        }
        return zzaml2;
    }

    private int zza(zzajq zzajq2, List<String> list, int n) {
        int n2;
        String string = zzaif.zzc(zzajq2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(this.zza(zzajq2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private Cursor zza(zzajq zzajq2, String[] stringArray) {
        String string = zzaif.zzc(zzajq2);
        String string2 = zzaif.zzsd(string);
        String[] stringArray2 = new String[zzajq2.size() + 3];
        String string3 = zzaif.zzb(zzajq2, stringArray2);
        String string4 = String.valueOf(string3);
        String string5 = String.valueOf(" OR (path > ? AND path < ?)");
        string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        stringArray2[zzajq2.size() + 1] = string;
        stringArray2[zzajq2.size() + 2] = string2;
        String string6 = "path";
        return this.aZQ.query("serverCache", stringArray, string3, stringArray2, null, null, string6);
    }

    private static String zzc(zzajq zzajq2) {
        if (zzajq2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzajq2.toString()).concat("/");
    }

    private static String zzsd(String string) {
        assert (string.endsWith("/")) : "Path keys must end with a '/'";
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        int n = 48;
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private static String zzb(zzajq zzajq2, String[] stringArray) {
        assert (stringArray.length >= zzajq2.size() + 1);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzajq2.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray[n] = zzaif.zzc(zzajq2);
            zzajq2 = zzajq2.zzcvl();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray[n] = zzaif.zzc(zzajq.zzcvg());
        return stringBuilder.toString();
    }

    private int zza(String string, zzajq zzajq2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzaif.zzc(zzajq2);
        String string4 = zzaif.zzsd(string3);
        return this.aZQ.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / n + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(n, byArray.length - i * n);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * n, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private byte[] zzar(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private byte[] zzbf(Object object) {
        try {
            return zzane.zzbv((Object)object).getBytes(vp);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private zzaml zzat(byte[] byArray) {
        try {
            Object object = zzane.zztc((String)new String(byArray, vp));
            return zzamm.zzbt(object);
        }
        catch (IOException iOException) {
            String string = new String(byArray, vp);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private String zzp(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }

    private static class zza
    extends SQLiteOpenHelper {
        public zza(Context context, String string) {
            super(context, string, null, 2);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            sQLiteDatabase.execSQL("CREATE TABLE writes (id INTEGER, path TEXT, type TEXT, part INTEGER, node BLOB, UNIQUE (id, part));");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            assert (n2 == 2) : "Why is onUpgrade() called with a different version?";
            if (n > 1) {
                throw new AssertionError((Object)new StringBuilder(40).append("We don't handle upgrading to ").append(n2).toString());
            }
            this.zzc(sQLiteDatabase, "serverCache");
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            this.zzc(sQLiteDatabase, "complete");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
        }

        private void zzc(SQLiteDatabase sQLiteDatabase, String string) {
            String string2 = String.valueOf(string);
            sQLiteDatabase.execSQL(string2.length() != 0 ? "DROP TABLE IF EXISTS ".concat(string2) : new String("DROP TABLE IF EXISTS "));
        }
    }
}

