/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.database.DatabaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class DatabaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> aYS = new HashMap<Integer, String>();
    private static final Map<String, Integer> aYT;
    private final int aYU;
    private final String message;
    private final String aYV;

    public static DatabaseError zzsa(String string) {
        return DatabaseError.zzbl(string, null);
    }

    public static DatabaseError zzbl(String string, String string2) {
        return DatabaseError.zzo(string, string2, null);
    }

    public static DatabaseError zzafs(int n) {
        if (!aYS.containsKey(n)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Invalid Firebase Database error code: ").append(n).toString());
        }
        String string = aYS.get(n);
        return new DatabaseError(n, string, null);
    }

    public static DatabaseError zzo(String string, String string2, String string3) {
        Integer n = aYT.get(string.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string4 = string2 == null ? aYS.get(n) : string2;
        return new DatabaseError(n, string4, string3);
    }

    public static DatabaseError fromException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = String.valueOf(aYS.get(-11));
        String string2 = String.valueOf(stringWriter.toString());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        return new DatabaseError(-11, string3);
    }

    private DatabaseError(int n, String string) {
        this(n, string, null);
    }

    private DatabaseError(int n, String string, String string2) {
        this.aYU = n;
        this.message = string;
        this.aYV = string2 == null ? "" : string2;
    }

    public int getCode() {
        return this.aYU;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.aYV;
    }

    public String toString() {
        String string = String.valueOf(this.message);
        return string.length() != 0 ? "DatabaseError: ".concat(string) : new String("DatabaseError: ");
    }

    public DatabaseException toException() {
        String string = String.valueOf(this.message);
        return new DatabaseException(string.length() != 0 ? "Firebase Database error: ".concat(string) : new String("Firebase Database error: "));
    }

    static {
        aYS.put(-1, "The transaction needs to be run again with current data");
        aYS.put(-2, "The server indicated that this operation failed");
        aYS.put(-3, "This client does not have permission to perform this operation");
        aYS.put(-4, "The operation had to be aborted due to a network disconnect");
        aYS.put(-6, "The supplied auth token has expired");
        aYS.put(-7, "The supplied auth token was invalid");
        aYS.put(-8, "The transaction had too many retries");
        aYS.put(-9, "The transaction was overridden by a subsequent set");
        aYS.put(-10, "The service is unavailable");
        aYS.put(-11, "User code called from the Firebase Database runloop threw an exception:\n");
        aYS.put(-24, "The operation could not be performed due to a network error");
        aYS.put(-25, "The write was canceled by the user.");
        aYS.put(-999, "An unknown error occurred");
        aYT = new HashMap<String, Integer>();
        aYT.put("datastale", -1);
        aYT.put("failure", -2);
        aYT.put("permission_denied", -3);
        aYT.put("disconnected", -4);
        aYT.put("expired_token", -6);
        aYT.put("invalid_token", -7);
        aYT.put("maxretries", -8);
        aYT.put("overriddenbyset", -9);
        aYT.put("unavailable", -10);
        aYT.put("network_error", -24);
        aYT.put("write_canceled", -25);
    }
}

