/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.zzdd;
import com.google.android.gms.internal.zzdzj;
import com.google.android.gms.internal.zzdzp;
import com.google.android.gms.internal.zzdzr;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.firebase.dynamiclinks.DynamicLink;
import com.google.firebase.dynamiclinks.FirebaseDynamicLinks;
import com.google.firebase.dynamiclinks.PendingDynamicLinkData;
import com.google.firebase.dynamiclinks.ShortDynamicLink;

public final class zzdzm
extends FirebaseDynamicLinks {
    private final GoogleApi<Api.ApiOptions.NoOptions> zzfov;

    public zzdzm(@NonNull Context context) {
        this(new zzdzj(context));
    }

    private zzdzm(@NonNull GoogleApi<Api.ApiOptions.NoOptions> googleApi) {
        this.zzfov = googleApi;
    }

    private final void zzbyf() {
        try {
            AppMeasurement.getInstance((Context)this.zzfov.getApplicationContext());
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Log.w((String)"FDL", (String)"FDL logging failed. Add a dependency for Firebase Analytics to your app to enable logging of Dynamic Link events.");
            return;
        }
    }

    @Override
    public final Task<PendingDynamicLinkData> getDynamicLink(@NonNull Intent intent) {
        this.zzbyf();
        return this.zzfov.zzb((zzdd)new zzdzr(this.zzfov.getApplicationContext(), intent.getDataString()));
    }

    @Override
    public final Task<PendingDynamicLinkData> getDynamicLink(@NonNull Uri uri) {
        this.zzbyf();
        return this.zzfov.zzb((zzdd)new zzdzr(this.zzfov.getApplicationContext(), uri.toString()));
    }

    @Override
    public final DynamicLink.Builder createDynamicLink() {
        return new DynamicLink.Builder(this);
    }

    public final Task<ShortDynamicLink> zzz(Bundle bundle) {
        zzdzm.zzaa(bundle);
        return this.zzfov.zzb((zzdd)new zzdzp(bundle));
    }

    public static void zzaa(Bundle bundle) {
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (TextUtils.isEmpty((CharSequence)bundle.getString("domain")) && uri == null) {
            throw new IllegalArgumentException("FDL domain is missing. Set with setDynamicLinkDomain().");
        }
    }
}

