/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.internal.FirebaseDynamicLinksImpl;

public final class DynamicLink {
    private final Bundle builderParameters;

    DynamicLink(Bundle builderParameters) {
        this.builderParameters = builderParameters;
    }

    @NonNull
    public Uri getUri() {
        return FirebaseDynamicLinksImpl.createDynamicLink(this.builderParameters);
    }

    public static final class NavigationInfoParameters {
        @VisibleForTesting
        public static final String KEY_FORCED_REDIRECT = "efr";
        final Bundle parameters;

        private NavigationInfoParameters(Bundle parameters) {
            this.parameters = parameters;
        }

        public static final class Builder {
            private final Bundle parameters = new Bundle();

            @NonNull
            public Builder setForcedRedirectEnabled(boolean forcedRedirectEnabled) {
                this.parameters.putInt(NavigationInfoParameters.KEY_FORCED_REDIRECT, forcedRedirectEnabled ? 1 : 0);
                return this;
            }

            public boolean getForcedRedirectEnabled() {
                return this.parameters.getInt(NavigationInfoParameters.KEY_FORCED_REDIRECT) == 1;
            }

            @NonNull
            public NavigationInfoParameters build() {
                return new NavigationInfoParameters(this.parameters);
            }
        }
    }

    public static final class SocialMetaTagParameters {
        @VisibleForTesting
        public static final String KEY_SOCIAL_TITLE = "st";
        @VisibleForTesting
        public static final String KEY_SOCIAL_DESCRIPTION = "sd";
        @VisibleForTesting
        public static final String KEY_SOCIAL_IMAGE_LINK = "si";
        final Bundle parameters;

        private SocialMetaTagParameters(Bundle parameters) {
            this.parameters = parameters;
        }

        public static final class Builder {
            private final Bundle parameters = new Bundle();

            @NonNull
            public Builder setTitle(@NonNull String title) {
                this.parameters.putString(SocialMetaTagParameters.KEY_SOCIAL_TITLE, title);
                return this;
            }

            @NonNull
            public String getTitle() {
                return this.parameters.getString(SocialMetaTagParameters.KEY_SOCIAL_TITLE, "");
            }

            @NonNull
            public Builder setDescription(@NonNull String description) {
                this.parameters.putString(SocialMetaTagParameters.KEY_SOCIAL_DESCRIPTION, description);
                return this;
            }

            @NonNull
            public String getDescription() {
                return this.parameters.getString(SocialMetaTagParameters.KEY_SOCIAL_DESCRIPTION, "");
            }

            @NonNull
            public Builder setImageUrl(@NonNull Uri imageUrl) {
                this.parameters.putParcelable(SocialMetaTagParameters.KEY_SOCIAL_IMAGE_LINK, (Parcelable)imageUrl);
                return this;
            }

            @NonNull
            public Uri getImageUrl() {
                Uri imageUrl = (Uri)this.parameters.getParcelable(SocialMetaTagParameters.KEY_SOCIAL_IMAGE_LINK);
                if (imageUrl == null) {
                    imageUrl = Uri.EMPTY;
                }
                return imageUrl;
            }

            @NonNull
            public SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.parameters);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        @VisibleForTesting
        public static final String KEY_ITUNES_CONNECT_PT = "pt";
        @VisibleForTesting
        public static final String KEY_ITUNES_CONNECT_AT = "at";
        @VisibleForTesting
        public static final String KEY_ITUNES_CONNECT_CT = "ct";
        final Bundle parameters;

        private ItunesConnectAnalyticsParameters(Bundle parameters) {
            this.parameters = parameters;
        }

        public static final class Builder {
            private final Bundle parameters = new Bundle();

            @NonNull
            public Builder setProviderToken(@NonNull String providerToken) {
                this.parameters.putString(ItunesConnectAnalyticsParameters.KEY_ITUNES_CONNECT_PT, providerToken);
                return this;
            }

            @NonNull
            public String getProviderToken() {
                return this.parameters.getString(ItunesConnectAnalyticsParameters.KEY_ITUNES_CONNECT_PT, "");
            }

            @NonNull
            public Builder setAffiliateToken(@NonNull String affiliateToken) {
                this.parameters.putString(ItunesConnectAnalyticsParameters.KEY_ITUNES_CONNECT_AT, affiliateToken);
                return this;
            }

            @NonNull
            public String getAffiliateToken() {
                return this.parameters.getString(ItunesConnectAnalyticsParameters.KEY_ITUNES_CONNECT_AT, "");
            }

            @NonNull
            public Builder setCampaignToken(@NonNull String campaignToken) {
                this.parameters.putString(ItunesConnectAnalyticsParameters.KEY_ITUNES_CONNECT_CT, campaignToken);
                return this;
            }

            @NonNull
            public String getCampaignToken() {
                return this.parameters.getString(ItunesConnectAnalyticsParameters.KEY_ITUNES_CONNECT_CT, "");
            }

            @NonNull
            public ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.parameters);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        @VisibleForTesting
        public static final String KEY_UTM_CAMPAIGN = "utm_campaign";
        @VisibleForTesting
        public static final String KEY_UTM_SOURCE = "utm_source";
        @VisibleForTesting
        public static final String KEY_UTM_MEDIUM = "utm_medium";
        @VisibleForTesting
        public static final String KEY_UTM_TERM = "utm_term";
        @VisibleForTesting
        public static final String KEY_UTM_CONTENT = "utm_content";
        Bundle parameters;

        private GoogleAnalyticsParameters(Bundle parameters) {
            this.parameters = parameters;
        }

        public static final class Builder {
            private final Bundle parameters = new Bundle();

            public Builder() {
            }

            public Builder(@NonNull String source, @NonNull String medium, @NonNull String campaign) {
                this.parameters.putString(GoogleAnalyticsParameters.KEY_UTM_SOURCE, source);
                this.parameters.putString(GoogleAnalyticsParameters.KEY_UTM_MEDIUM, medium);
                this.parameters.putString(GoogleAnalyticsParameters.KEY_UTM_CAMPAIGN, campaign);
            }

            @NonNull
            public Builder setSource(@NonNull String source) {
                this.parameters.putString(GoogleAnalyticsParameters.KEY_UTM_SOURCE, source);
                return this;
            }

            @NonNull
            public String getSource() {
                return this.parameters.getString(GoogleAnalyticsParameters.KEY_UTM_SOURCE, "");
            }

            @NonNull
            public Builder setMedium(@NonNull String medium) {
                this.parameters.putString(GoogleAnalyticsParameters.KEY_UTM_MEDIUM, medium);
                return this;
            }

            @NonNull
            public String getMedium() {
                return this.parameters.getString(GoogleAnalyticsParameters.KEY_UTM_MEDIUM, "");
            }

            @NonNull
            public Builder setCampaign(@NonNull String campaign) {
                this.parameters.putString(GoogleAnalyticsParameters.KEY_UTM_CAMPAIGN, campaign);
                return this;
            }

            @NonNull
            public String getCampaign() {
                return this.parameters.getString(GoogleAnalyticsParameters.KEY_UTM_CAMPAIGN, "");
            }

            @NonNull
            public Builder setTerm(@NonNull String term) {
                this.parameters.putString(GoogleAnalyticsParameters.KEY_UTM_TERM, term);
                return this;
            }

            @NonNull
            public String getTerm() {
                return this.parameters.getString(GoogleAnalyticsParameters.KEY_UTM_TERM, "");
            }

            @NonNull
            public Builder setContent(@NonNull String content) {
                this.parameters.putString(GoogleAnalyticsParameters.KEY_UTM_CONTENT, content);
                return this;
            }

            @NonNull
            public String getContent() {
                return this.parameters.getString(GoogleAnalyticsParameters.KEY_UTM_CONTENT, "");
            }

            @NonNull
            public GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.parameters);
            }
        }
    }

    public static final class IosParameters {
        @VisibleForTesting
        public static final String KEY_IOS_BUNDLE_ID = "ibi";
        @VisibleForTesting
        public static final String KEY_IOS_FALLBACK_LINK = "ifl";
        @VisibleForTesting
        public static final String KEY_IOS_CUSTOM_SCHEME = "ius";
        @VisibleForTesting
        public static final String KEY_IPAD_FALLBACK_LINK = "ipfl";
        @VisibleForTesting
        public static final String KEY_IPAD_BUNDLE_ID = "ipbi";
        @VisibleForTesting
        public static final String KEY_IOS_APP_STORE_ID = "isi";
        @VisibleForTesting
        public static final String KEY_IOS_MINIMUM_VERSION = "imv";
        final Bundle parameters;

        private IosParameters(Bundle parameters) {
            this.parameters = parameters;
        }

        public static final class Builder {
            private final Bundle parameters = new Bundle();

            public Builder(@NonNull String bundleId) {
                this.parameters.putString(IosParameters.KEY_IOS_BUNDLE_ID, bundleId);
            }

            @NonNull
            public Builder setFallbackUrl(@NonNull Uri fallbackUrl) {
                this.parameters.putParcelable(IosParameters.KEY_IOS_FALLBACK_LINK, (Parcelable)fallbackUrl);
                return this;
            }

            @NonNull
            public Builder setCustomScheme(@NonNull String customScheme) {
                this.parameters.putString(IosParameters.KEY_IOS_CUSTOM_SCHEME, customScheme);
                return this;
            }

            @NonNull
            public String getCustomScheme() {
                return this.parameters.getString(IosParameters.KEY_IOS_CUSTOM_SCHEME, "");
            }

            @NonNull
            public Builder setIpadFallbackUrl(@NonNull Uri fallbackUrl) {
                this.parameters.putParcelable(IosParameters.KEY_IPAD_FALLBACK_LINK, (Parcelable)fallbackUrl);
                return this;
            }

            @NonNull
            public Uri getIpadFallbackUrl() {
                Uri fallbackUrl = (Uri)this.parameters.getParcelable(IosParameters.KEY_IPAD_FALLBACK_LINK);
                if (fallbackUrl == null) {
                    fallbackUrl = Uri.EMPTY;
                }
                return fallbackUrl;
            }

            @NonNull
            public Builder setIpadBundleId(@NonNull String bundleId) {
                this.parameters.putString(IosParameters.KEY_IPAD_BUNDLE_ID, bundleId);
                return this;
            }

            @NonNull
            public String getIpadBundleId() {
                return this.parameters.getString(IosParameters.KEY_IPAD_BUNDLE_ID, "");
            }

            @NonNull
            public Builder setAppStoreId(@NonNull String appStoreId) {
                this.parameters.putString(IosParameters.KEY_IOS_APP_STORE_ID, appStoreId);
                return this;
            }

            @NonNull
            public String getAppStoreId() {
                return this.parameters.getString(IosParameters.KEY_IOS_APP_STORE_ID, "");
            }

            @NonNull
            public Builder setMinimumVersion(@NonNull String minimumVersion) {
                this.parameters.putString(IosParameters.KEY_IOS_MINIMUM_VERSION, minimumVersion);
                return this;
            }

            @NonNull
            public String getMinimumVersion() {
                return this.parameters.getString(IosParameters.KEY_IOS_MINIMUM_VERSION, "");
            }

            @NonNull
            public IosParameters build() {
                return new IosParameters(this.parameters);
            }
        }
    }

    public static final class AndroidParameters {
        @VisibleForTesting
        public static final String KEY_ANDROID_PACKAGE_NAME = "apn";
        @VisibleForTesting
        public static final String KEY_ANDROID_FALLBACK_LINK = "afl";
        @VisibleForTesting
        public static final String KEY_ANDROID_MIN_VERSION_CODE = "amv";
        final Bundle parameters;

        private AndroidParameters(Bundle parameters) {
            this.parameters = parameters;
        }

        public static final class Builder {
            private final Bundle parameters;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.parameters = new Bundle();
                this.parameters.putString(AndroidParameters.KEY_ANDROID_PACKAGE_NAME, FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String packageName) {
                this.parameters = new Bundle();
                this.parameters.putString(AndroidParameters.KEY_ANDROID_PACKAGE_NAME, packageName);
            }

            @NonNull
            public Builder setFallbackUrl(@NonNull Uri fallbackUrl) {
                this.parameters.putParcelable(AndroidParameters.KEY_ANDROID_FALLBACK_LINK, (Parcelable)fallbackUrl);
                return this;
            }

            @NonNull
            public Uri getFallbackUrl() {
                Uri fallbackUrl = (Uri)this.parameters.getParcelable(AndroidParameters.KEY_ANDROID_FALLBACK_LINK);
                if (fallbackUrl == null) {
                    fallbackUrl = Uri.EMPTY;
                }
                return fallbackUrl;
            }

            @NonNull
            public Builder setMinimumVersion(int minimumVersion) {
                this.parameters.putInt(AndroidParameters.KEY_ANDROID_MIN_VERSION_CODE, minimumVersion);
                return this;
            }

            public int getMinimumVersion() {
                return this.parameters.getInt(AndroidParameters.KEY_ANDROID_MIN_VERSION_CODE);
            }

            @NonNull
            public AndroidParameters build() {
                return new AndroidParameters(this.parameters);
            }
        }
    }

    public static final class Builder {
        @VisibleForTesting
        public static final String KEY_DOMAIN = "domain";
        public static final String KEY_DOMAIN_URI_PREFIX = "domainUriPrefix";
        public static final String KEY_DYNAMIC_LINK = "dynamicLink";
        public static final String KEY_DYNAMIC_LINK_PARAMETERS = "parameters";
        public static final String KEY_SUFFIX = "suffix";
        public static final String KEY_API_KEY = "apiKey";
        @VisibleForTesting
        public static final String KEY_LINK = "link";
        private static final String SCHEME_PREFIX = "https://";
        private static final String PAGE_LINK_PATTERN = "(https:\\/\\/)?[a-z0-9]{3,}\\.page\\.link$";
        private static final String APP_GOO_GL_PATTERN = "(https:\\/\\/)?[a-z0-9]{3,}\\.app\\.goo\\.gl$";
        private final FirebaseDynamicLinksImpl firebaseDynamicLinksImpl;
        private final Bundle builderParameters;
        private final Bundle fdlParameters;

        public Builder(FirebaseDynamicLinksImpl firebaseDynamicLinks) {
            this.firebaseDynamicLinksImpl = firebaseDynamicLinks;
            this.builderParameters = new Bundle();
            this.builderParameters.putString(KEY_API_KEY, firebaseDynamicLinks.getFirebaseApp().getOptions().getApiKey());
            this.fdlParameters = new Bundle();
            this.builderParameters.putBundle(KEY_DYNAMIC_LINK_PARAMETERS, this.fdlParameters);
        }

        @NonNull
        public Builder setLongLink(@NonNull Uri longLink) {
            this.builderParameters.putParcelable(KEY_DYNAMIC_LINK, (Parcelable)longLink);
            return this;
        }

        @NonNull
        public Uri getLongLink() {
            Uri longLink = (Uri)this.fdlParameters.getParcelable(KEY_DYNAMIC_LINK);
            if (longLink == null) {
                longLink = Uri.EMPTY;
            }
            return longLink;
        }

        @NonNull
        public Builder setLink(@NonNull Uri link) {
            this.fdlParameters.putParcelable(KEY_LINK, (Parcelable)link);
            return this;
        }

        @NonNull
        public Uri getLink() {
            Uri link = (Uri)this.fdlParameters.getParcelable(KEY_LINK);
            if (link == null) {
                link = Uri.EMPTY;
            }
            return link;
        }

        @Deprecated
        @NonNull
        public Builder setDynamicLinkDomain(@NonNull String dynamicLinkDomain) {
            if (!dynamicLinkDomain.matches(APP_GOO_GL_PATTERN) && !dynamicLinkDomain.matches(PAGE_LINK_PATTERN)) {
                throw new IllegalArgumentException("Use setDomainUriPrefix() instead, setDynamicLinkDomain() is only applicable for *.page.link and *.app.goo.gl domains.");
            }
            this.builderParameters.putString(KEY_DOMAIN, dynamicLinkDomain);
            this.builderParameters.putString(KEY_DOMAIN_URI_PREFIX, SCHEME_PREFIX + dynamicLinkDomain);
            return this;
        }

        @NonNull
        public Builder setDomainUriPrefix(@NonNull String domainUriPrefix) {
            if (domainUriPrefix.matches(APP_GOO_GL_PATTERN) || domainUriPrefix.matches(PAGE_LINK_PATTERN)) {
                this.builderParameters.putString(KEY_DOMAIN, domainUriPrefix.replace(SCHEME_PREFIX, ""));
            }
            this.builderParameters.putString(KEY_DOMAIN_URI_PREFIX, domainUriPrefix);
            return this;
        }

        @NonNull
        public String getDomainUriPrefix() {
            return this.builderParameters.getString(KEY_DOMAIN_URI_PREFIX, "");
        }

        @NonNull
        public Builder setAndroidParameters(@NonNull AndroidParameters androidParameters) {
            this.fdlParameters.putAll(androidParameters.parameters);
            return this;
        }

        @NonNull
        public Builder setIosParameters(@NonNull IosParameters iosParameters) {
            this.fdlParameters.putAll(iosParameters.parameters);
            return this;
        }

        @NonNull
        public Builder setGoogleAnalyticsParameters(@NonNull GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.fdlParameters.putAll(googleAnalyticsParameters.parameters);
            return this;
        }

        @NonNull
        public Builder setItunesConnectAnalyticsParameters(@NonNull ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.fdlParameters.putAll(itunesConnectAnalyticsParameters.parameters);
            return this;
        }

        @NonNull
        public Builder setSocialMetaTagParameters(@NonNull SocialMetaTagParameters socialMetaTagParameters) {
            this.fdlParameters.putAll(socialMetaTagParameters.parameters);
            return this;
        }

        @NonNull
        public Builder setNavigationInfoParameters(@NonNull NavigationInfoParameters navigationInfoParameters) {
            this.fdlParameters.putAll(navigationInfoParameters.parameters);
            return this;
        }

        @NonNull
        public DynamicLink buildDynamicLink() {
            FirebaseDynamicLinksImpl.verifyDomainUriPrefix(this.builderParameters);
            return new DynamicLink(this.builderParameters);
        }

        @NonNull
        public Task<ShortDynamicLink> buildShortDynamicLink() {
            this.verifyApiKey();
            return this.firebaseDynamicLinksImpl.createShortDynamicLink(this.builderParameters);
        }

        @NonNull
        public Task<ShortDynamicLink> buildShortDynamicLink(int suffix) {
            this.verifyApiKey();
            this.builderParameters.putInt(KEY_SUFFIX, suffix);
            return this.firebaseDynamicLinksImpl.createShortDynamicLink(this.builderParameters);
        }

        private void verifyApiKey() {
            if (this.builderParameters.getString(KEY_API_KEY) == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

