/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.json;

import android.util.Base64;
import android.util.JsonWriter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.ValueEncoderContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;

final class JsonValueObjectEncoderContext
implements ObjectEncoderContext,
ValueEncoderContext {
    private JsonValueObjectEncoderContext childContext = null;
    private boolean active = true;
    private final JsonWriter jsonWriter;
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders;
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders;

    JsonValueObjectEncoderContext(@NonNull Writer writer, @NonNull Map<Class<?>, ObjectEncoder<?>> objectEncoders, @NonNull Map<Class<?>, ValueEncoder<?>> valueEncoders) {
        this.jsonWriter = new JsonWriter(writer);
        this.objectEncoders = objectEncoders;
        this.valueEncoders = valueEncoders;
    }

    private JsonValueObjectEncoderContext(JsonValueObjectEncoderContext anotherContext) {
        this.jsonWriter = anotherContext.jsonWriter;
        this.objectEncoders = anotherContext.objectEncoders;
        this.valueEncoders = anotherContext.valueEncoders;
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, @Nullable Object o) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        if (o == null) {
            this.jsonWriter.nullValue();
            return this;
        }
        return this.add(o);
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, double value) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        return this.add(value);
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, int value) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        return this.add(value);
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, long value) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        return this.add(value);
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, boolean value) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        return this.add(value);
    }

    @Override
    @NonNull
    public ObjectEncoderContext nested(@NonNull String name) throws IOException {
        this.maybeUnNest();
        this.childContext = new JsonValueObjectEncoderContext(this);
        this.jsonWriter.name(name);
        this.jsonWriter.beginObject();
        return this.childContext;
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(@Nullable String value) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.value(value);
        return this;
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(double value) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.value(value);
        return this;
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(int value) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.value((long)value);
        return this;
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(long value) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.value(value);
        return this;
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(boolean value) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.value(value);
        return this;
    }

    @Override
    @NonNull
    public JsonValueObjectEncoderContext add(@Nullable byte[] bytes) throws IOException, EncodingException {
        this.maybeUnNest();
        if (bytes == null) {
            this.jsonWriter.nullValue();
        } else {
            this.jsonWriter.value(Base64.encodeToString((byte[])bytes, (int)2));
        }
        return this;
    }

    @NonNull
    JsonValueObjectEncoderContext add(@Nullable Object o) throws IOException, EncodingException {
        if (o == null) {
            this.jsonWriter.nullValue();
            return this;
        }
        if (o instanceof Number) {
            this.jsonWriter.value((Number)o);
            return this;
        }
        if (o.getClass().isArray()) {
            if (o instanceof byte[]) {
                return this.add((byte[])o);
            }
            this.jsonWriter.beginArray();
            if (o instanceof int[]) {
                for (int item : (int[])o) {
                    this.jsonWriter.value((long)item);
                }
            } else if (o instanceof long[]) {
                for (long item : (long[])o) {
                    this.add(item);
                }
            } else if (o instanceof double[]) {
                for (double item : (double[])o) {
                    this.jsonWriter.value(item);
                }
            } else if (o instanceof boolean[]) {
                for (boolean item : (boolean[])o) {
                    this.jsonWriter.value(item);
                }
            } else if (o instanceof Number[]) {
                for (Number item : (Number[])o) {
                    this.add(item);
                }
            } else {
                for (Object item : (Object[])o) {
                    this.add(item);
                }
            }
            this.jsonWriter.endArray();
            return this;
        }
        if (o instanceof Collection) {
            Collection collection = (Collection)o;
            this.jsonWriter.beginArray();
            for (Object elem : collection) {
                this.add(elem);
            }
            this.jsonWriter.endArray();
            return this;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            this.jsonWriter.beginObject();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                try {
                    this.add((String)key, entry.getValue());
                }
                catch (ClassCastException ex) {
                    throw new EncodingException(String.format("Only String keys are currently supported in maps, got %s of type %s instead.", key, key.getClass()), ex);
                }
            }
            this.jsonWriter.endObject();
            return this;
        }
        ObjectEncoder<?> objectEncoder = this.objectEncoders.get(o.getClass());
        if (objectEncoder != null) {
            this.jsonWriter.beginObject();
            objectEncoder.encode(o, this);
            this.jsonWriter.endObject();
            return this;
        }
        ValueEncoder<?> valueEncoder = this.valueEncoders.get(o.getClass());
        if (valueEncoder != null) {
            valueEncoder.encode(o, this);
            return this;
        }
        if (o instanceof Enum) {
            this.add(((Enum)o).name());
            return this;
        }
        throw new EncodingException("Couldn't find encoder for type " + o.getClass().getCanonicalName());
    }

    void close() throws IOException {
        this.maybeUnNest();
        this.jsonWriter.flush();
    }

    private void maybeUnNest() throws IOException {
        if (!this.active) {
            throw new IllegalStateException("Parent context used since this context was created. Cannot use this context anymore.");
        }
        if (this.childContext != null) {
            this.childContext.maybeUnNest();
            this.childContext.active = false;
            this.childContext = null;
            this.jsonWriter.endObject();
        }
    }
}

