/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.obfuscated.zzag;
import com.google.firebase.firestore.obfuscated.zzdl;
import com.google.firebase.firestore.obfuscated.zzds;
import com.google.firebase.firestore.obfuscated.zzgr;
import com.google.firebase.firestore.obfuscated.zzhc;
import com.google.firebase.firestore.zza;
import java.util.Map;
import javax.annotation.Nullable;

@PublicApi
public class CollectionReference
extends Query {
    /*
     * WARNING - void declaration
     */
    CollectionReference(zzds path, FirebaseFirestore firestore) {
        super(zzag.zza(path), (FirebaseFirestore)var2_2);
        void var2_2;
        if (path.zzg() % 2 != 1) {
            void var1_1;
            throw new IllegalArgumentException("Invalid collection reference. Collection references must have an odd number of segments, but " + path.zzf() + " has " + var1_1.zzg());
        }
    }

    @NonNull
    @PublicApi
    public String getId() {
        return this.zza.zza().zzc();
    }

    @Nullable
    @PublicApi
    public DocumentReference getParent() {
        zzds zzds2 = (zzds)this.zza.zza().zzb();
        if (zzds2.zze()) {
            return null;
        }
        return new DocumentReference(zzdl.zza(zzds2), this.zzb);
    }

    @NonNull
    @PublicApi
    public String getPath() {
        return this.zza.zza().zzf();
    }

    @NonNull
    @PublicApi
    public DocumentReference document() {
        return this.document(zzhc.zza());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public DocumentReference document(@NonNull String documentPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)documentPath, (Object)"Provided document path must not be null.");
        return DocumentReference.zza(this.zza.zza().zza(zzds.zzb((String)var1_1)), this.zzb);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Task<DocumentReference> add(@NonNull Map<String, Object> data) {
        void var1_1;
        Preconditions.checkNotNull(data, (Object)"Provided data must not be null.");
        DocumentReference documentReference = this.document();
        return documentReference.set((Map<String, Object>)var1_1).continueWith(zzgr.zzb, com.google.firebase.firestore.zza.zza(documentReference));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Task<DocumentReference> add(@NonNull Object pojo) {
        void var1_1;
        return this.add(FirebaseFirestoreSettings.1.zzb(var1_1));
    }

    static /* synthetic */ DocumentReference zza(DocumentReference documentReference, Task task) throws Exception {
        task.getResult();
        return documentReference;
    }
}

