/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.firebase.Timestamp;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.SnapshotMetadata;
import com.google.firebase.firestore.obfuscated.zzdi;
import com.google.firebase.firestore.obfuscated.zzdj;
import com.google.firebase.firestore.obfuscated.zzdl;
import com.google.firebase.firestore.obfuscated.zzdp;
import com.google.firebase.firestore.obfuscated.zzei;
import com.google.firebase.firestore.obfuscated.zzem;
import com.google.firebase.firestore.obfuscated.zzen;
import com.google.firebase.firestore.obfuscated.zzes;
import com.google.firebase.firestore.obfuscated.zzet;
import com.google.firebase.firestore.obfuscated.zzgo;
import com.google.firebase.firestore.obfuscated.zzha;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@PublicApi
public class DocumentSnapshot {
    private final FirebaseFirestore zza;
    private final zzdl zzb;
    @Nullable
    private final zzdj zzc;
    private final SnapshotMetadata zzd;

    /*
     * WARNING - void declaration
     */
    DocumentSnapshot(FirebaseFirestore firestore, zzdl key, @Nullable zzdj doc, boolean isFromCache) {
        void var3_4;
        void var2_3;
        void var1_1;
        this.zza = (FirebaseFirestore)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (zzdl)Preconditions.checkNotNull((Object)var2_3);
        this.zzc = var3_4;
        boolean bl = this.zzc != null && this.zzc.zzc();
        this.zzd = new SnapshotMetadata(bl, isFromCache);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, zzdj zzdj2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zzdj2.zzd(), zzdj2, bl);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, zzdl zzdl2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zzdl2, null, bl);
    }

    @NonNull
    @PublicApi
    public String getId() {
        return this.zzb.zzd().zzc();
    }

    @NonNull
    @PublicApi
    public SnapshotMetadata getMetadata() {
        return this.zzd;
    }

    @PublicApi
    public boolean exists() {
        return this.zzc != null;
    }

    @Nullable
    final zzdj zza() {
        return this.zzc;
    }

    @Nullable
    @PublicApi
    public Map<String, Object> getData() {
        return this.getData(ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Map<String, Object> getData(@NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var1_1;
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        if (this.zzc == null) {
            return null;
        }
        return this.zza(this.zzc.zzb(), zzen.zza((ServerTimestampBehavior)var1_1, this.zza.getFirestoreSettings().areTimestampsInSnapshotsEnabled()));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public <T> T toObject(@NonNull Class<T> valueType) {
        void var1_1;
        return this.toObject((Class<T>)var1_1, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public <T> T toObject(@NonNull Class<T> valueType, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var1_1;
        Map<String, Object> map;
        Preconditions.checkNotNull(valueType, (Object)"Provided POJO type must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        map = this.getData((ServerTimestampBehavior)((Object)map));
        if (map == null) {
            return null;
        }
        return zzgo.zza(map, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @PublicApi
    public boolean contains(@NonNull String field) {
        void var1_1;
        return this.contains(FieldPath.zza((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @PublicApi
    public boolean contains(@NonNull FieldPath fieldPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zzc != null && this.zzc.zza(var1_1.zza()) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Object get(@NonNull String field) {
        void var1_1;
        return this.get(FieldPath.zza((String)var1_1), ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Object get(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var2_2;
        void var1_1;
        return this.get(FieldPath.zza((String)var1_1), (ServerTimestampBehavior)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Object get(@NonNull FieldPath fieldPath) {
        void var1_1;
        return this.get((FieldPath)var1_1, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Object get(@NonNull FieldPath fieldPath, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        return this.zza(var1_1.zza(), zzen.zza((ServerTimestampBehavior)var2_2, this.zza.getFirestoreSettings().areTimestampsInSnapshotsEnabled()));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Boolean getBoolean(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, Boolean.class);
    }

    @Nullable
    @PublicApi
    public Double getDouble(@NonNull String field) {
        Number number;
        if ((number = this.zza((String)((Object)number), Number.class)) != null) {
            return number.doubleValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public String getString(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, String.class);
    }

    @Nullable
    @PublicApi
    public Long getLong(@NonNull String field) {
        Number number;
        if ((number = this.zza((String)((Object)number), Number.class)) != null) {
            return number.longValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Date getDate(@NonNull String field) {
        void var1_1;
        return this.getDate((String)var1_1, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Date getDate(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var1_1;
        Object object;
        Preconditions.checkNotNull((Object)field, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        object = this.zza(FieldPath.zza(field).zza(), zzen.zza((ServerTimestampBehavior)((Object)object), false));
        return DocumentSnapshot.zza(object, (String)var1_1, Date.class);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Timestamp getTimestamp(@NonNull String field) {
        void var1_1;
        return this.getTimestamp((String)var1_1, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Timestamp getTimestamp(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var1_1;
        Object object;
        Preconditions.checkNotNull((Object)field, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        object = this.zza(FieldPath.zza(field).zza(), zzen.zza((ServerTimestampBehavior)((Object)object), true));
        return DocumentSnapshot.zza(object, (String)var1_1, Timestamp.class);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public Blob getBlob(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, Blob.class);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public GeoPoint getGeoPoint(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, GeoPoint.class);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @PublicApi
    public DocumentReference getDocumentReference(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, DocumentReference.class);
    }

    @NonNull
    @PublicApi
    public DocumentReference getReference() {
        return new DocumentReference(this.zzb, this.zza);
    }

    @Nullable
    private <T> T zza(String string, Class<T> clazz) {
        Preconditions.checkNotNull((Object)string, (Object)"Provided field must not be null.");
        Object object = this.get(string, ServerTimestampBehavior.zza);
        return DocumentSnapshot.zza(object, string, clazz);
    }

    @Nullable
    private static <T> T zza(Object object, String string, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (!clazz.isInstance(object)) {
            throw new RuntimeException("Field '" + string + "' is not a " + clazz.getName());
        }
        return clazz.cast(object);
    }

    @Nullable
    private Object zza(zzem object, zzen iterator) {
        if (object instanceof zzes) {
            return this.zza((zzes)object, (zzen)((Object)iterator));
        }
        if (object instanceof zzei) {
            zzen zzen2 = iterator;
            iterator = (zzei)object;
            object = this;
            ArrayList<Object> arrayList = new ArrayList<Object>(((zzei)((Object)iterator)).zzb().size());
            for (zzem zzem2 : ((zzei)((Object)iterator)).zzb()) {
                arrayList.add(super.zza(zzem2, zzen2));
            }
            return arrayList;
        }
        if (object instanceof zzet) {
            Comparable<zzem> comparable = (zzet)object;
            iterator = (zzdl)((zzem)comparable).zza((zzen)((Object)iterator));
            if (!((zzdi)(object = ((zzet)object).zzb())).equals(comparable = this.zza.zzb())) {
                zzha.zza("DocumentSnapshot", "Document %s contains a document reference within a different database (%s/%s) which is not supported. It will be treated as a reference in the current database (%s/%s) instead.", ((zzdl)((Object)iterator)).zzd(), ((zzdi)object).zza(), ((zzdi)object).zzb(), ((zzdi)comparable).zza(), ((zzdi)comparable).zzb());
            }
            return new DocumentReference((zzdl)((Object)iterator), this.zza);
        }
        return ((zzem)object).zza((zzen)((Object)iterator));
    }

    private Map<String, Object> zza(zzes object, zzen zzen2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : ((zzes)object).zzd()) {
            hashMap.put((String)entry.getKey(), this.zza((zzem)entry.getValue(), zzen2));
        }
        return hashMap;
    }

    @Nullable
    private Object zza(@NonNull zzdp comparable, @NonNull zzen zzen2) {
        if (this.zzc != null && (comparable = this.zzc.zza((zzdp)comparable)) != null) {
            return this.zza((zzem)comparable, zzen2);
        }
        return null;
    }

    public boolean equals(@Nullable Object obj) {
        DocumentSnapshot documentSnapshot;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DocumentSnapshot)) {
            return false;
        }
        documentSnapshot = documentSnapshot;
        return this.zza.equals(documentSnapshot.zza) && this.zzb.equals(documentSnapshot.zzb) && (this.zzc == null ? documentSnapshot.zzc == null : this.zzc.equals(documentSnapshot.zzc)) && this.zzd.equals(documentSnapshot.zzd);
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        n = n * 31 + this.zzb.hashCode();
        n = n * 31 + (this.zzc != null ? this.zzc.hashCode() : 0);
        n = n * 31 + this.zzd.hashCode();
        return n;
    }

    public String toString() {
        return "DocumentSnapshot{key=" + this.zzb + ", metadata=" + this.zzd + ", doc=" + this.zzc + '}';
    }

    @PublicApi
    public static enum ServerTimestampBehavior {
        NONE,
        ESTIMATE,
        PREVIOUS;

        static final ServerTimestampBehavior zza;

        static {
            zza = NONE;
        }
    }
}

