/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.Timestamp;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.WriteBatch;
import com.google.firebase.firestore.obfuscated.zza;
import com.google.firebase.firestore.obfuscated.zzao;
import com.google.firebase.firestore.obfuscated.zzas;
import com.google.firebase.firestore.obfuscated.zzat;
import com.google.firebase.firestore.obfuscated.zzau;
import com.google.firebase.firestore.obfuscated.zzav;
import com.google.firebase.firestore.obfuscated.zzaw;
import com.google.firebase.firestore.obfuscated.zzb;
import com.google.firebase.firestore.obfuscated.zzc;
import com.google.firebase.firestore.obfuscated.zzdi;
import com.google.firebase.firestore.obfuscated.zzdp;
import com.google.firebase.firestore.obfuscated.zzds;
import com.google.firebase.firestore.obfuscated.zzdu;
import com.google.firebase.firestore.obfuscated.zzdw;
import com.google.firebase.firestore.obfuscated.zzee;
import com.google.firebase.firestore.obfuscated.zzei;
import com.google.firebase.firestore.obfuscated.zzej;
import com.google.firebase.firestore.obfuscated.zzek;
import com.google.firebase.firestore.obfuscated.zzel;
import com.google.firebase.firestore.obfuscated.zzem;
import com.google.firebase.firestore.obfuscated.zzeo;
import com.google.firebase.firestore.obfuscated.zzep;
import com.google.firebase.firestore.obfuscated.zzeq;
import com.google.firebase.firestore.obfuscated.zzes;
import com.google.firebase.firestore.obfuscated.zzet;
import com.google.firebase.firestore.obfuscated.zzev;
import com.google.firebase.firestore.obfuscated.zzew;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzgf;
import com.google.firebase.firestore.obfuscated.zzgo;
import com.google.firebase.firestore.obfuscated.zzh;
import com.google.firebase.firestore.obfuscated.zzha;
import com.google.firebase.firestore.obfuscated.zzhc;
import com.google.firebase.firestore.obfuscated.zzm;
import com.google.firebase.firestore.zze;
import com.google.firebase.firestore.zzf;
import com.google.firebase.firestore.zzg;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

@PublicApi
public class FirebaseFirestore {
    private final Context zza;
    private final zzdi zzb;
    private final String zzc;
    private final zza zzd;
    private final zzgf zze;
    private final FirebaseApp zzf;
    private FirebaseFirestoreSettings zzg;
    private zzm zzh;
    private final FirebaseFirestoreSettings.1 zzi;

    @NonNull
    @PublicApi
    public static FirebaseFirestore getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new IllegalStateException("You must call FirebaseApp.initializeApp first.");
        }
        return FirebaseFirestore.zza(firebaseApp, "(default)");
    }

    @NonNull
    @PublicApi
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp app) {
        return FirebaseFirestore.zza(app, "(default)");
    }

    @NonNull
    private static FirebaseFirestore zza(@NonNull FirebaseApp object, @NonNull String string) {
        Preconditions.checkNotNull((Object)object, (Object)"Provided FirebaseApp must not be null.");
        object = (com.google.firebase.firestore.zzh)object.get(com.google.firebase.firestore.zzh.class);
        Preconditions.checkNotNull((Object)object, (Object)"Firestore component is not present.");
        return ((com.google.firebase.firestore.zzh)object).zza(string);
    }

    @NonNull
    static FirebaseFirestore zza(@NonNull Context context, @NonNull FirebaseApp firebaseApp, @Nullable InternalAuthProvider object, @NonNull String object2) {
        Object object3 = firebaseApp.getOptions().getProjectId();
        if (object3 == null) {
            throw new IllegalArgumentException("FirebaseOptions.getProjectId() cannot be null");
        }
        object2 = zzdi.zza((String)object3, (String)object2);
        object3 = new zzgf();
        if (object == null) {
            zzha.zzb("FirebaseFirestore", "Firebase Auth not available, falling back to unauthenticated usage.", new Object[0]);
            object = new zzb();
        } else {
            object = new zzc((InternalAuthProvider)object);
        }
        ((zzgf)object3).zzb(com.google.firebase.firestore.zze.zza(context));
        String string = firebaseApp.getName();
        return new FirebaseFirestore(context, (zzdi)object2, string, (zza)object, (zzgf)object3, firebaseApp);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    private FirebaseFirestore(Context context, zzdi databaseId, String persistenceKey, zza credentialsProvider, zzgf asyncQueue, @Nullable FirebaseApp firebaseApp) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = (Context)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (zzdi)Preconditions.checkNotNull((Object)((zzdi)Preconditions.checkNotNull((Object)databaseId)));
        this.zzi = new Object((zzdi)var2_2){
            private final zzdi zza;
            {
                this.zza = zzdi2;
            }

            public zzau zza(Map<String, Object> object) {
                zzas zzas2 = new zzas(zzaw.zza);
                object = this.zza(object, zzas2.zzb());
                return zzas2.zzb((zzes)object);
            }

            public zzau zza(Map<String, Object> object, zzdw zzdw2) {
                zzas zzas2 = new zzas(zzaw.zzb);
                object = (zzes)this.zza(object, zzas2.zzb());
                if (zzdw2 != null) {
                    for (zzdp zzdp2 : zzdw2.zza()) {
                        if (zzas2.zza(zzdp2)) continue;
                        throw new IllegalArgumentException("Field '" + zzdp2.toString() + "' is specified in your field mask but not in your input data.");
                    }
                    return zzas2.zza((zzes)object, zzdw2);
                }
                return zzas2.zza((zzes)object);
            }

            public zzav zzb(Map<String, Object> object) {
                Preconditions.checkNotNull((Object)object, (Object)"Provided update data must not be null.");
                zzas zzas2 = new zzas(zzaw.zzc);
                zzat zzat2 = zzas2.zzb();
                zzes zzes2 = zzes.zzb();
                for (Map.Entry<K, V> entry : object.entrySet()) {
                    zzdp zzdp2 = FieldPath.zza((String)entry.getKey()).zza();
                    V v = entry.getValue();
                    if (v instanceof FieldValue.zzc) {
                        zzat2.zzb(zzdp2);
                        continue;
                    }
                    zzem zzem2 = this.zza(v, zzat2.zza(zzdp2));
                    if (zzem2 == null) continue;
                    zzat2.zzb(zzdp2);
                    zzes2 = zzes2.zza(zzdp2, zzem2);
                }
                return zzas2.zzc(zzes2);
            }

            public zzav zza(List<Object> object) {
                zzge.zza(object.size() % 2 == 0, "Expected fieldAndValues to contain an even number of elements", new Object[0]);
                zzas zzas2 = new zzas(zzaw.zzc);
                zzat zzat2 = zzas2.zzb();
                zzes zzes2 = zzes.zzb();
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2 = object.next();
                    Object object3 = object.next();
                    zzge.zza(object2 instanceof String || object2 instanceof FieldPath, "Expected argument to be String or FieldPath.", new Object[0]);
                    object2 = object2 instanceof String ? FieldPath.zza((String)object2).zza() : ((FieldPath)object2).zza();
                    if (object3 instanceof FieldValue.zzc) {
                        zzat2.zzb((zzdp)object2);
                        continue;
                    }
                    if ((object3 = this.zza(object3, zzat2.zza((zzdp)object2))) == null) continue;
                    zzat2.zzb((zzdp)object2);
                    zzes2 = zzes2.zza((zzdp)object2, (zzem)object3);
                }
                return zzas2.zzc(zzes2);
            }

            public zzem zza(Object object) {
                zzas zzas2 = new zzas(zzaw.zzd);
                zzge.zza((object = this.zza(object, zzas2.zzb())) != null, "Parsed data should not be null.", new Object[0]);
                zzge.zza(zzas2.zza().isEmpty(), "Field transforms should have been disallowed.", new Object[0]);
                return object;
            }

            public static Map<String, Object> zzb(Object object) {
                Preconditions.checkNotNull((Object)object, (Object)"Provided data must not be null.");
                String string = "Invalid data. Data must be a Map<String, Object> or a suitable POJO object, but it was ";
                if (object.getClass().isArray()) {
                    throw new IllegalArgumentException(string + "an array");
                }
                Object object2 = zzgo.zza(object);
                if (!(object2 instanceof Map)) {
                    throw new IllegalArgumentException(string + "of type: " + zzhc.zza(object));
                }
                object = (Map)object2;
                return object;
            }

            /*
             * Enabled aggressive block sorting
             */
            @javax.annotation.Nullable
            private zzem zza(Object object, zzat object2) {
                HashMap<String, zzem> hashMap;
                Object object3;
                if (object instanceof Map) {
                    object3 = object2;
                    object2 = (Map)object;
                    object = this;
                    hashMap = new HashMap<String, zzem>();
                    if (object2.isEmpty()) {
                        if (((zzat)object3).zzc() == null) return zzes.zzb();
                        if (((zzat)object3).zzc().zze()) return zzes.zzb();
                        ((zzat)object3).zzb(((zzat)object3).zzc());
                        return zzes.zzb();
                    }
                } else {
                    if (object instanceof FieldValue) {
                        Object object4 = object2;
                        object2 = (FieldValue)object;
                        object = this;
                        if (!((zzat)object4).zzd()) {
                            throw ((zzat)object4).zzb(String.format("%s() can only be used with set() and update()", ((FieldValue)object2).zza()));
                        }
                        if (((zzat)object4).zzc() == null) {
                            throw ((zzat)object4).zzb(String.format("%s() is not currently supported inside arrays", ((FieldValue)object2).zza()));
                        }
                        if (object2 instanceof FieldValue.zzc) {
                            if (((zzat)object4).zzb() == zzaw.zzb) {
                                ((zzat)object4).zzb(((zzat)object4).zzc());
                                return null;
                            }
                            if (((zzat)object4).zzb() != zzaw.zzc) throw ((zzat)object4).zzb("FieldValue.delete() can only be used with update() and set() with SetOptions.merge()");
                            zzge.zza(((zzat)object4).zzc().zzg() > 0, "FieldValue.delete() at the top level should have already been handled.", new Object[0]);
                            throw ((zzat)object4).zzb("FieldValue.delete() can only appear at the top level of your update data");
                        }
                        if (object2 instanceof FieldValue.zzd) {
                            ((zzat)object4).zza(((zzat)object4).zzc(), zzee.zza());
                            return null;
                        }
                        if (object2 instanceof FieldValue.zzb) {
                            List<zzem> list = super.zzb(((FieldValue.zzb)object2).zzb());
                            zzdu.zzb zzb2 = new zzdu.zzb(list);
                            ((zzat)object4).zza(((zzat)object4).zzc(), zzb2);
                            return null;
                        }
                        if (object2 instanceof FieldValue.zza) {
                            List<zzem> list = super.zzb(((FieldValue.zza)object2).zzb());
                            zzdu.zza zza2 = new zzdu.zza(list);
                            ((zzat)object4).zza(((zzat)object4).zzc(), zza2);
                            return null;
                        }
                        throw zzge.zza("Unknown FieldValue type: %s", zzhc.zza(object2));
                    }
                    if (((zzat)object2).zzc() != null) {
                        ((zzat)object2).zzb(((zzat)object2).zzc());
                    }
                    if (object instanceof List) {
                        if (!((zzat)object2).zza()) return this.zza((List)object, (zzat)object2);
                        throw ((zzat)object2).zzb("Nested arrays are not supported");
                    }
                    Object object5 = object2;
                    object2 = object;
                    object = this;
                    if (object2 == null) {
                        return zzeq.zzb();
                    }
                    if (object2 instanceof Integer) {
                        return zzep.zza(((Integer)object2).longValue());
                    }
                    if (object2 instanceof Long) {
                        return zzep.zza((Long)object2);
                    }
                    if (object2 instanceof Float) {
                        return zzel.zza(((Float)object2).doubleValue());
                    }
                    if (object2 instanceof Double) {
                        return zzel.zza((Double)object2);
                    }
                    if (object2 instanceof Boolean) {
                        return zzek.zza((Boolean)object2);
                    }
                    if (object2 instanceof String) {
                        return zzev.zza((String)object2);
                    }
                    if (object2 instanceof Date) {
                        return zzew.zza(new Timestamp((Date)object2));
                    }
                    if (object2 instanceof Timestamp) {
                        Timestamp timestamp = (Timestamp)object2;
                        long l = timestamp.getSeconds();
                        int n = timestamp.getNanoseconds() / 1000 * 1000;
                        return zzew.zza(new Timestamp(l, n));
                    }
                    if (object2 instanceof GeoPoint) {
                        return zzeo.zza((GeoPoint)object2);
                    }
                    if (object2 instanceof Blob) {
                        return zzej.zza((Blob)object2);
                    }
                    if (object2 instanceof DocumentReference) {
                        DocumentReference documentReference = (DocumentReference)object2;
                        if (documentReference.getFirestore() == null) return zzet.zza(object.zza, documentReference.zza());
                        zzdi zzdi2 = documentReference.getFirestore().zzb();
                        if (zzdi2.equals(object.zza)) return zzet.zza(object.zza, documentReference.zza());
                        throw ((zzat)object5).zzb(String.format("Document reference is for database %s/%s but should be for database %s/%s", zzdi2.zza(), zzdi2.zzb(), object.zza.zza(), object.zza.zzb()));
                    }
                    if (!object2.getClass().isArray()) throw ((zzat)object5).zzb("Unsupported type: " + zzhc.zza(object2));
                    throw ((zzat)object5).zzb("Arrays are not supported; use a List instead");
                }
                Iterator<Map.Entry<K, V>> iterator = object2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry = iterator.next();
                    if (!(entry.getKey() instanceof String)) {
                        throw ((zzat)object3).zzb(String.format("Non-String Map key (%s) is not allowed", entry.getValue()));
                    }
                    object2 = (String)entry.getKey();
                    zzem zzem2 = super.zza(entry.getValue(), ((zzat)object3).zza((String)object2));
                    if (zzem2 == null) continue;
                    hashMap.put((String)object2, zzem2);
                }
                return zzes.zza(hashMap);
            }

            private <T> zzei zza(List<T> object, zzat zzat2) {
                ArrayList<zzem> arrayList = new ArrayList<zzem>(object.size());
                object = object.iterator();
                while (object.hasNext()) {
                    Object object2 = object.next();
                    if ((object2 = this.zza(object2, zzat2.zze())) == null) {
                        object2 = zzeq.zzb();
                    }
                    arrayList.add((zzem)object2);
                }
                return zzei.zza(arrayList);
            }

            private List<zzem> zzb(List<Object> list) {
                zzas zzas2 = new zzas(zzaw.zzd);
                ArrayList<zzem> arrayList = new ArrayList<zzem>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Object object = list.get(i);
                    zzat zzat2 = zzas2.zzb();
                    arrayList.add(this.zza(object, zzat2.zze()));
                }
                return arrayList;
            }
        };
        this.zzc = (String)Preconditions.checkNotNull((Object)var3_3);
        this.zzd = (zza)Preconditions.checkNotNull((Object)credentialsProvider);
        this.zze = (zzgf)Preconditions.checkNotNull((Object)asyncQueue);
        this.zzf = firebaseApp;
        this.zzg = new FirebaseFirestoreSettings.Builder().build();
    }

    @NonNull
    @PublicApi
    public FirebaseFirestoreSettings getFirestoreSettings() {
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     */
    @PublicApi
    public void setFirestoreSettings(@NonNull FirebaseFirestoreSettings settings) {
        void var1_1;
        Preconditions.checkNotNull((Object)settings, (Object)"Provided settings must not be null.");
        if (this.zzh != null && !this.zzg.equals(settings)) {
            throw new IllegalStateException("FirebaseFirestore has already been started and its settings can no longer be changed. You can only call setFirestoreSettings() before calling any other methods on a FirebaseFirestore object.");
        }
        this.zzg = var1_1;
    }

    private void zzd() {
        if (this.zzh == null) {
            if (!this.zzg.areTimestampsInSnapshotsEnabled()) {
                zzha.zza("Firestore", "The behavior for java.util.Date objects stored in Firestore is going to change AND YOUR APP MAY BREAK.\nTo hide this warning and ensure your app does not break, you need to add the following code to your app before calling any other Cloud Firestore methods:\n\nFirebaseFirestore firestore = FirebaseFirestore.getInstance();\nFirebaseFirestoreSettings settings = new FirebaseFirestoreSettings.Builder()\n    .setTimestampsInSnapshotsEnabled(true)\n    .build();\nfirestore.setFirestoreSettings(settings);\n\nWith this change, timestamps stored in Cloud Firestore will be read back as com.google.firebase.Timestamp objects instead of as system java.util.Date objects. So you will also need to update code expecting a java.util.Date to instead expect a Timestamp. For example:\n\n// Old:\njava.util.Date date = snapshot.getDate(\"created_at\");\n// New:\nTimestamp timestamp = snapshot.getTimestamp(\"created_at\");\njava.util.Date date = timestamp.toDate();\n\nPlease audit all existing usages of java.util.Date when you enable the new behavior. In a future release, the behavior will be changed to the new behavior, so if you do not follow these steps, YOUR APP MAY BREAK.", new Object[0]);
            }
            zzh zzh2 = new zzh(this.zzb, this.zzc, this.zzg.getHost(), this.zzg.isSslEnabled());
            this.zzh = new zzm(this.zza, zzh2, this.zzg.isPersistenceEnabled(), this.zzd, this.zze);
        }
    }

    @NonNull
    @PublicApi
    public FirebaseApp getApp() {
        return this.zzf;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public CollectionReference collection(@NonNull String collectionPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)collectionPath, (Object)"Provided collection path must not be null.");
        this.zzd();
        return new CollectionReference(zzds.zzb((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public DocumentReference document(@NonNull String documentPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)documentPath, (Object)"Provided document path must not be null.");
        this.zzd();
        return DocumentReference.zza(zzds.zzb((String)var1_1), this);
    }

    @NonNull
    @PublicApi
    public <TResult> Task<TResult> runTransaction(@NonNull Transaction.Function<TResult> updateFunction) {
        FirebaseFirestore firebaseFirestore;
        Preconditions.checkNotNull(updateFunction, (Object)"Provided transaction update function must not be null.");
        Executor executor = zzao.zzb();
        Function function = firebaseFirestore;
        firebaseFirestore = this;
        firebaseFirestore.zzd();
        function = com.google.firebase.firestore.zzf.zza(firebaseFirestore, executor, (Transaction.Function)function);
        return firebaseFirestore.zzh.zza(function, 5);
    }

    @NonNull
    @PublicApi
    public WriteBatch batch() {
        this.zzd();
        return new WriteBatch(this);
    }

    @PublicApi
    public Task<Void> enableNetwork() {
        this.zzd();
        return this.zzh.zzb();
    }

    @PublicApi
    public Task<Void> disableNetwork() {
        this.zzd();
        return this.zzh.zza();
    }

    @PublicApi
    public static void setLoggingEnabled(boolean loggingEnabled) {
        if (loggingEnabled) {
            zzha.zza(zzha.zza.zza);
            return;
        }
        zzha.zza(zzha.zza.zzb);
    }

    final zzm zza() {
        return this.zzh;
    }

    final zzdi zzb() {
        return this.zzb;
    }

    final FirebaseFirestoreSettings.1 zzc() {
        return this.zzi;
    }

    final void zza(DocumentReference documentReference) {
        Preconditions.checkNotNull((Object)documentReference, (Object)"Provided DocumentReference must not be null.");
        if (documentReference.getFirestore() != this) {
            throw new IllegalArgumentException("Provided document reference is from a different Firestore instance.");
        }
    }

    static /* synthetic */ Task zza(FirebaseFirestore firebaseFirestore, Executor executor, Transaction.Function function, zzao zzao2) {
        return Tasks.call((Executor)executor, (Callable)com.google.firebase.firestore.zzg.zza(firebaseFirestore, function, zzao2));
    }

    static /* synthetic */ Object zza(FirebaseFirestore firebaseFirestore, Transaction.Function function, zzao zzao2) throws Exception {
        return function.apply(new Transaction(zzao2, firebaseFirestore));
    }

    static /* synthetic */ void zza(Context context) {
        try {
            ProviderInstaller.installIfNeeded((Context)context);
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException throwable) {
            zzha.zza("Firestore", "Failed to update ssl context", new Object[0]);
            return;
        }
    }
}

