/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.DocumentChange;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.QueryDocumentSnapshot;
import com.google.firebase.firestore.SnapshotMetadata;
import com.google.firebase.firestore.obfuscated.zzba;
import com.google.firebase.firestore.obfuscated.zzdj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

@PublicApi
public class QuerySnapshot
implements Iterable<QueryDocumentSnapshot> {
    private final Query zza;
    private final zzba zzb;
    private final FirebaseFirestore zzc;
    private List<DocumentChange> zzd;
    private MetadataChanges zze;
    private final SnapshotMetadata zzf;

    /*
     * WARNING - void declaration
     */
    QuerySnapshot(Query originalQuery, zzba snapshot, FirebaseFirestore firestore) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.zza = (Query)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (zzba)Preconditions.checkNotNull((Object)snapshot);
        this.zzc = (FirebaseFirestore)Preconditions.checkNotNull((Object)var3_3);
        this.zzf = new SnapshotMetadata(snapshot.zzf(), var2_2.zze());
    }

    @NonNull
    @PublicApi
    public Query getQuery() {
        return this.zza;
    }

    @NonNull
    @PublicApi
    public SnapshotMetadata getMetadata() {
        return this.zzf;
    }

    @NonNull
    @PublicApi
    public List<DocumentChange> getDocumentChanges() {
        return this.getDocumentChanges(MetadataChanges.EXCLUDE);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public List<DocumentChange> getDocumentChanges(MetadataChanges metadataChanges) {
        if (this.zzd == null || this.zze != metadataChanges) {
            void var1_1;
            this.zzd = Collections.unmodifiableList(DocumentChange.zza(this.zzc, metadataChanges, this.zzb));
            this.zze = var1_1;
        }
        return this.zzd;
    }

    @NonNull
    @PublicApi
    public List<DocumentSnapshot> getDocuments() {
        ArrayList<DocumentSnapshot> arrayList = new ArrayList<DocumentSnapshot>(this.zzb.zzb().zza());
        for (zzdj zzdj2 : this.zzb.zzb()) {
            arrayList.add(this.zza(zzdj2));
        }
        return arrayList;
    }

    @PublicApi
    public boolean isEmpty() {
        return this.zzb.zzb().zzb();
    }

    @PublicApi
    public int size() {
        return this.zzb.zzb().zza();
    }

    @Override
    @NonNull
    @PublicApi
    public Iterator<QueryDocumentSnapshot> iterator() {
        return new zza(this, this.zzb.zzb().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public <T> List<T> toObjects(@NonNull Class<T> clazz) {
        void var1_1;
        return this.toObjects((Class<T>)var1_1, DocumentSnapshot.ServerTimestampBehavior.zza);
    }

    @NonNull
    @PublicApi
    public <T> List<T> toObjects(@NonNull Class<T> clazz, @NonNull DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior) {
        Preconditions.checkNotNull(clazz, (Object)"Provided POJO type must not be null.");
        ArrayList<T> arrayList = new ArrayList<T>();
        for (DocumentSnapshot documentSnapshot : this) {
            arrayList.add(documentSnapshot.toObject(clazz, serverTimestampBehavior));
        }
        return arrayList;
    }

    private QueryDocumentSnapshot zza(zzdj zzdj2) {
        return QueryDocumentSnapshot.zzb(this.zzc, zzdj2, this.zzb.zze());
    }

    public boolean equals(@Nullable Object obj) {
        QuerySnapshot querySnapshot;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuerySnapshot)) {
            return false;
        }
        querySnapshot = querySnapshot;
        return this.zzc.equals(querySnapshot.zzc) && this.zza.equals(querySnapshot.zza) && this.zzb.equals(querySnapshot.zzb) && this.zzf.equals(querySnapshot.zzf);
    }

    public int hashCode() {
        int n = this.zzc.hashCode();
        n = n * 31 + this.zza.hashCode();
        n = n * 31 + this.zzb.hashCode();
        n = n * 31 + this.zzf.hashCode();
        return n;
    }

    final class zza
    implements Iterator<QueryDocumentSnapshot> {
        private final Iterator<zzdj> zza;
        private /* synthetic */ QuerySnapshot zzb;

        zza(QuerySnapshot querySnapshot, Iterator<zzdj> iterator) {
            this.zzb = querySnapshot;
            this.zza = iterator;
        }

        @Override
        public final boolean hasNext() {
            return this.zza.hasNext();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("QuerySnapshot does not support remove().");
        }

        @Override
        public final /* synthetic */ Object next() {
            zza zza2 = this;
            return zza2.zzb.zza(zza2.zza.next());
        }
    }
}

