/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.obfuscated.zzao;
import com.google.firebase.firestore.obfuscated.zzau;
import com.google.firebase.firestore.obfuscated.zzav;
import com.google.firebase.firestore.obfuscated.zzdj;
import com.google.firebase.firestore.obfuscated.zzdq;
import com.google.firebase.firestore.obfuscated.zzdr;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzgr;
import com.google.firebase.firestore.obfuscated.zzhc;
import com.google.firebase.firestore.zzm;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

@PublicApi
public class Transaction {
    private final zzao zza;
    private final FirebaseFirestore zzb;

    /*
     * WARNING - void declaration
     */
    Transaction(zzao transaction, FirebaseFirestore firestore) {
        void var2_2;
        void var1_1;
        this.zza = (zzao)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (FirebaseFirestore)Preconditions.checkNotNull((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        void var2_2;
        void var1_1;
        return this.set((DocumentReference)var1_1, (Map<String, Object>)var2_2, SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data, @NonNull SetOptions options) {
        void var1_1;
        zzau zzau2;
        void var3_3;
        this.zzb.zza(documentRef);
        Preconditions.checkNotNull(data, (Object)"Provided data must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"Provided options must not be null.");
        zzau2 = options.zza() ? this.zzb.zzc().zza(data, var3_3.zzb()) : this.zzb.zzc().zza((Map<String, Object>)((Object)zzau2));
        this.zza.zza(var1_1.zza(), zzau2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Object pojo) {
        void var2_2;
        void var1_1;
        return this.set((DocumentReference)var1_1, FirebaseFirestoreSettings.1.zzb(var2_2), SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Object pojo, @NonNull SetOptions options) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.set((DocumentReference)var1_1, FirebaseFirestoreSettings.1.zzb(var2_2), (SetOptions)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        void var1_1;
        zzav zzav2;
        zzav2 = this.zzb.zzc().zzb((Map<String, Object>)((Object)zzav2));
        return this.zza((DocumentReference)var1_1, zzav2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var1_1;
        void var3_3;
        zzav zzav2;
        zzav2 = this.zzb.zzc().zza(zzhc.zza(1, zzav2, var3_3, moreFieldsAndValues));
        return this.zza((DocumentReference)var1_1, zzav2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var1_1;
        void var3_3;
        zzav zzav2;
        zzav2 = this.zzb.zzc().zza(zzhc.zza(1, zzav2, var3_3, moreFieldsAndValues));
        return this.zza((DocumentReference)var1_1, zzav2);
    }

    private Transaction zza(@NonNull DocumentReference documentReference, @NonNull zzav zzav2) {
        this.zzb.zza(documentReference);
        this.zza.zza(documentReference.zza(), zzav2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Transaction delete(@NonNull DocumentReference documentRef) {
        void var1_1;
        this.zzb.zza(documentRef);
        this.zza.zza(var1_1.zza());
        return this;
    }

    @NonNull
    @PublicApi
    public DocumentSnapshot get(@NonNull DocumentReference documentRef) throws FirebaseFirestoreException {
        Object object;
        this.zzb.zza(documentRef);
        try {
            void var2_3 = object;
            object = this;
            return (DocumentSnapshot)Tasks.await((Task)((Transaction)object).zza.zza(Collections.singletonList(var2_3.zza())).continueWith(zzgr.zzb, zzm.zza((Transaction)object)));
        }
        catch (ExecutionException executionException) {
            object = executionException;
            if (executionException.getCause() instanceof FirebaseFirestoreException) {
                throw (FirebaseFirestoreException)((Object)((Throwable)object).getCause());
            }
            throw new RuntimeException(((Throwable)object).getCause());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    static /* synthetic */ DocumentSnapshot zza(Transaction transaction, Task object) throws Exception {
        if (!object.isSuccessful()) {
            throw object.getException();
        }
        if ((object = (List)object.getResult()).size() != 1) {
            throw zzge.zza("Mismatch in docs returned from document lookup.", new Object[0]);
        }
        if ((object = (zzdq)object.get(0)) instanceof zzdr) {
            return DocumentSnapshot.zza(transaction.zzb, ((zzdq)object).zzd(), false);
        }
        return DocumentSnapshot.zza(transaction.zzb, (zzdj)object, false);
    }

    @PublicApi
    public static interface Function<TResult> {
        @Nullable
        @PublicApi
        public TResult apply(@NonNull Transaction var1) throws FirebaseFirestoreException;
    }
}

