/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.obfuscated;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;
import com.google.common.base.Preconditions;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.obfuscated.zzag;
import com.google.firebase.firestore.obfuscated.zzbe;
import com.google.firebase.firestore.obfuscated.zzbf;
import com.google.firebase.firestore.obfuscated.zzbz;
import com.google.firebase.firestore.obfuscated.zzck;
import com.google.firebase.firestore.obfuscated.zzcl;
import com.google.firebase.firestore.obfuscated.zzcm;
import com.google.firebase.firestore.obfuscated.zzcn;
import com.google.firebase.firestore.obfuscated.zzco;
import com.google.firebase.firestore.obfuscated.zzcp;
import com.google.firebase.firestore.obfuscated.zzcq;
import com.google.firebase.firestore.obfuscated.zzcr;
import com.google.firebase.firestore.obfuscated.zzcs;
import com.google.firebase.firestore.obfuscated.zzct;
import com.google.firebase.firestore.obfuscated.zzcu;
import com.google.firebase.firestore.obfuscated.zzcv;
import com.google.firebase.firestore.obfuscated.zzcw;
import com.google.firebase.firestore.obfuscated.zzdh;
import com.google.firebase.firestore.obfuscated.zzdl;
import com.google.firebase.firestore.obfuscated.zzds;
import com.google.firebase.firestore.obfuscated.zzdy;
import com.google.firebase.firestore.obfuscated.zzdz;
import com.google.firebase.firestore.obfuscated.zzf;
import com.google.firebase.firestore.obfuscated.zzfb;
import com.google.firebase.firestore.obfuscated.zzgd;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

final class zzcj
implements zzbz {
    private final zzcw zza;
    private final zzbf zzb;
    private final String zzc;
    private int zzd;
    private int zze;
    private ByteString zzf;

    zzcj(zzcw zzcw2, zzbf zzbf2, zzf zzf2) {
        this.zza = zzcw2;
        this.zzb = zzbf2;
        this.zzc = zzf2.zzb() ? zzf2.zza() : "";
        this.zzf = zzgd.zzc;
    }

    @Override
    public final void zza() {
        zzcj zzcj2 = this;
        Object object = new ArrayList();
        zzcj2.zza.zzb("SELECT uid FROM mutation_queues").zza(zzco.zza(object));
        zzcj2.zzd = 0;
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            zzcj2.zza.zzb("SELECT MAX(batch_id) FROM mutations WHERE uid = ?").zza(string).zza(zzcp.zza(zzcj2));
        }
        ++zzcj2.zzd;
        this.zze = -1;
        int n = this.zza.zzb("SELECT last_acknowledged_batch_id, last_stream_token FROM mutation_queues WHERE uid = ?").zza(this.zzc).zzb(zzck.zza(this));
        if (n == 0) {
            this.zzg();
            return;
        }
        if (this.zze >= this.zzd) {
            zzge.zza(this.zzf(), "Reset nextBatchId is only possible when the queue is empty", new Object[0]);
            this.zze = -1;
            this.zzg();
        }
    }

    private boolean zzf() {
        return this.zza.zzb("SELECT batch_id FROM mutations WHERE uid = ? LIMIT 1").zza(this.zzc).zza();
    }

    @Override
    public final int zzb() {
        return this.zze;
    }

    @Override
    public final void zza(zzdz zzdz2, ByteString byteString) {
        int n = zzdz2.zzb();
        zzge.zza(n > this.zze, "Mutation batchIds must be acknowledged in order", new Object[0]);
        this.zze = n;
        this.zzf = (ByteString)Preconditions.checkNotNull((Object)byteString);
        this.zzg();
    }

    @Override
    public final ByteString zzc() {
        return this.zzf;
    }

    @Override
    public final void zza(ByteString byteString) {
        this.zzf = (ByteString)Preconditions.checkNotNull((Object)byteString);
        this.zzg();
    }

    private void zzg() {
        this.zza.zza("INSERT OR REPLACE INTO mutation_queues (uid, last_acknowledged_batch_id, last_stream_token) VALUES (?, ?, ?)", this.zzc, this.zze, this.zzf.toByteArray());
    }

    @Override
    public final zzdz zza(Timestamp object, List<zzdy> object2) {
        int n = this.zzd++;
        object = new zzdz(n, (Timestamp)object, (List<zzdy>)object2);
        Object object3 = this.zzb.zza((zzdz)object);
        this.zza.zza("INSERT INTO mutations (uid, batch_id, mutations) VALUES (?, ?, ?)", this.zzc, n, object3.toByteArray());
        object3 = new HashSet();
        SQLiteStatement sQLiteStatement = this.zza.zza("INSERT INTO document_mutations (uid, path, batch_id) VALUES (?, ?, ?)");
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object4 = (zzdy)object2.next();
            if (!object3.add(object4 = ((zzdy)object4).zza())) continue;
            object4 = zzbe.zza(((zzdl)object4).zzd());
            this.zza.zza(sQLiteStatement, this.zzc, object4, n);
        }
        return object;
    }

    @Override
    @Nullable
    public final zzdz zza(int n) {
        return (zzdz)this.zza.zzb("SELECT mutations FROM mutations WHERE uid = ? AND batch_id = ?").zza(this.zzc, n).zza(zzcq.zza(this));
    }

    @Override
    @Nullable
    public final zzdz zzb(int n) {
        n = Math.max(n, this.zze) + 1;
        return (zzdz)this.zza.zzb("SELECT mutations FROM mutations WHERE uid = ? AND batch_id >= ? ORDER BY batch_id ASC LIMIT 1").zza(this.zzc, n).zza(zzcr.zza(this));
    }

    @Override
    public final List<zzdz> zzd() {
        ArrayList<zzdz> arrayList = new ArrayList<zzdz>();
        this.zza.zzb("SELECT mutations FROM mutations WHERE uid = ? ORDER BY batch_id ASC").zza(this.zzc).zza(zzcs.zza(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzdz> zzc(int n) {
        ArrayList<zzdz> arrayList = new ArrayList<zzdz>();
        this.zza.zzb("SELECT mutations FROM mutations WHERE uid = ? AND batch_id <= ? ORDER BY batch_id ASC").zza(this.zzc, n).zza(zzct.zza(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzdz> zza(zzdl object) {
        object = zzbe.zza(((zzdl)object).zzd());
        ArrayList<zzdz> arrayList = new ArrayList<zzdz>();
        this.zza.zzb("SELECT m.mutations FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path = ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id ORDER BY dm.batch_id").zza(this.zzc, object).zza(zzcu.zza(this, arrayList));
        return arrayList;
    }

    @Override
    public final List<zzdz> zza(Iterable<zzdl> object) {
        ArrayList<zzdz> arrayList = new ArrayList<zzdz>();
        if (!object.iterator().hasNext()) {
            return arrayList;
        }
        object = object.iterator();
        HashSet hashSet = new HashSet();
        int n = 0;
        while (object.hasNext()) {
            ++n;
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(this.zzc);
            for (int i = 0; object.hasNext() && i < 900; ++i) {
                zzdl zzdl2 = (zzdl)object.next();
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("?");
                arrayList2.add(zzbe.zza(zzdl2.zzd()));
            }
            String string = stringBuilder.toString();
            this.zza.zzb("SELECT DISTINCT dm.batch_id, m.mutations FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path IN (" + string + ") AND dm.uid = m.uid AND dm.batch_id = m.batch_id ORDER BY dm.batch_id").zza(arrayList2.toArray()).zza(zzcv.zza(this, hashSet, arrayList));
        }
        if (n > 1) {
            Collections.sort(arrayList, zzcl.zza());
        }
        return arrayList;
    }

    @Override
    public final List<zzdz> zza(zzag object) {
        object = ((zzag)object).zza();
        int n = ((zzdh)object).zzg() + 1;
        object = zzbe.zza(object);
        String string = zzbe.zzb((String)object);
        ArrayList<zzdz> arrayList = new ArrayList<zzdz>();
        this.zza.zzb("SELECT dm.batch_id, dm.path, m.mutations FROM document_mutations dm, mutations m WHERE dm.uid = ? AND dm.path >= ? AND dm.path < ? AND dm.uid = m.uid AND dm.batch_id = m.batch_id ORDER BY dm.batch_id").zza(this.zzc, object, string).zza(zzcm.zza(this, arrayList, n));
        return arrayList;
    }

    @Override
    public final void zza(List<zzdz> object) {
        SQLiteStatement sQLiteStatement = this.zza.zza("DELETE FROM mutations WHERE uid = ? AND batch_id = ?");
        SQLiteStatement sQLiteStatement2 = this.zza.zza("DELETE FROM document_mutations WHERE uid = ? AND path = ? AND batch_id = ?");
        object = object.iterator();
        while (object.hasNext()) {
            zzdz zzdz2 = (zzdz)object.next();
            int n = zzdz2.zzb();
            int n2 = this.zza.zza(sQLiteStatement, this.zzc, n);
            zzge.zza(n2 != 0, "Mutation batch (%s, %d) did not exist", this.zzc, zzdz2.zzb());
            for (zzdy object2 : zzdz2.zzf()) {
                zzdl zzdl2 = object2.zza();
                String string = zzbe.zza(zzdl2.zzd());
                this.zza.zza(sQLiteStatement2, this.zzc, string, n);
            }
        }
    }

    @Override
    public final void zze() {
        if (!this.zzf()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.zza.zzb("SELECT path FROM document_mutations WHERE uid = ?").zza(this.zzc).zza(zzcn.zza(arrayList));
        zzge.zza(arrayList.isEmpty(), "Document leak -- detected dangling mutation references when queue is empty. Dangling keys: %s", arrayList);
    }

    private zzdz zza(byte[] byArray) {
        try {
            return this.zzb.zza(zzfb.zza(byArray));
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw zzge.zza("MutationBatch failed to parse: %s", new Object[]{invalidProtocolBufferException});
        }
    }

    static /* synthetic */ void zza(zzcj zzcj2, List list, int n, Cursor cursor) {
        int n2 = cursor.getInt(0);
        int n3 = list.size();
        if (n3 > 0 && n2 == ((zzdz)list.get(n3 - 1)).zzb()) {
            return;
        }
        zzds zzds2 = zzbe.zza(cursor.getString(1));
        if (zzds2.zzg() != n) {
            return;
        }
        list.add(zzcj2.zza(cursor.getBlob(2)));
    }

    static /* synthetic */ void zza(zzcj zzcj2, Set set, List list, Cursor cursor) {
        int n = cursor.getInt(0);
        if (!set.contains(n)) {
            set.add(n);
            list.add(zzcj2.zza(cursor.getBlob(1)));
        }
    }

    static /* synthetic */ void zza(zzcj zzcj2, List list, Cursor cursor) {
        list.add(zzcj2.zza(cursor.getBlob(0)));
    }

    static /* synthetic */ void zzb(zzcj zzcj2, List list, Cursor cursor) {
        list.add(zzcj2.zza(cursor.getBlob(0)));
    }

    static /* synthetic */ void zzc(zzcj zzcj2, List list, Cursor cursor) {
        list.add(zzcj2.zza(cursor.getBlob(0)));
    }

    static /* synthetic */ zzdz zza(zzcj zzcj2, Cursor cursor) {
        return zzcj2.zza(cursor.getBlob(0));
    }

    static /* synthetic */ zzdz zzb(zzcj zzcj2, Cursor cursor) {
        return zzcj2.zza(cursor.getBlob(0));
    }

    static /* synthetic */ void zzc(zzcj zzcj2, Cursor cursor) {
        zzcj2.zzd = Math.max(zzcj2.zzd, cursor.getInt(0));
    }

    static /* synthetic */ void zzd(zzcj zzcj2, Cursor cursor) {
        zzcj2.zze = cursor.getInt(0);
        zzcj2.zzf = ByteString.copyFrom((byte[])cursor.getBlob(1));
    }
}

