/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.obfuscated;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.support.annotation.VisibleForTesting;
import com.google.common.base.Function;
import com.google.firebase.firestore.obfuscated.zzbf;
import com.google.firebase.firestore.obfuscated.zzbz;
import com.google.firebase.firestore.obfuscated.zzca;
import com.google.firebase.firestore.obfuscated.zzcf;
import com.google.firebase.firestore.obfuscated.zzch;
import com.google.firebase.firestore.obfuscated.zzci;
import com.google.firebase.firestore.obfuscated.zzcj;
import com.google.firebase.firestore.obfuscated.zzcx;
import com.google.firebase.firestore.obfuscated.zzcy;
import com.google.firebase.firestore.obfuscated.zzdc;
import com.google.firebase.firestore.obfuscated.zzdf;
import com.google.firebase.firestore.obfuscated.zzdi;
import com.google.firebase.firestore.obfuscated.zzf;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzgn;
import com.google.firebase.firestore.obfuscated.zzha;
import com.google.firebase.firestore.obfuscated.zzhb;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nullable;

public final class zzcw
extends zzca {
    private final zza zzc;
    private final zzbf zzd;
    private SQLiteDatabase zze;
    private boolean zzf;
    private final zzcy zzg;
    private final zzdc zzh;
    private final zzci zzi;

    @VisibleForTesting
    private static String zza(String string, zzdi zzdi2) {
        try {
            return "firestore." + URLEncoder.encode(string, "utf-8") + "." + URLEncoder.encode(zzdi2.zza(), "utf-8") + "." + URLEncoder.encode(zzdi2.zzb(), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public zzcw(Context context, String string, zzdi zzdi2, zzbf zzbf2) {
        string = zzcw.zza(string, zzdi2);
        this.zzc = new zza(context, string);
        this.zzd = zzbf2;
        this.zzg = new zzcy(this, this.zzd);
        this.zzh = new zzdc(this, this.zzd);
        this.zzi = new zzci(this);
    }

    @Override
    public final void zzb() {
        zzge.zza(!this.zzf, "SQLitePersistence double-started!", new Object[0]);
        this.zzf = true;
        try {
            this.zze = this.zzc.getWritableDatabase();
        }
        catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
            throw new RuntimeException("Failed to gain exclusive lock to the Firestore client's offline persistence. This generally means you are using Firestore from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing Firestore in your Application class. If you are intentionally using Firestore from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.", sQLiteDatabaseLockedException);
        }
        this.zzg.zzc();
        this.zzi.zza(this.zzg.zzd());
    }

    @Override
    public final boolean zzc() {
        return this.zzf;
    }

    @Override
    public final zzcf zzd() {
        return this.zzi;
    }

    @Override
    final zzbz zza(zzf zzf2) {
        return new zzcj(this, this.zzd, zzf2);
    }

    final zzcy zza() {
        return this.zzg;
    }

    @Override
    final zzch zzh() {
        return this.zzh;
    }

    @Override
    final void zza(String string, Runnable runnable) {
        try {
            zzha.zzb(zza, "Starting transaction: %s", string);
            this.zzi.zzb();
            this.zze.beginTransaction();
            runnable.run();
            this.zze.setTransactionSuccessful();
            return;
        }
        finally {
            this.zze.endTransaction();
            this.zzi.zzc();
        }
    }

    @Override
    final <T> T zza(String string, zzhb<T> zzhb2) {
        try {
            zzha.zzb(zza, "Starting transaction: %s", string);
            this.zzi.zzb();
            this.zze.beginTransaction();
            string = zzhb2.zza();
            this.zze.setTransactionSuccessful();
            return (T)string;
        }
        finally {
            this.zze.endTransaction();
            this.zzi.zzc();
        }
    }

    final void zza(String string, Object ... objectArray) {
        this.zze.execSQL(string, objectArray);
    }

    final SQLiteStatement zza(String string) {
        return this.zze.compileStatement(string);
    }

    final int zza(SQLiteStatement sQLiteStatement, Object ... objectArray) {
        sQLiteStatement.clearBindings();
        zzcw.zza((SQLiteProgram)sQLiteStatement, objectArray);
        return sQLiteStatement.executeUpdateDelete();
    }

    final zzb zzb(String string) {
        return new zzb(string, 0);
    }

    private static void zza(SQLiteProgram sQLiteProgram, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                sQLiteProgram.bindNull(i + 1);
                continue;
            }
            if (object instanceof String) {
                sQLiteProgram.bindString(i + 1, (String)object);
                continue;
            }
            if (object instanceof Integer) {
                sQLiteProgram.bindLong(i + 1, (long)((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                sQLiteProgram.bindLong(i + 1, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                sQLiteProgram.bindDouble(i + 1, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof byte[]) {
                sQLiteProgram.bindBlob(i + 1, (byte[])object);
                continue;
            }
            throw zzge.zza("Unknown argument %s of type %s", object, object.getClass());
        }
    }

    static /* synthetic */ void zza(zzcw zzcw2, SQLiteProgram sQLiteProgram, Object[] objectArray) {
        zzcw.zza(sQLiteProgram, objectArray);
    }

    final class zzb {
        private final String zzb;
        private SQLiteDatabase.CursorFactory zzc;

        private zzb(String string) {
            this.zzb = string;
        }

        final zzb zza(Object ... objectArray) {
            this.zzc = zzcx.zza(this, objectArray);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void zza(zzgn<Cursor> zzgn2) {
            Cursor cursor = null;
            try {
                cursor = this.zzb();
                while (cursor.moveToNext()) {
                    zzgn2.zza(cursor);
                }
                if (cursor == null) return;
            }
            catch (Throwable throwable) {
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
            cursor.close();
        }

        final int zzb(zzgn<Cursor> zzgn2) {
            Cursor cursor = null;
            try {
                cursor = this.zzb();
                if (cursor.moveToFirst()) {
                    zzgn2.zza(cursor);
                    return 1;
                }
                return 0;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        @Nullable
        final <T> T zza(Function<Cursor, T> object) {
            Cursor cursor = null;
            try {
                cursor = this.zzb();
                if (cursor.moveToFirst()) {
                    object = object.apply((Object)cursor);
                    return (T)object;
                }
                return null;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        final boolean zza() {
            Cursor cursor = null;
            try {
                cursor = this.zzb();
                boolean bl = !cursor.moveToFirst();
                return bl;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        private Cursor zzb() {
            if (this.zzc != null) {
                return zzcw.this.zze.rawQueryWithFactory(this.zzc, this.zzb, null, null);
            }
            return zzcw.this.zze.rawQuery(this.zzb, null);
        }

        /* synthetic */ zzb(String string, byte by) {
            this(string);
        }
    }

    static final class zza
    extends SQLiteOpenHelper {
        private boolean zza;

        zza(Context context, String string) {
            super(context, string, null, zzdf.zza);
        }

        public final void onConfigure(SQLiteDatabase db) {
            Cursor cursor;
            this.zza = true;
            cursor = cursor.rawQuery("PRAGMA locking_mode = EXCLUSIVE", new String[0]);
            cursor.close();
        }

        private void zza(SQLiteDatabase sQLiteDatabase) {
            if (!this.zza) {
                this.onConfigure(sQLiteDatabase);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void onCreate(SQLiteDatabase db) {
            void var1_1;
            this.zza(db);
            new zzdf((SQLiteDatabase)var1_1).zza(0);
        }

        /*
         * WARNING - void declaration
         */
        public final void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            void var2_2;
            void var1_1;
            this.zza(db);
            new zzdf((SQLiteDatabase)var1_1).zza((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            void var1_1;
            this.zza((SQLiteDatabase)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void onOpen(SQLiteDatabase db) {
            void var1_1;
            this.zza((SQLiteDatabase)var1_1);
        }
    }
}

