/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.obfuscated;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.firebase.firestore.obfuscated.zzfd;
import com.google.firebase.firestore.obfuscated.zzfe;
import com.google.firebase.firestore.obfuscated.zzff;
import com.google.firebase.firestore.obfuscated.zzfg;
import com.google.firebase.firestore.obfuscated.zzfh;
import com.google.firebase.firestore.obfuscated.zzfi;
import com.google.firebase.firestore.obfuscated.zzfj;
import com.google.firebase.firestore.obfuscated.zzfx;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzgf;
import com.google.firebase.firestore.obfuscated.zzgt;
import com.google.firebase.firestore.obfuscated.zzgv;
import com.google.firebase.firestore.obfuscated.zzgw;
import com.google.firebase.firestore.obfuscated.zzha;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.TimeUnit;

abstract class zzfc<ReqT, RespT, CallbackT extends zzfx.zzb>
implements zzfx<CallbackT> {
    private static final long zzc = TimeUnit.SECONDS.toMillis(1L);
    private static final long zzd = TimeUnit.MINUTES.toMillis(1L);
    private static final long zze = TimeUnit.MINUTES.toMillis(1L);
    @Nullable
    private zzgf.zzb zzf;
    private final zzgv zzg;
    private final MethodDescriptor<ReqT, RespT> zzh;
    private final zzb zzi;
    private final zzgf zzj;
    private final zzgf.zzc zzk;
    private zzfx.zza zzl = zzfx.zza.zza;
    private long zzm = 0L;
    private ClientCall<ReqT, RespT> zzn;
    final zzgt zza;
    final CallbackT zzb;

    zzfc(zzgv zzgv2, MethodDescriptor<ReqT, RespT> methodDescriptor, zzgf zzgf2, zzgf.zzc zzc2, zzgf.zzc zzc3, CallbackT CallbackT) {
        this.zzg = zzgv2;
        this.zzh = methodDescriptor;
        this.zzj = zzgf2;
        this.zzk = zzc3;
        this.zzb = CallbackT;
        this.zzi = new zzb(this);
        this.zza = new zzgt(zzgf2, zzc2, zzc, 1.5, zzd);
    }

    public boolean zza() {
        this.zzj.zzb();
        return this.zzl == zzfx.zza.zzb || this.zzl == zzfx.zza.zzc || this.zzl == zzfx.zza.zze;
    }

    public boolean zzb() {
        this.zzj.zzb();
        return this.zzl == zzfx.zza.zzc;
    }

    public void zzc() {
        this.zzj.zzb();
        zzge.zza(this.zzn == null, "Last call still set", new Object[0]);
        zzge.zza(this.zzf == null, "Idle timer still set", new Object[0]);
        if (this.zzl == zzfx.zza.zzd) {
            zzfc zzfc2 = this;
            zzge.zza(zzfc2.zzl == zzfx.zza.zzd, "Should only perform backoff in an error state", new Object[0]);
            zzfc2.zzl = zzfx.zza.zze;
            zzfc2.zza.zza(zzfe.zza(zzfc2));
            return;
        }
        zzge.zza(this.zzl == zzfx.zza.zza, "Already started", new Object[0]);
        zza zza2 = new zza(this, this.zzm);
        zzc zzc2 = new zzc(zza2);
        this.zzn = this.zzg.zza(this.zzh, zzc2);
        this.zzl = zzfx.zza.zzb;
        this.zzj.zzb(zzfd.zza(this, zza2));
    }

    private void zza(zzfx.zza zza2, Status status) {
        zzge.zza(this.zza(), "Only started streams should be closed.", new Object[0]);
        zzge.zza(zza2 == zzfx.zza.zzd || status.equals((Object)Status.OK), "Can't provide an error when not in an error state.", new Object[0]);
        this.zzj.zzb();
        this.zzh();
        this.zza.zzc();
        ++this.zzm;
        Status.Code code = status.getCode();
        if (code == Status.Code.OK) {
            this.zza.zza();
        } else if (code == Status.Code.RESOURCE_EXHAUSTED) {
            zzha.zzb(this.getClass().getSimpleName(), "(%x) Using maximum backoff delay to prevent overloading the backend.", System.identityHashCode(this));
            this.zza.zzb();
        } else if (code == Status.Code.UNAUTHENTICATED) {
            this.zzg.zza();
        }
        if (zza2 != zzfx.zza.zzd) {
            zzha.zzb(this.getClass().getSimpleName(), "(%x) Performing stream teardown", System.identityHashCode(this));
            this.zzd();
        }
        if (this.zzn != null) {
            if (status.isOk()) {
                zzha.zzb(this.getClass().getSimpleName(), "(%x) Closing stream client-side", System.identityHashCode(this));
                this.zzn.halfClose();
            }
            this.zzn = null;
        }
        this.zzl = zza2;
        this.zzb.zza(status);
    }

    protected void zzd() {
    }

    public void zze() {
        if (this.zza()) {
            this.zza(zzfx.zza.zza, Status.OK);
        }
    }

    public void zzf() {
        zzge.zza(!this.zza(), "Can only inhibit backoff after in a stopped state", new Object[0]);
        this.zzj.zzb();
        this.zzl = zzfx.zza.zza;
        this.zza.zza();
    }

    protected final void zza(ReqT ReqT) {
        this.zzj.zzb();
        zzha.zzb(this.getClass().getSimpleName(), "(%x) Stream sending: %s", System.identityHashCode(this), ReqT);
        this.zzh();
        this.zzn.sendMessage(ReqT);
    }

    @VisibleForTesting
    final void zza(Status status) {
        zzge.zza(this.zza(), "Can't handle server close on non-started stream!", new Object[0]);
        this.zza(zzfx.zza.zzd, status);
    }

    public abstract void zzb(RespT var1);

    final void zzg() {
        if (this.zzb() && this.zzf == null) {
            this.zzf = this.zzj.zza(this.zzk, zze, this.zzi);
        }
    }

    private void zzh() {
        if (this.zzf != null) {
            this.zzf.zza();
            this.zzf = null;
        }
    }

    static /* synthetic */ void zza(zzfc zzfc2) {
        zzge.zza(zzfc2.zzl == zzfx.zza.zze, "State should still be backoff but was %s", new Object[]{zzfc2.zzl});
        zzfc2.zzl = zzfx.zza.zza;
        zzfc2.zzc();
        zzge.zza(zzfc2.zza(), "Stream should have started", new Object[0]);
    }

    static /* synthetic */ void zza(zzfc zzfc2, zza zza2) {
        zza2.zza(zzff.zza(zzfc2));
    }

    static /* synthetic */ void zzb(zzfc zzfc2) {
        zzfc2.zzl = zzfx.zza.zzc;
        zzfc2.zzb.zza();
    }

    static /* synthetic */ void zze(zzfc zzfc2) {
        if (zzfc2.zzb()) {
            zzfc2.zza(zzfx.zza.zza, Status.OK);
        }
    }

    @VisibleForTesting
    final class zzb
    implements Runnable {
        private /* synthetic */ zzfc zza;

        zzb(zzfc zzfc2) {
            this.zza = zzfc2;
        }

        @Override
        public final void run() {
            zzfc.zze(this.zza);
        }
    }

    final class zzc
    implements zzgw<RespT> {
        private final zza zzb;

        zzc(zza zza2) {
            this.zzb = zza2;
        }

        @Override
        public final void zza(Metadata metadata) {
            this.zzb.zza(zzfg.zza(this, metadata));
        }

        @Override
        public final void zza(RespT RespT) {
            this.zzb.zza(zzfh.zza(this, RespT));
        }

        @Override
        public final void zza() {
            this.zzb.zza(zzfi.zza(this));
        }

        @Override
        public final void zza(Status status) {
            this.zzb.zza(zzfj.zza(this, status));
        }
    }

    class zza {
        private final long zza;
        private /* synthetic */ zzfc zzb;

        zza(zzfc zzfc2, long l) {
            this.zzb = zzfc2;
            this.zza = l;
        }

        final void zza(Runnable runnable) {
            this.zzb.zzj.zzb();
            if (this.zzb.zzm == this.zza) {
                runnable.run();
                return;
            }
            zzha.zzb(this.zzb.getClass().getSimpleName(), "stream callback skipped by CloseGuardedRunner.", new Object[0]);
        }
    }
}

