/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.obfuscated;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.Exclude;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.IgnoreExtraProperties;
import com.google.firebase.firestore.PropertyName;
import com.google.firebase.firestore.ServerTimestamp;
import com.google.firebase.firestore.ThrowOnExtraProperties;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzha;
import java.lang.constant.Constable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class zzgo {
    private static final ConcurrentMap<Class<?>, zza<?>> zza = new ConcurrentHashMap();

    private static void zzb(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException("Hard assert failed: " + string);
        }
    }

    public static Object zza(Object object) {
        return zzgo.zzb(object, zzb.zza);
    }

    public static <T> T zza(Object object, Class<T> clazz) {
        return zzgo.zza(object, clazz, zzb.zza);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> Object zzb(T object2, zzb zzb2) {
        void var1_5;
        if (var1_5.zza() > 500) {
            throw zzgo.zzb((zzb)var1_5, "Exceeded maximum depth of 500, which likely indicates there's an object cycle");
        }
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Number) {
            if (object2 instanceof Float) {
                return ((Float)object2).doubleValue();
            }
            if (object2 instanceof Short) {
                throw zzgo.zzb((zzb)var1_5, "Shorts are not supported, please use int or long");
            }
            if (object2 instanceof Byte) {
                throw zzgo.zzb((zzb)var1_5, "Bytes are not supported, please use int or long");
            }
            return object2;
        }
        if (object2 instanceof String) {
            return object2;
        }
        if (object2 instanceof Boolean) {
            return object2;
        }
        if (object2 instanceof Character) {
            throw zzgo.zzb((zzb)var1_5, "Characters are not supported, please use Strings.");
        }
        if (object2 instanceof Map) {
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : ((Map)object2).entrySet()) {
                Object object = entry.getKey();
                if (object instanceof String) {
                    object = (String)object;
                    hashMap.put(object, zzgo.zzb(entry.getValue(), var1_5.zza((String)object)));
                    continue;
                }
                throw zzgo.zzb((zzb)var1_5, "Maps with non-string keys are not supported");
            }
            return hashMap;
        }
        if (object2 instanceof Collection) {
            if (object2 instanceof List) {
                void var0_4;
                List list = (List)object2;
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                boolean bl = false;
                while (var0_4 < list.size()) {
                    arrayList.add(zzgo.zzb(list.get((int)var0_4), var1_5.zza("[" + (int)var0_4 + "]")));
                    ++var0_4;
                }
                return arrayList;
            }
            throw zzgo.zzb((zzb)var1_5, "Serializing Collections is not supported, please use Lists instead");
        }
        if (object2.getClass().isArray()) {
            throw zzgo.zzb((zzb)var1_5, "Serializing Arrays is not supported, please use Lists instead");
        }
        if (object2 instanceof Enum) {
            return ((Enum)object2).name();
        }
        if (object2 instanceof Date || object2 instanceof Timestamp || object2 instanceof GeoPoint || object2 instanceof Blob || object2 instanceof DocumentReference) {
            return object2;
        }
        Class<?> clazz = object2.getClass();
        zza<?> zza2 = zzgo.zza(clazz);
        return zza2.zza(object2, (zzb)var1_5);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T zzb(Object object, Type object2, zzb zzb2) {
        while (true) {
            Object object3;
            if (object == null) {
                return null;
            }
            if (object2 instanceof ParameterizedType) {
                void var6_12;
                object3 = (Type[])(object2 = (ParameterizedType)object2).getRawType();
                if (List.class.isAssignableFrom((Class<?>)object3)) {
                    Type type = object2.getActualTypeArguments()[0];
                    if (object instanceof List) {
                        object3 = (List)object;
                        object = new ArrayList(object3.size());
                        for (int i = 0; i < object3.size(); ++i) {
                            object.add(zzgo.zzb(object3.get(i), type, zzb2.zza("[" + i + "]")));
                        }
                        return (T)object;
                    }
                    throw zzgo.zzc(zzb2, "Expected a List, but got a " + object.getClass());
                }
                if (Map.class.isAssignableFrom((Class<?>)object3)) {
                    Type type = object2.getActualTypeArguments()[0];
                    object3 = object2.getActualTypeArguments()[1];
                    if (!type.equals(String.class)) {
                        throw zzgo.zzc(zzb2, "Only Maps with string keys are supported, but found Map with key type " + type);
                    }
                    object = zzgo.zzc(object, zzb2);
                    HashMap<String, T> hashMap = new HashMap<String, T>();
                    for (Map.Entry entry : object.entrySet()) {
                        hashMap.put((String)entry.getKey(), zzgo.zzb(entry.getValue(), (Type)object3, zzb2.zza((String)entry.getKey())));
                    }
                    return (T)hashMap;
                }
                if (Collection.class.isAssignableFrom((Class<?>)object3)) {
                    throw zzgo.zzc(zzb2, "Collections are not supported, please use Lists instead");
                }
                Map<String, Object> map = zzgo.zzc(object, zzb2);
                object3 = zzgo.zza(object3);
                object = new HashMap();
                TypeVariable<Class<T>>[] typeVariableArray = ((zza)object3).zza.getTypeParameters();
                if (((Type[])(object2 = object2.getActualTypeArguments())).length != typeVariableArray.length) {
                    throw new IllegalStateException("Mismatched lengths for type variables and actual types");
                }
                boolean i = false;
                while (var6_12 < typeVariableArray.length) {
                    ((HashMap)object).put(typeVariableArray[var6_12], object2[var6_12]);
                    ++var6_12;
                }
                return ((zza)object3).zza(map, object, zzb2);
            }
            if (object2 instanceof Class) {
                return zzgo.zza(object, (Class)object2, zzb2);
            }
            if (object2 instanceof WildcardType) {
                object3 = ((WildcardType)object2).getLowerBounds();
                if (((Type[])object3).length > 0) {
                    throw zzgo.zzc(zzb2, "Generic lower-bounded wildcard types are not supported");
                }
                object3 = ((WildcardType)object2).getUpperBounds();
                zzgo.zzb(((Type[])object3).length > 0, "Unexpected type bounds on wildcard " + object2);
                object2 = object3[0];
                continue;
            }
            if (!(object2 instanceof TypeVariable)) break;
            object3 = ((TypeVariable)object2).getBounds();
            zzgo.zzb(((Type[])object3).length > 0, "Unexpected type bounds on type variable " + object2);
            object2 = object3[0];
        }
        if (object2 instanceof GenericArrayType) {
            throw zzgo.zzc(zzb2, "Generic Arrays are not supported, please use Lists instead");
        }
        throw zzgo.zzc(zzb2, "Unknown type encountered: " + object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> T zza(Object zza2, Class<T> object, zzb zzb2) {
        if (zza2 == null) {
            return null;
        }
        if (((Class)object).isPrimitive() || Number.class.isAssignableFrom((Class<?>)object) || Boolean.class.isAssignableFrom((Class<?>)object) || Character.class.isAssignableFrom((Class<?>)object)) {
            Constable constable;
            if (Integer.class.isAssignableFrom((Class<?>)object) || Integer.TYPE.isAssignableFrom((Class<?>)object)) {
                zza zza3 = zza2;
                zza2 = zzb2;
                zza zza4 = zza3;
                if (zza3 instanceof Integer) {
                    constable = (Integer)((Object)zza4);
                    return (T)constable;
                } else {
                    double d;
                    if (!(zza4 instanceof Long) && !(zza4 instanceof Double)) throw zzgo.zzc((zzb)((Object)zza2), "Failed to convert a value of type " + zza4.getClass().getName() + " to int");
                    double d2 = ((Number)((Object)zza4)).doubleValue();
                    if (!(d >= -2.147483648E9) || !(d2 <= 2.147483647E9)) throw zzgo.zzc((zzb)((Object)zza2), "Numeric value out of 32-bit integer range: " + d2 + ". Did you mean to use a long or double instead of an int?");
                    constable = ((Number)((Object)zza4)).intValue();
                }
                return (T)constable;
            } else if (Boolean.class.isAssignableFrom((Class<?>)object) || Boolean.TYPE.isAssignableFrom((Class<?>)object)) {
                zza zza5 = zza2;
                zza2 = zzb2;
                zza zza6 = zza5;
                if (!(zza5 instanceof Boolean)) throw zzgo.zzc((zzb)((Object)zza2), "Failed to convert value of type " + zza6.getClass().getName() + " to boolean");
                constable = (Boolean)((Object)zza6);
                return (T)constable;
            } else {
                if (Double.class.isAssignableFrom((Class<?>)object) || Double.TYPE.isAssignableFrom((Class<?>)object)) {
                    return (T)zzgo.zzd(zza2, zzb2);
                }
                if (Long.class.isAssignableFrom((Class<?>)object) || Long.TYPE.isAssignableFrom((Class<?>)object)) {
                    zza zza7 = zza2;
                    zza2 = zzb2;
                    zza zza8 = zza7;
                    if (zza7 instanceof Integer) {
                        constable = ((Integer)((Object)zza8)).longValue();
                        return (T)constable;
                    } else if (zza8 instanceof Long) {
                        constable = (Long)((Object)zza8);
                        return (T)constable;
                    } else {
                        Double d;
                        if (!(zza8 instanceof Double)) throw zzgo.zzc((zzb)((Object)zza2), "Failed to convert a value of type " + zza8.getClass().getName() + " to long");
                        Double d3 = (Double)((Object)zza8);
                        if (!(d >= -9.223372036854776E18) || !(d3 <= 9.223372036854776E18)) throw zzgo.zzc((zzb)((Object)zza2), "Numeric value out of 64-bit long range: " + d3 + ". Did you mean to use a double instead of a long?");
                        constable = d3.longValue();
                    }
                    return (T)constable;
                } else {
                    if (Float.class.isAssignableFrom((Class<?>)object) || Float.TYPE.isAssignableFrom((Class<?>)object)) {
                        return (T)Float.valueOf(zzgo.zzd(zza2, zzb2).floatValue());
                    }
                    if (Short.class.isAssignableFrom((Class<?>)object) || Short.TYPE.isAssignableFrom((Class<?>)object)) {
                        throw zzgo.zzc(zzb2, "Deserializing to shorts is not supported");
                    }
                    if (Byte.class.isAssignableFrom((Class<?>)object) || Byte.TYPE.isAssignableFrom((Class<?>)object)) {
                        throw zzgo.zzc(zzb2, "Deserializing to bytes is not supported");
                    }
                    if (!Character.class.isAssignableFrom((Class<?>)object) && !Character.TYPE.isAssignableFrom((Class<?>)object)) throw new IllegalArgumentException("Unknown primitive type: " + object);
                    throw zzgo.zzc(zzb2, "Deserializing to chars is not supported");
                }
            }
        }
        if (String.class.isAssignableFrom((Class<?>)object)) {
            object = zzb2;
            if (!(zza2 instanceof String)) throw zzgo.zzc((zzb)object, "Failed to convert value of type " + zza2.getClass().getName() + " to String");
            return (T)((String)((Object)zza2));
        }
        if (Date.class.isAssignableFrom((Class<?>)object)) {
            object = zzb2;
            if (zza2 instanceof Date) {
                return (T)((Date)((Object)zza2));
            }
            if (!(zza2 instanceof Timestamp)) throw zzgo.zzc((zzb)object, "Failed to convert value of type " + zza2.getClass().getName() + " to Date");
            return (T)((Timestamp)((Object)zza2)).toDate();
        }
        if (Timestamp.class.isAssignableFrom((Class<?>)object)) {
            object = zzb2;
            if (zza2 instanceof Timestamp) {
                return (T)((Timestamp)((Object)zza2));
            }
            if (!(zza2 instanceof Date)) throw zzgo.zzc((zzb)object, "Failed to convert value of type " + zza2.getClass().getName() + " to Timestamp");
            return (T)new Timestamp((Date)((Object)zza2));
        }
        if (Blob.class.isAssignableFrom((Class<?>)object)) {
            object = zzb2;
            if (!(zza2 instanceof Blob)) throw zzgo.zzc((zzb)object, "Failed to convert value of type " + zza2.getClass().getName() + " to Blob");
            return (T)((Blob)((Object)zza2));
        }
        if (GeoPoint.class.isAssignableFrom((Class<?>)object)) {
            object = zzb2;
            if (!(zza2 instanceof GeoPoint)) throw zzgo.zzc((zzb)object, "Failed to convert value of type " + zza2.getClass().getName() + " to GeoPoint");
            return (T)((GeoPoint)((Object)zza2));
        }
        if (DocumentReference.class.isAssignableFrom((Class<?>)object)) {
            object = zzb2;
            if (!(zza2 instanceof DocumentReference)) throw zzgo.zzc((zzb)object, "Failed to convert value of type " + zza2.getClass().getName() + " to DocumentReference");
            return (T)((DocumentReference)((Object)zza2));
        }
        if (((Class)object).isArray()) {
            throw zzgo.zzc(zzb2, "Converting to Arrays is not supported, please use Lists instead");
        }
        if (((Class)object).getTypeParameters().length > 0) {
            throw zzgo.zzc(zzb2, "Class " + ((Class)object).getName() + " has generic type parameters, please use GenericTypeIndicator instead");
        }
        if (object.equals(Object.class)) {
            return (T)zza2;
        }
        if (((Class)object).isEnum()) {
            return zzgo.zzb((Object)zza2, object, zzb2);
        }
        zza zza9 = zzgo.zza(object);
        if (!(zza2 instanceof Map)) throw zzgo.zzc(zzb2, "Can't convert object of type " + zza2.getClass().getName() + " to type " + ((Class)object).getName());
        zzb zzb3 = zzb2;
        Map<String, Object> map = zzgo.zzc(zza2, zzb2);
        zza2 = zza9;
        return zza2.zza(map, Collections.emptyMap(), zzb3);
    }

    private static <T> T zzb(Object object, Class<T> clazz, zzb zzb2) {
        if (object instanceof String) {
            object = (String)object;
            try {
                return Enum.valueOf(clazz, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw zzgo.zzc(zzb2, "Could not find enum value of " + clazz.getName() + " for value \"" + (String)object + "\"");
            }
        }
        throw zzgo.zzc(zzb2, "Expected a String while deserializing to enum " + clazz + " but got a " + object.getClass());
    }

    private static <T> zza<T> zza(Class<T> clazz) {
        zza<T> zza2 = (zza<T>)zza.get(clazz);
        if (zza2 == null) {
            zza2 = new zza<T>(clazz);
            zza.put(clazz, zza2);
        }
        return zza2;
    }

    private static Map<String, Object> zzc(Object object, zzb zzb2) {
        if (object instanceof Map) {
            return (Map)object;
        }
        throw zzgo.zzc(zzb2, "Expected a Map while deserializing, but got a " + object.getClass());
    }

    private static Double zzd(Object object, zzb zzb2) {
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            Double d = ((Long)object).doubleValue();
            if (d.longValue() == l.longValue()) {
                return d;
            }
            throw zzgo.zzc(zzb2, "Loss of precision while converting number to double: " + object + ". Did you mean to use a 64-bit long instead?");
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        throw zzgo.zzc(zzb2, "Failed to convert a value of type " + object.getClass().getName() + " to double");
    }

    private static RuntimeException zzb(zzb zzb2, String string) {
        string = "Could not serialize object. " + string;
        if (zzb2.zza() > 0) {
            string = string + " (found in field '" + zzb2.toString() + "')";
        }
        return new RuntimeException(string);
    }

    private static RuntimeException zzc(zzb zzb2, String string) {
        string = "Could not deserialize object. " + string;
        if (zzb2.zza() > 0) {
            string = string + " (found in field '" + zzb2.toString() + "')";
        }
        return new RuntimeException(string);
    }

    static final class zzb {
        private final int zzb;
        private final zzb zzc;
        private final String zzd;
        static final zzb zza = new zzb(null, null, 0);

        private zzb(zzb zzb2, String string, int n) {
            this.zzc = zzb2;
            this.zzd = string;
            this.zzb = n;
        }

        final int zza() {
            return this.zzb;
        }

        final zzb zza(String string) {
            return new zzb(this, string, this.zzb + 1);
        }

        public final String toString() {
            if (this.zzb == 0) {
                return "";
            }
            if (this.zzb == 1) {
                return this.zzd;
            }
            return this.zzc.toString() + "." + this.zzd;
        }
    }

    static final class zza<T> {
        private final Class<T> zza;
        private final Constructor<T> zzb;
        private final boolean zzc;
        private final boolean zzd;
        private final Map<String, String> zze;
        private final Map<String, Method> zzf;
        private final Map<String, Method> zzg;
        private final Map<String, Field> zzh;
        private final HashSet<String> zzi;

        /*
         * WARNING - void declaration
         */
        zza(Class<T> clazz) {
            Class<?>[] classArray;
            Object object;
            Object object2;
            Object object4;
            this.zza = clazz;
            this.zzc = clazz.isAnnotationPresent(ThrowOnExtraProperties.class);
            this.zzd = !clazz.isAnnotationPresent(IgnoreExtraProperties.class);
            this.zze = new HashMap<String, String>();
            this.zzg = new HashMap<String, Method>();
            this.zzf = new HashMap<String, Method>();
            this.zzh = new HashMap<String, Field>();
            this.zzi = new HashSet();
            try {
                object4 = clazz.getDeclaredConstructor(new Class[0]);
                ((Constructor)object4).setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object4 = null;
            }
            this.zzb = object4;
            for (Method accessibleObject : clazz.getMethods()) {
                object2 = accessibleObject;
                if (!(!accessibleObject.getName().startsWith("get") && !((Method)object2).getName().startsWith("is") ? false : (((Method)object2).getDeclaringClass().equals(Object.class) ? false : (!Modifier.isPublic(((Method)object2).getModifiers()) ? false : (Modifier.isStatic(((Method)object2).getModifiers()) ? false : (((Method)object2).getReturnType().equals(Void.TYPE) ? false : (((Method)object2).getParameterTypes().length != 0 ? false : !((AccessibleObject)object2).isAnnotationPresent(Exclude.class)))))))) continue;
                String string = com.google.firebase.firestore.obfuscated.zzgo$zza.zza(accessibleObject);
                this.zza(string);
                accessibleObject.setAccessible(true);
                if (this.zzf.containsKey(string)) {
                    throw new RuntimeException("Found conflicting getters for name " + accessibleObject.getName() + " on class " + clazz.getName());
                }
                this.zzf.put(string, accessibleObject);
                object = accessibleObject;
                object2 = this;
                if (!((AccessibleObject)object).isAnnotationPresent(ServerTimestamp.class)) continue;
                classArray = ((Method)object).getReturnType();
                if (classArray != Date.class && classArray != Timestamp.class) {
                    throw new IllegalArgumentException("Method " + ((Method)object).getName() + " is annotated with @ServerTimestamp but returns " + classArray + " instead of Date or Timestamp.");
                }
                ((zza)object2).zzi.add(com.google.firebase.firestore.obfuscated.zzgo$zza.zza((Method)object));
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                object2 = accessibleObject;
                if (!(((Field)accessibleObject).getDeclaringClass().equals(Object.class) ? false : (!Modifier.isPublic(((Field)object2).getModifiers()) ? false : (Modifier.isStatic(((Field)object2).getModifiers()) ? false : (Modifier.isTransient(((Field)object2).getModifiers()) ? false : !((AccessibleObject)object2).isAnnotationPresent(Exclude.class)))))) continue;
                String string = com.google.firebase.firestore.obfuscated.zzgo$zza.zzb((Field)accessibleObject);
                this.zza(string);
                this.zza((Field)accessibleObject);
            }
            object4 = clazz;
            do {
                void var5_11;
                int n;
                AccessibleObject[] accessibleObjectArray = ((Class)object4).getDeclaredMethods();
                int n2 = accessibleObjectArray.length;
                boolean bl = false;
                while (n < n2) {
                    Object object3;
                    Method method = accessibleObjectArray[n];
                    object2 = method;
                    if ((!method.getName().startsWith("set") ? false : (((Method)object2).getDeclaringClass().equals(Object.class) ? false : (Modifier.isStatic(((Method)object2).getModifiers()) ? false : (!((Method)object2).getReturnType().equals(Void.TYPE) ? false : (((Method)object2).getParameterTypes().length != 1 ? false : !((AccessibleObject)object2).isAnnotationPresent(Exclude.class)))))) && (object3 = this.zze.get(((String)(object2 = com.google.firebase.firestore.obfuscated.zzgo$zza.zza(method))).toLowerCase(Locale.US))) != null) {
                        if (!((String)object3).equals(object2)) {
                            throw new RuntimeException("Found setter on " + ((Class)object4).getName() + " with invalid case-sensitive name: " + method.getName());
                        }
                        object3 = this.zzg.get(object2);
                        if (object3 == null) {
                            method.setAccessible(true);
                            this.zzg.put((String)object2, method);
                            object2 = method;
                            if (((AccessibleObject)object2).isAnnotationPresent(ServerTimestamp.class)) {
                                throw new IllegalArgumentException("Method " + ((Method)object2).getName() + " is annotated with @ServerTimestamp but should not be. @ServerTimestamp can only be applied to fields and getters, not setters.");
                            }
                        } else {
                            object = object3;
                            object2 = method;
                            zzgo.zzb(((Method)object2).getDeclaringClass().isAssignableFrom(((Method)object).getDeclaringClass()), "Expected override from a base class");
                            zzgo.zzb(((Method)object2).getReturnType().equals(Void.TYPE), "Expected void return type");
                            zzgo.zzb(((Method)object).getReturnType().equals(Void.TYPE), "Expected void return type");
                            classArray = ((Method)object2).getParameterTypes();
                            Class<?>[] classArray2 = ((Method)object).getParameterTypes();
                            zzgo.zzb(classArray.length == 1, "Expected exactly one parameter");
                            zzgo.zzb(classArray2.length == 1, "Expected exactly one parameter");
                            if (!(((Method)object2).getName().equals(((Method)object).getName()) && classArray[0].equals(classArray2[0]))) {
                                if (object4 == clazz) {
                                    throw new RuntimeException("Class " + clazz.getName() + " has multiple setter overloads with name " + method.getName());
                                }
                                throw new RuntimeException("Found conflicting setters with name: " + method.getName() + " (conflicts with " + ((Method)object3).getName() + " defined on " + ((Method)object3).getDeclaringClass().getName() + ")");
                            }
                        }
                    }
                    ++n;
                }
                accessibleObjectArray = ((Class)object4).getDeclaredFields();
                n2 = accessibleObjectArray.length;
                n = 0;
                while (var5_11 < n2) {
                    AccessibleObject accessibleObject = accessibleObjectArray[var5_11];
                    object2 = com.google.firebase.firestore.obfuscated.zzgo$zza.zzb((Field)accessibleObject);
                    if (this.zze.containsKey(((String)object2).toLowerCase(Locale.US)) && !this.zzh.containsKey(object2)) {
                        ((Field)accessibleObject).setAccessible(true);
                        this.zzh.put((String)object2, (Field)accessibleObject);
                        this.zza((Field)accessibleObject);
                    }
                    ++var5_11;
                }
            } while ((object4 = ((Class)object4).getSuperclass()) != null && !object4.equals(Object.class));
            if (this.zze.isEmpty()) {
                throw new RuntimeException("No properties to serialize found on class " + clazz.getName());
            }
        }

        private void zza(String string) {
            String string2 = this.zze.put(string.toLowerCase(Locale.US), string);
            if (string2 != null && !string.equals(string2)) {
                throw new RuntimeException("Found two getters or fields with conflicting case sensitivity for property: " + string.toLowerCase(Locale.US));
            }
        }

        final T zza(Map<String, Object> object, Map<TypeVariable<Class<T>>, Type> map, zzb zzb2) {
            if (this.zzb == null) {
                throw zzgo.zzc(zzb2, "Class " + this.zza.getName() + " does not define a no-argument constructor. If you are using ProGuard, make sure these constructors are not stripped");
            }
            T t = zzge.zza(this.zzb);
            for (Map.Entry illegalAccessException : object.entrySet()) {
                Object object2;
                Object object3 = (Type[])illegalAccessException.getKey();
                zzb zzb3 = zzb2.zza((String)object3);
                if (this.zzg.containsKey(object3)) {
                    object2 = this.zzg.get(object3);
                    if (((Type[])(object3 = ((Method)object2).getGenericParameterTypes())).length != 1) {
                        throw zzgo.zzc(zzb3, "Setter does not have exactly one parameter");
                    }
                    object3 = com.google.firebase.firestore.obfuscated.zzgo$zza.zza(object3[0], map);
                    Object object4 = zzgo.zzb(illegalAccessException.getValue(), (Type)object3, zzb3);
                    zzge.zza((Method)object2, t, object4);
                    continue;
                }
                if (this.zzh.containsKey(object3)) {
                    object2 = this.zzh.get(object3);
                    object3 = com.google.firebase.firestore.obfuscated.zzgo$zza.zza(((Field)object2).getGenericType(), map);
                    object3 = zzgo.zzb(illegalAccessException.getValue(), (Type)object3, zzb3);
                    try {
                        ((Field)object2).set(t, object3);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException2) {
                        throw new RuntimeException(illegalAccessException2);
                    }
                }
                object2 = "No setter/field for " + (String)object3 + " found on class " + this.zza.getName();
                if (this.zze.containsKey(((String)object3).toLowerCase(Locale.US))) {
                    object2 = (String)object2 + " (fields/setters are case sensitive!)";
                }
                if (this.zzc) {
                    throw new RuntimeException((String)object2);
                }
                if (!this.zzd) continue;
                zzha.zza(zzgo.class.getSimpleName(), "%s", object2);
            }
            return t;
        }

        private static Type zza(Type type, Map<TypeVariable<Class<T>>, Type> object) {
            if (type instanceof TypeVariable) {
                if ((object = object.get(type)) == null) {
                    throw new IllegalStateException("Could not resolve type " + type);
                }
                return object;
            }
            return type;
        }

        final Map<String, Object> zza(T t, zzb zzb2) {
            if (!this.zza.isAssignableFrom(t.getClass())) {
                throw new IllegalArgumentException("Can't serialize object of class " + t.getClass() + " with BeanMapper for class " + this.zza);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : this.zze.values()) {
                Object object;
                if (this.zzf.containsKey(string)) {
                    object = this.zzf.get(string);
                    object = zzge.zza((Method)object, t, new Object[0]);
                } else {
                    object = this.zzh.get(string);
                    if (object == null) {
                        throw new IllegalStateException("Bean property without field or getter: " + string);
                    }
                    try {
                        object = ((Field)object).get(t);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                }
                object = this.zzi.contains(string) && object == null ? FieldValue.serverTimestamp() : zzgo.zzb(object, zzb2.zza(string));
                hashMap.put(string, object);
            }
            return hashMap;
        }

        private void zza(Field field) {
            if (field.isAnnotationPresent(ServerTimestamp.class)) {
                Class<?> clazz = field.getType();
                if (clazz != Date.class && clazz != Timestamp.class) {
                    throw new IllegalArgumentException("Field " + field.getName() + " is annotated with @ServerTimestamp but is " + clazz + " instead of Date or Timestamp.");
                }
                this.zzi.add(com.google.firebase.firestore.obfuscated.zzgo$zza.zzb(field));
            }
        }

        private static String zzb(Field field) {
            String string = com.google.firebase.firestore.obfuscated.zzgo$zza.zza(field);
            if (string != null) {
                return string;
            }
            return field.getName();
        }

        private static String zza(Method object) {
            int n;
            Object object2 = com.google.firebase.firestore.obfuscated.zzgo$zza.zza((AccessibleObject)object);
            if (object2 != null) {
                return object2;
            }
            object = ((Method)object).getName();
            object2 = new String[]{"get", "set", "is"};
            String string = null;
            for (n = 0; n < 3; ++n) {
                String string2 = object2[n];
                if (!((String)object).startsWith(string2)) continue;
                string = string2;
            }
            if (string == null) {
                throw new IllegalArgumentException("Unknown Bean prefix for method: " + (String)object);
            }
            object2 = ((String)object).substring(string.length());
            object = object2.toCharArray();
            for (n = 0; n < ((Object)object).length && Character.isUpperCase((char)object[n]); ++n) {
                object[n] = Character.toLowerCase((char)object[n]);
            }
            return new String((char[])object);
        }

        private static String zza(AccessibleObject object) {
            if (((AccessibleObject)object).isAnnotationPresent(PropertyName.class)) {
                object = ((AccessibleObject)object).getAnnotation(PropertyName.class);
                return object.value();
            }
            return null;
        }
    }
}

