/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

class MemoryIndexManager
implements IndexManager {
    private final MemoryCollectionParentIndex collectionParentsIndex = new MemoryCollectionParentIndex();

    MemoryIndexManager() {
    }

    @Override
    public void addToCollectionParentIndex(ResourcePath collectionPath) {
        this.collectionParentsIndex.add(collectionPath);
    }

    @Override
    public List<ResourcePath> getCollectionParents(String collectionId) {
        return this.collectionParentsIndex.getEntries(collectionId);
    }

    static class MemoryCollectionParentIndex {
        private final HashMap<String, HashSet<ResourcePath>> index = new HashMap();

        MemoryCollectionParentIndex() {
        }

        boolean add(ResourcePath collectionPath) {
            Assert.hardAssert(collectionPath.length() % 2 == 1, "Expected a collection path.", new Object[0]);
            String collectionId = collectionPath.getLastSegment();
            ResourcePath parentPath = (ResourcePath)collectionPath.popLast();
            HashSet<ResourcePath> existingParents = this.index.get(collectionId);
            if (existingParents == null) {
                existingParents = new HashSet();
                this.index.put(collectionId, existingParents);
            }
            return existingParents.add(parentPath);
        }

        List<ResourcePath> getEntries(String collectionId) {
            HashSet<ResourcePath> existingParents = this.index.get(collectionId);
            return existingParents != null ? new ArrayList<ResourcePath>(existingParents) : Collections.emptyList();
        }
    }
}

