/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ObjectValue;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.FieldTransform;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Mutation {
    private final DocumentKey key;
    private final Precondition precondition;
    private final List<FieldTransform> fieldTransforms;

    Mutation(DocumentKey key, Precondition precondition) {
        this(key, precondition, new ArrayList<FieldTransform>());
    }

    Mutation(DocumentKey key, Precondition precondition, List<FieldTransform> fieldTransforms) {
        this.key = key;
        this.precondition = precondition;
        this.fieldTransforms = fieldTransforms;
    }

    public DocumentKey getKey() {
        return this.key;
    }

    public Precondition getPrecondition() {
        return this.precondition;
    }

    public List<FieldTransform> getFieldTransforms() {
        return this.fieldTransforms;
    }

    public abstract void applyToRemoteDocument(MutableDocument var1, MutationResult var2);

    public abstract void applyToLocalView(MutableDocument var1, Timestamp var2);

    boolean hasSameKeyAndPrecondition(Mutation other) {
        return this.key.equals(other.key) && this.precondition.equals(other.precondition);
    }

    int keyAndPreconditionHashCode() {
        return this.getKey().hashCode() * 31 + this.precondition.hashCode();
    }

    String keyAndPreconditionToString() {
        return "key=" + this.key + ", precondition=" + this.precondition;
    }

    void verifyKeyMatches(MutableDocument document) {
        Assert.hardAssert(document.getKey().equals(this.getKey()), "Can only apply a mutation to a document with the same key", new Object[0]);
    }

    static SnapshotVersion getPostMutationVersion(MutableDocument document) {
        if (document.isFoundDocument()) {
            return document.getVersion();
        }
        return SnapshotVersion.NONE;
    }

    protected Map<FieldPath, Value> serverTransformResults(MutableDocument mutableDocument, List<Value> serverTransformResults) {
        HashMap<FieldPath, Value> transformResults = new HashMap<FieldPath, Value>(this.fieldTransforms.size());
        Assert.hardAssert(this.fieldTransforms.size() == serverTransformResults.size(), "server transform count (%d) should match field transform count (%d)", serverTransformResults.size(), this.fieldTransforms.size());
        for (int i = 0; i < serverTransformResults.size(); ++i) {
            FieldTransform fieldTransform = this.fieldTransforms.get(i);
            TransformOperation transform = fieldTransform.getOperation();
            Value previousValue = null;
            if (mutableDocument.isFoundDocument()) {
                previousValue = mutableDocument.getField(fieldTransform.getFieldPath());
            }
            transformResults.put(fieldTransform.getFieldPath(), transform.applyToRemoteDocument(previousValue, serverTransformResults.get(i)));
        }
        return transformResults;
    }

    protected Map<FieldPath, Value> localTransformResults(Timestamp localWriteTime, MutableDocument mutableDocument) {
        HashMap<FieldPath, Value> transformResults = new HashMap<FieldPath, Value>(this.fieldTransforms.size());
        for (FieldTransform fieldTransform : this.fieldTransforms) {
            TransformOperation transform = fieldTransform.getOperation();
            Value previousValue = null;
            if (mutableDocument.isFoundDocument()) {
                previousValue = mutableDocument.getField(fieldTransform.getFieldPath());
            }
            transformResults.put(fieldTransform.getFieldPath(), transform.applyToLocalView(previousValue, localWriteTime));
        }
        return transformResults;
    }

    public ObjectValue extractTransformBaseValue(Document document) {
        ObjectValue baseObject = null;
        for (FieldTransform transform : this.fieldTransforms) {
            Value existingValue = document.getField(transform.getFieldPath());
            Value coercedValue = transform.getOperation().computeBaseValue(existingValue);
            if (coercedValue == null) continue;
            if (baseObject == null) {
                baseObject = new ObjectValue();
            }
            baseObject.set(transform.getFieldPath(), coercedValue);
        }
        return baseObject;
    }
}

