/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.auto.value.AutoValue;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.remote.AutoValue_TestingHooks_ExistenceFilterMismatchInfo;
import com.google.firebase.firestore.remote.ExistenceFilter;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Preconditions;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
final class TestingHooks {
    private static final TestingHooks instance = new TestingHooks();
    private final CopyOnWriteArrayList<AtomicReference<ExistenceFilterMismatchListener>> existenceFilterMismatchListeners = new CopyOnWriteArrayList();

    private TestingHooks() {
    }

    @NonNull
    static TestingHooks getInstance() {
        return instance;
    }

    void notifyOnExistenceFilterMismatch(@NonNull ExistenceFilterMismatchInfo info) {
        for (AtomicReference<ExistenceFilterMismatchListener> listenerRef : this.existenceFilterMismatchListeners) {
            Executors.BACKGROUND_EXECUTOR.execute(() -> {
                ExistenceFilterMismatchListener listener = (ExistenceFilterMismatchListener)listenerRef.get();
                if (listener != null) {
                    listener.onExistenceFilterMismatch(info);
                }
            });
        }
    }

    ListenerRegistration addExistenceFilterMismatchListener(@NonNull ExistenceFilterMismatchListener listener) {
        Preconditions.checkNotNull(listener, "a null listener is not allowed");
        AtomicReference<ExistenceFilterMismatchListener> listenerRef = new AtomicReference<ExistenceFilterMismatchListener>(listener);
        this.existenceFilterMismatchListeners.add(listenerRef);
        return () -> {
            listenerRef.set(null);
            this.existenceFilterMismatchListeners.remove(listenerRef);
        };
    }

    @AutoValue
    static abstract class ExistenceFilterMismatchInfo {
        ExistenceFilterMismatchInfo() {
        }

        static ExistenceFilterMismatchInfo create(int localCacheCount, int existenceFilterCount) {
            return new AutoValue_TestingHooks_ExistenceFilterMismatchInfo(localCacheCount, existenceFilterCount);
        }

        abstract int localCacheCount();

        abstract int existenceFilterCount();

        static ExistenceFilterMismatchInfo from(int localCacheCount, ExistenceFilter existenceFilter) {
            return ExistenceFilterMismatchInfo.create(localCacheCount, existenceFilter.getCount());
        }
    }

    static interface ExistenceFilterMismatchListener {
        @AnyThread
        public void onExistenceFilterMismatch(@NonNull ExistenceFilterMismatchInfo var1);
    }
}

