/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.content.Context;
import androidx.annotation.GuardedBy;
import com.google.firebase.FirebaseApp;
import com.google.firebase.functions.ContextProvider;
import com.google.firebase.functions.FirebaseFunctions;
import java.util.HashMap;
import java.util.Map;

class FunctionsMultiResourceComponent {
    @GuardedBy(value="this")
    private final Map<String, FirebaseFunctions> instances = new HashMap<String, FirebaseFunctions>();
    private final Context applicationContext;
    private final ContextProvider contextProvider;
    private final FirebaseApp app;

    FunctionsMultiResourceComponent(Context applicationContext, ContextProvider contextProvider, FirebaseApp app) {
        this.applicationContext = applicationContext;
        this.contextProvider = contextProvider;
        this.app = app;
    }

    synchronized FirebaseFunctions get(String regionOrCustomDomain) {
        FirebaseFunctions functions = this.instances.get(regionOrCustomDomain);
        String projectId = this.app.getOptions().getProjectId();
        if (functions == null) {
            functions = new FirebaseFunctions(this.app, this.applicationContext, projectId, regionOrCustomDomain, this.contextProvider);
            this.instances.put(regionOrCustomDomain, functions);
        }
        return functions;
    }
}

