/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import android.util.Log;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.appcheck.interop.InternalAppCheckTokenProvider;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.functions.ContextProvider;
import com.google.firebase.functions.HttpsCallableContext;
import com.google.firebase.iid.internal.FirebaseInstanceIdInternal;
import com.google.firebase.inject.Deferred;
import com.google.firebase.inject.Provider;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class FirebaseContextProvider
implements ContextProvider {
    private final String TAG = "FirebaseContextProvider";
    private final Provider<InternalAuthProvider> tokenProvider;
    private final Provider<FirebaseInstanceIdInternal> instanceId;
    private final AtomicReference<InternalAppCheckTokenProvider> appCheckRef = new AtomicReference();
    private final Executor executor;

    @Inject
    FirebaseContextProvider(Provider<InternalAuthProvider> tokenProvider, Provider<FirebaseInstanceIdInternal> instanceId, Deferred<InternalAppCheckTokenProvider> appCheckDeferred, @Lightweight Executor executor) {
        this.tokenProvider = tokenProvider;
        this.instanceId = instanceId;
        this.executor = executor;
        appCheckDeferred.whenAvailable(p -> {
            InternalAppCheckTokenProvider appCheck = (InternalAppCheckTokenProvider)p.get();
            this.appCheckRef.set(appCheck);
            appCheck.addAppCheckTokenListener(unused -> {});
        });
    }

    @Override
    public Task<HttpsCallableContext> getContext() {
        Task<String> authToken = this.getAuthToken();
        Task<String> appCheckToken = this.getAppCheckToken();
        return Tasks.whenAll((Task[])new Task[]{authToken, appCheckToken}).onSuccessTask(this.executor, v -> Tasks.forResult((Object)new HttpsCallableContext((String)authToken.getResult(), ((FirebaseInstanceIdInternal)this.instanceId.get()).getToken(), (String)appCheckToken.getResult())));
    }

    private Task<String> getAuthToken() {
        InternalAuthProvider auth = (InternalAuthProvider)this.tokenProvider.get();
        if (auth == null) {
            return Tasks.forResult(null);
        }
        return auth.getAccessToken(false).continueWith(this.executor, task -> {
            String authToken = null;
            if (!task.isSuccessful()) {
                Exception exception = task.getException();
                if (!(exception instanceof FirebaseNoSignedInUserException)) {
                    throw exception;
                }
            } else {
                authToken = ((GetTokenResult)task.getResult()).getToken();
            }
            return authToken;
        });
    }

    private Task<String> getAppCheckToken() {
        InternalAppCheckTokenProvider appCheck = this.appCheckRef.get();
        if (appCheck == null) {
            return Tasks.forResult(null);
        }
        return appCheck.getToken(false).onSuccessTask(this.executor, result -> {
            if (result.getError() != null) {
                Log.w((String)"FirebaseContextProvider", (String)("Error getting App Check token. Error: " + result.getError()));
                return Tasks.forResult(null);
            }
            return Tasks.forResult((Object)result.getToken());
        });
    }
}

