/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.iid.MessengerCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzd;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import java.util.Random;

public class zzf {
    static String zzbhQ = null;
    static boolean zzbhR = false;
    static int zzbhS = 0;
    static int zzbhT = 0;
    static int zzbhU = 0;
    static BroadcastReceiver zzbhV = null;
    Context zzqn;
    private final SimpleArrayMap<String, zzb> zzcly = new SimpleArrayMap();
    Messenger zzbgK;
    Messenger zzbhX;
    MessengerCompat zzbhY;
    static PendingIntent zzbgG;
    long zzbhZ;
    long zzbia;
    int zzbib;
    int zzbic;
    long zzbid;

    public zzf(Context context) {
        this.zzqn = context;
    }

    public static String zzbA(Context context) {
        if (zzbhQ != null) {
            return zzbhQ;
        }
        zzbhS = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        if (zzf.zzb(packageManager)) {
            return zzbhQ;
        }
        if (!zzt.zzzq() && zzf.zza(packageManager)) {
            return zzbhQ;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve IID implementation package, falling back");
        if (zzf.zzb(packageManager, "com.google.android.gms")) {
            zzbhR = zzt.zzzq();
            return zzbhQ;
        }
        if (!zzt.zzzo() && zzf.zzb(packageManager, "com.google.android.gsf")) {
            zzbhR = false;
            return zzbhQ;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Google Play services is missing, unable to get tokens");
        return null;
    }

    private static boolean zza(PackageManager packageManager) {
        List list = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0);
        for (ResolveInfo resolveInfo : list) {
            String string = resolveInfo.serviceInfo.packageName;
            if (!zzf.zza(packageManager, string, "com.google.android.c2dm.intent.REGISTER")) continue;
            zzbhR = false;
            return true;
        }
        return false;
    }

    private static boolean zzb(PackageManager packageManager) {
        List list = packageManager.queryBroadcastReceivers(new Intent("com.google.iid.TOKEN_REQUEST"), 0);
        for (ResolveInfo resolveInfo : list) {
            String string = resolveInfo.activityInfo.packageName;
            if (!zzf.zza(packageManager, string, "com.google.iid.TOKEN_REQUEST")) continue;
            zzbhR = true;
            return true;
        }
        return false;
    }

    private static boolean zza(PackageManager packageManager, String string, String string2) {
        if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.SEND", string)) {
            return zzf.zzb(packageManager, string);
        }
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        return false;
    }

    private static boolean zzb(PackageManager packageManager, String string) {
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            zzbhQ = applicationInfo.packageName;
            zzbhT = applicationInfo.uid;
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            String string = privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA";
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return FirebaseInstanceId.zzv(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    void zzHl() {
        if (this.zzbgK != null) {
            return;
        }
        zzf.zzbA(this.zzqn);
        this.zzbgK = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                zzf.this.zze(message);
            }
        });
    }

    void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzbhY = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzbhX = (Messenger)parcelable;
                }
            }
            this.zzs((Intent)message.obj);
        } else {
            Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
        }
    }

    public static synchronized void zzf(Context context, Intent intent) {
        if (zzbgG == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzbgG = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzbgG);
    }

    public void zza(Bundle bundle, KeyPair keyPair, String string) throws IOException {
        long l = SystemClock.elapsedRealtime();
        if (this.zzbid != 0L && l <= this.zzbid) {
            long l2 = this.zzbid - l;
            int n = this.zzbic;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
            throw new IOException("RETRY_LATER");
        }
        this.zzHl();
        if (zzbhQ == null) {
            throw new IOException("MISSING_INSTANCEID_SERVICE");
        }
        this.zzbhZ = SystemClock.elapsedRealtime();
        Intent intent = new Intent(zzbhR ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zzbhQ);
        bundle.putString("gmsv", Integer.toString(FirebaseInstanceId.zzS(this.zzqn, zzf.zzbA(this.zzqn))));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", Integer.toString(FirebaseInstanceId.zzcr(this.zzqn)));
        bundle.putString("app_ver_name", FirebaseInstanceId.zzbx(this.zzqn));
        bundle.putString("cliv", "fiid-10260000");
        bundle.putString("appid", FirebaseInstanceId.zza(keyPair));
        String string2 = FirebaseInstanceId.zzv(keyPair.getPublic().getEncoded());
        bundle.putString("pub2", string2);
        bundle.putString("sig", zzf.zza(keyPair, this.zzqn.getPackageName(), string2));
        intent.putExtras(bundle);
        zzf.zzf(this.zzqn, intent);
        this.zzb(intent, string);
    }

    protected void zzb(Intent intent, String string) {
        block9: {
            String string2;
            this.zzbhZ = SystemClock.elapsedRealtime();
            intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            boolean bl = "com.google.android.gsf".equals(zzbhQ);
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                string2 = String.valueOf(intent.getExtras());
                Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
            }
            if (bl) {
                this.zzHm();
                this.zzqn.startService(intent);
                return;
            }
            intent.putExtra("google.messenger", (Parcelable)this.zzbgK);
            if (this.zzbhX != null || this.zzbhY != null) {
                string2 = Message.obtain();
                ((Message)string2).obj = intent;
                try {
                    if (this.zzbhX != null) {
                        this.zzbhX.send((Message)string2);
                    } else {
                        this.zzbhY.send((Message)string2);
                    }
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block9;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        if (zzbhR) {
            this.zzqn.sendBroadcast(intent);
        } else {
            this.zzqn.startService(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzHm() {
        zzf zzf2 = this;
        synchronized (zzf2) {
            if (zzbhV == null) {
                zzbhV = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                            String string = String.valueOf(intent.getExtras());
                            Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(44 + String.valueOf(string).length()).append("Received GSF callback via dynamic receiver: ").append(string).toString());
                        }
                        zzf.this.zzs(intent);
                    }
                };
                if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                    Log.d((String)"InstanceID/Rpc", (String)"Registered GSF callback receiver");
                }
                IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
                intentFilter.addCategory(this.zzqn.getPackageName());
                this.zzqn.registerReceiver(zzbhV, intentFilter, "com.google.android.c2dm.permission.SEND", null);
            }
        }
    }

    String zzq(Intent intent) throws IOException {
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = intent.getStringExtra("registration_id");
        if (string == null) {
            string = intent.getStringExtra("unregistered");
        }
        if (string == null) {
            string = intent.getStringExtra("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    void zzr(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Unexpected response, no error or registration id ").append(string2).toString());
            return;
        }
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            String string3 = String.valueOf(string);
            Log.d((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Received InstanceID error ".concat(string3) : new String("Received InstanceID error ")));
        }
        String string4 = null;
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            if (stringArray.length > 2) {
                string4 = stringArray[2];
                string = stringArray[3];
                if (string.startsWith(":")) {
                    string = string.substring(1);
                }
            } else {
                string = "UNKNOWN";
            }
            intent.putExtra("error", string);
        }
        this.zzay(string4, string);
        long l = intent.getLongExtra("Retry-After", 0L);
        if (l > 0L) {
            this.zzbia = SystemClock.elapsedRealtime();
            this.zzbic = (int)l * 1000;
            this.zzbid = SystemClock.elapsedRealtime() + (long)this.zzbic;
            int n = this.zzbic;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(n).toString());
        } else if ("SERVICE_NOT_AVAILABLE".equals(string) || "AUTHENTICATION_FAILED".equals(string)) {
            this.zzeF(string);
        }
    }

    private void zzeF(String string) {
        if (!"com.google.android.gsf".equals(zzbhQ)) {
            return;
        }
        ++this.zzbib;
        if (this.zzbib < 3) {
            return;
        }
        if (this.zzbib == 3) {
            this.zzbic = 1000 + new Random().nextInt(1000);
        }
        this.zzbic *= 2;
        this.zzbid = SystemClock.elapsedRealtime() + (long)this.zzbic;
        int n = this.zzbic;
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Backoff due to ").append(string).append(" for ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(String string, Intent intent) {
        SimpleArrayMap<String, zzb> simpleArrayMap = this.zzcly;
        synchronized (simpleArrayMap) {
            zzb zzb2 = (zzb)this.zzcly.remove((Object)string);
            if (zzb2 == null) {
                String string2 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Missing callback for ".concat(string2) : new String("Missing callback for ")));
                return;
            }
            zzb2.zzH(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzay(String string, String string2) {
        SimpleArrayMap<String, zzb> simpleArrayMap = this.zzcly;
        synchronized (simpleArrayMap) {
            if (string == null) {
                for (int i = 0; i < this.zzcly.size(); ++i) {
                    ((zzb)this.zzcly.valueAt(i)).onError(string2);
                }
                this.zzcly.clear();
            } else {
                zzb zzb2 = (zzb)this.zzcly.remove((Object)string);
                if (zzb2 == null) {
                    String string3 = String.valueOf(string);
                    Log.w((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Missing callback for ".concat(string3) : new String("Missing callback for ")));
                    return;
                }
                zzb2.onError(string2);
            }
        }
    }

    void zzs(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Unexpected response ".concat(string2) : new String("Unexpected response ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            this.zzr(intent);
            return;
        }
        this.zzbhZ = SystemClock.elapsedRealtime();
        this.zzbid = 0L;
        this.zzbib = 0;
        this.zzbic = 0;
        String string4 = null;
        if (string3.startsWith("|")) {
            String[] stringArray = string3.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string3);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            string4 = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    FirebaseInstanceId.zzby(this.zzqn);
                } else if ("RST".equals(stringArray[3])) {
                    FirebaseInstanceId.zza(this.zzqn, zzd.zzb(this.zzqn, null).zzabS());
                    intent.removeExtra("registration_id");
                    this.zzb(string4, intent);
                    return;
                }
            }
            if ((string3 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string3 = string3.substring(1);
            }
            intent.putExtra("registration_id", string3);
        }
        if (string4 == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Ignoring response without a request ID");
            }
            return;
        }
        this.zzb(string4, intent);
    }

    Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger") && (intent = this.zzb(bundle, keyPair)) != null && intent.hasExtra("google.messenger")) {
            intent = null;
        }
        return intent;
    }

    public static synchronized String zzHn() {
        return Integer.toString(zzbhU++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        String string = zzf.zzHn();
        zza zza2 = new zza();
        Intent intent = this.zzcly;
        synchronized (intent) {
            this.zzcly.put((Object)string, (Object)zza2);
        }
        this.zza(bundle, keyPair, string);
        try {
            intent = zza2.zzabV();
            return intent;
        }
        finally {
            SimpleArrayMap<String, zzb> simpleArrayMap = this.zzcly;
            synchronized (simpleArrayMap) {
                this.zzcly.remove((Object)string);
            }
        }
    }

    private static class zza
    implements zzb {
        private final ConditionVariable zzclA = new ConditionVariable();
        private Intent intent;
        private String zzclB;

        private zza() {
        }

        @Override
        public void zzH(Intent intent) {
            this.intent = intent;
            this.zzclA.open();
        }

        @Override
        public void onError(String string) {
            this.zzclB = string;
            this.zzclA.open();
        }

        public Intent zzabV() throws IOException {
            if (!this.zzclA.block(30000L)) {
                Log.w((String)"InstanceID/Rpc", (String)"No response");
                throw new IOException("TIMEOUT");
            }
            if (this.zzclB != null) {
                throw new IOException(this.zzclB);
            }
            return this.intent;
        }
    }

    private static interface zzb {
        public void zzH(Intent var1);

        public void onError(String var1);
    }
}

