/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceIdService;
import com.google.firebase.iid.zzj;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzq;
import com.google.firebase.iid.zzr;
import com.google.firebase.iid.zzs;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class FirebaseInstanceId {
    private static Map<String, FirebaseInstanceId> zzhtf = new ArrayMap();
    private static zzk zzmiw;
    private final FirebaseApp zzmix;
    private final zzj zzmiy;
    private final String zzmiz;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzhtf.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            zzj zzj2 = zzj.zza(firebaseApp.getApplicationContext(), null);
            if (zzmiw == null) {
                zzmiw = new zzk(zzj.zzbyl());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp, zzj2);
            zzhtf.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    private FirebaseInstanceId(FirebaseApp firebaseApp, zzj zzj2) {
        String string;
        String[] stringArray;
        String string2;
        this.zzmix = firebaseApp;
        this.zzmiy = zzj2;
        FirebaseInstanceId firebaseInstanceId = this;
        String string3 = firebaseInstanceId.zzmix.getOptions().getGcmSenderId();
        Object object = string3 != null ? string3 : ((string2 = firebaseInstanceId.zzmix.getOptions().getApplicationId()).startsWith("1:") ? ((stringArray = string2.split(":")).length < 2 ? null : ((string = stringArray[1]).isEmpty() ? null : string)) : (this.zzmiz = string2));
        if (this.zzmiz == null) {
            throw new IllegalStateException("IID failing to initialize, FirebaseApp is missing project ID");
        }
        FirebaseInstanceIdService.zza(this.zzmix.getApplicationContext(), this);
    }

    public String getId() {
        return FirebaseInstanceId.zza(this.zzmiy.zzasp());
    }

    public long getCreationTime() {
        return this.zzmiy.getCreationTime();
    }

    public void deleteInstanceId() throws IOException {
        this.zzmiy.zza("*", "*", null);
        this.zzmiy.zzasq();
    }

    @Nullable
    public String getToken() {
        zzs zzs2 = this.zzbyi();
        if (zzs2 == null || zzs2.zzqa(zzj.zzhtl)) {
            FirebaseInstanceIdService.zzel(this.zzmix.getApplicationContext());
        }
        if (zzs2 != null) {
            return zzs2.zzkmz;
        }
        return null;
    }

    @Nullable
    final zzs zzbyi() {
        return zzj.zzbyl().zzo("", this.zzmiz, "*");
    }

    final String zzbyj() throws IOException {
        return this.getToken(this.zzmiz, "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        Bundle bundle = new Bundle();
        this.zzab(bundle);
        return this.zzmiy.getToken(string, string2, bundle);
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        Bundle bundle = new Bundle();
        this.zzab(bundle);
        this.zzmiy.zza(string, string2, bundle);
    }

    public final void zzpq(String string) {
        zzmiw.zzpq(string);
        FirebaseInstanceIdService.zzel(this.zzmix.getApplicationContext());
    }

    static zzk zzbyk() {
        return zzmiw;
    }

    final void zzpr(String string) throws IOException {
        zzs zzs2 = this.zzbyi();
        if (zzs2 == null || zzs2.zzqa(zzj.zzhtl)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        Bundle bundle2 = bundle;
        String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        String string7 = zzs2.zzkmz;
        FirebaseInstanceId firebaseInstanceId = this;
        firebaseInstanceId.zzab(bundle2);
        firebaseInstanceId.zzmiy.zzb(string7, string6, bundle2);
    }

    final void zzps(String string) throws IOException {
        zzs zzs2 = this.zzbyi();
        if (zzs2 == null || zzs2.zzqa(zzj.zzhtl)) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzmiy.zza(zzs2.zzkmz, string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    private final void zzab(Bundle bundle) {
        bundle.putString("gmp_app_id", this.zzmix.getOptions().getApplicationId());
    }

    static String zzm(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required alghorithms");
            return null;
        }
    }

    static int zzei(Context context) {
        return FirebaseInstanceId.zzap(context, context.getPackageName());
    }

    static int zzap(Context context, String string) {
        try {
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return 0;
        }
    }

    static String zzde(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    static void zza(Context context, zzr zzr2) {
        zzr2.zzasu();
        Intent intent = new Intent();
        intent.putExtra("CMD", "RST");
        zzq.zzbyp().zze(context, intent);
    }

    static void zzej(Context context) {
        Intent intent = new Intent();
        intent.putExtra("CMD", "SYNC");
        zzq.zzbyp().zze(context, intent);
    }
}

