/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.iid.MessengerCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzj;
import com.google.firebase.iid.zzm;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.Iterator;
import java.util.Random;

public final class zzl {
    private static String zzhto = null;
    private static boolean zzhtp = false;
    private static int zzhtq = 0;
    private static int zzhtr = 0;
    private static int zzhts = 0;
    private static BroadcastReceiver zzhtt = null;
    private Context zzaie;
    private final SimpleArrayMap<String, zzp> zzmjj = new SimpleArrayMap();
    private Messenger zzhri;
    private Messenger zzhtv;
    private MessengerCompat zzhtw;
    private static PendingIntent zzhre;
    private long zzhtx;
    private long zzhty;
    private int zzhtz;
    private int zzhua;
    private long zzhub;

    public zzl(Context context) {
        this.zzaie = context;
    }

    public static String zzdg(Context context) {
        boolean bl;
        PackageManager packageManager;
        block6: {
            if (zzhto != null) {
                return zzhto;
            }
            zzhtq = Process.myUid();
            PackageManager packageManager2 = packageManager = context.getPackageManager();
            Iterator iterator = packageManager.queryBroadcastReceivers(new Intent("com.google.iid.TOKEN_REQUEST"), 0).iterator();
            while (iterator.hasNext()) {
                String string = ((ResolveInfo)iterator.next()).activityInfo.packageName;
                if (!zzl.zza(packageManager2, string, "com.google.iid.TOKEN_REQUEST")) continue;
                zzhtp = true;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return zzhto;
        }
        if (!com.google.android.gms.common.util.zzp.isAtLeastO() && zzl.zza(packageManager)) {
            return zzhto;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve IID implementation package, falling back");
        if (zzl.zzb(packageManager, "com.google.android.gms")) {
            zzhtp = com.google.android.gms.common.util.zzp.isAtLeastO();
            return zzhto;
        }
        if (!com.google.android.gms.common.util.zzp.zzalj() && zzl.zzb(packageManager, "com.google.android.gsf")) {
            zzhtp = false;
            return zzhto;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Google Play services is missing, unable to get tokens");
        return null;
    }

    private static boolean zza(PackageManager packageManager) {
        Iterator iterator = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0).iterator();
        while (iterator.hasNext()) {
            String string = ((ResolveInfo)iterator.next()).serviceInfo.packageName;
            if (!zzl.zza(packageManager, string, "com.google.android.c2dm.intent.REGISTER")) continue;
            zzhtp = false;
            return true;
        }
        return false;
    }

    private static boolean zza(PackageManager packageManager, String string, String string2) {
        if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.SEND", string)) {
            return zzl.zzb(packageManager, string);
        }
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        return false;
    }

    private static boolean zzb(PackageManager packageManager, String string) {
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 0);
            zzhto = applicationInfo.packageName;
            zzhtr = applicationInfo.uid;
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            Signature signature = Signature.getInstance(privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA");
            signature.initSign(privateKey);
            signature.update(byArray);
            return FirebaseInstanceId.zzm(signature.sign());
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    private final void zzass() {
        if (this.zzhri != null) {
            return;
        }
        zzl.zzdg(this.zzaie);
        this.zzhri = new Messenger((Handler)new zzm(this, Looper.getMainLooper()));
    }

    final void zzc(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.zzhtw = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzhtv = (Messenger)parcelable;
                }
            }
            this.zzi((Intent)message.obj);
            return;
        }
        Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
    }

    public static synchronized void zzd(Context context, Intent intent) {
        if (zzhre == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzhre = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzhre);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzb(String string, Intent intent) {
        SimpleArrayMap<String, zzp> simpleArrayMap = this.zzmjj;
        synchronized (simpleArrayMap) {
            zzp zzp2 = (zzp)this.zzmjj.remove((Object)string);
            if (zzp2 == null) {
                String string2 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Missing callback for ".concat(string2) : new String("Missing callback for ")));
                return;
            }
            zzp2.zzq(intent);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzbk(String string, String string2) {
        SimpleArrayMap<String, zzp> simpleArrayMap = this.zzmjj;
        synchronized (simpleArrayMap) {
            if (string == null) {
                for (int i = 0; i < this.zzmjj.size(); ++i) {
                    ((zzp)this.zzmjj.valueAt(i)).onError(string2);
                }
                this.zzmjj.clear();
            } else {
                zzp zzp2 = (zzp)this.zzmjj.remove((Object)string);
                if (zzp2 == null) {
                    String string3 = String.valueOf(string);
                    Log.w((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Missing callback for ".concat(string3) : new String("Missing callback for ")));
                    return;
                }
                zzp2.onError(string2);
            }
            return;
        }
    }

    final void zzi(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Unexpected response ".concat(string2) : new String("Unexpected response ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            Intent intent2 = intent;
            zzl zzl2 = this;
            String string4 = intent2.getStringExtra("error");
            if (string4 == null) {
                String string5 = String.valueOf(intent2.getExtras());
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string5).length()).append("Unexpected response, no error or registration id ").append(string5).toString());
                return;
            }
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string6 = String.valueOf(string4);
                Log.d((String)"InstanceID/Rpc", (String)(string6.length() != 0 ? "Received InstanceID error ".concat(string6) : new String("Received InstanceID error ")));
            }
            String string7 = null;
            if (string4.startsWith("|")) {
                String[] stringArray = string4.split("\\|");
                if (!"ID".equals(stringArray[1])) {
                    String string8 = String.valueOf(string4);
                    Log.w((String)"InstanceID/Rpc", (String)(string8.length() != 0 ? "Unexpected structured response ".concat(string8) : new String("Unexpected structured response ")));
                }
                if (stringArray.length > 2) {
                    string7 = stringArray[2];
                    string4 = stringArray[3];
                    if (string4.startsWith(":")) {
                        string4 = string4.substring(1);
                    }
                } else {
                    string4 = "UNKNOWN";
                }
                intent2.putExtra("error", string4);
            }
            zzl2.zzbk(string7, string4);
            long l = intent2.getLongExtra("Retry-After", 0L);
            if (l > 0L) {
                zzl2.zzhty = SystemClock.elapsedRealtime();
                zzl2.zzhua = (int)l * 1000;
                zzl2.zzhub = SystemClock.elapsedRealtime() + (long)zzl2.zzhua;
                int n = zzl2.zzhua;
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(n).toString());
                return;
            }
            if ("SERVICE_NOT_AVAILABLE".equals(string4) || "AUTHENTICATION_FAILED".equals(string4)) {
                String string9 = string4;
                zzl zzl3 = zzl2;
                if ("com.google.android.gsf".equals(zzhto)) {
                    ++zzl3.zzhtz;
                    if (zzl3.zzhtz >= 3) {
                        if (zzl3.zzhtz == 3) {
                            zzl3.zzhua = 1000 + new Random().nextInt(1000);
                        }
                        zzl3.zzhua <<= 1;
                        zzl3.zzhub = SystemClock.elapsedRealtime() + (long)zzl3.zzhua;
                        int n = zzl3.zzhua;
                        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(31 + String.valueOf(string9).length()).append("Backoff due to ").append(string9).append(" for ").append(n).toString());
                    }
                }
            }
            return;
        }
        this.zzhtx = SystemClock.elapsedRealtime();
        this.zzhub = 0L;
        this.zzhtz = 0;
        this.zzhua = 0;
        String string10 = null;
        if (string3.startsWith("|")) {
            String[] stringArray = string3.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string11 = String.valueOf(string3);
                Log.w((String)"InstanceID/Rpc", (String)(string11.length() != 0 ? "Unexpected structured response ".concat(string11) : new String("Unexpected structured response ")));
            }
            string10 = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    FirebaseInstanceId.zzej(this.zzaie);
                } else if ("RST".equals(stringArray[3])) {
                    zzj.zza(this.zzaie, null);
                    FirebaseInstanceId.zza(this.zzaie, zzj.zzbyl());
                    intent.removeExtra("registration_id");
                    this.zzb(string10, intent);
                    return;
                }
            }
            if ((string3 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string3 = string3.substring(1);
            }
            intent.putExtra("registration_id", string3);
        }
        if (string10 == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Ignoring response without a request ID");
            }
            return;
        }
        this.zzb(string10, intent);
    }

    final Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger") && (intent = this.zzb(bundle, keyPair)) != null && intent.hasExtra("google.messenger")) {
            intent = null;
        }
        return intent;
    }

    public static synchronized String zzast() {
        return Integer.toString(zzhts++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent;
        zzo zzo2;
        String string;
        block24: {
            String string2;
            string = zzl.zzast();
            zzo2 = new zzo(null);
            intent = this.zzmjj;
            // MONITORENTER : intent
            this.zzmjj.put((Object)string, (Object)zzo2);
            // MONITOREXIT : intent
            String string3 = string;
            KeyPair keyPair2 = keyPair;
            Bundle bundle2 = bundle;
            zzl zzl2 = this;
            long l = SystemClock.elapsedRealtime();
            if (zzl2.zzhub != 0L && l <= zzl2.zzhub) {
                long l2 = zzl2.zzhub - l;
                int n = zzl2.zzhua;
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
                throw new IOException("RETRY_LATER");
            }
            zzl2.zzass();
            if (zzhto == null) {
                throw new IOException("MISSING_INSTANCEID_SERVICE");
            }
            zzl2.zzhtx = SystemClock.elapsedRealtime();
            Intent intent2 = new Intent(zzhtp ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
            intent2.setPackage(zzhto);
            bundle2.putString("gmsv", Integer.toString(FirebaseInstanceId.zzap(zzl2.zzaie, zzl.zzdg(zzl2.zzaie))));
            bundle2.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
            bundle2.putString("app_ver", Integer.toString(FirebaseInstanceId.zzei(zzl2.zzaie)));
            bundle2.putString("app_ver_name", FirebaseInstanceId.zzde(zzl2.zzaie));
            bundle2.putString("cliv", "fiid-11220000");
            bundle2.putString("appid", FirebaseInstanceId.zza(keyPair2));
            String string4 = FirebaseInstanceId.zzm(keyPair2.getPublic().getEncoded());
            bundle2.putString("pub2", string4);
            bundle2.putString("sig", zzl.zza(keyPair2, zzl2.zzaie.getPackageName(), string4));
            intent2.putExtras(bundle2);
            zzl.zzd(zzl2.zzaie, intent2);
            String string5 = string3;
            Intent intent3 = intent2;
            zzl zzl3 = zzl2;
            zzl2.zzhtx = SystemClock.elapsedRealtime();
            intent3.putExtra("kid", new StringBuilder(5 + String.valueOf(string5).length()).append("|ID|").append(string5).append("|").toString());
            intent3.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string5).length()).append("|ID|").append(string5).append("|").toString());
            boolean bl = "com.google.android.gsf".equals(zzhto);
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                string2 = String.valueOf(intent3.getExtras());
                Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
            }
            if (bl) {
                zzl zzl4;
                zzl zzl5 = zzl4 = zzl3;
                // MONITORENTER : zzl4
                if (zzhtt == null) {
                    zzhtt = new zzn(zzl4);
                    if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                        Log.d((String)"InstanceID/Rpc", (String)"Registered GSF callback receiver");
                    }
                    IntentFilter intentFilter = new IntentFilter("com.google.android.c2dm.intent.REGISTRATION");
                    intentFilter.addCategory(zzl4.zzaie.getPackageName());
                    zzl4.zzaie.registerReceiver(zzhtt, intentFilter, "com.google.android.c2dm.permission.SEND", null);
                }
                // MONITOREXIT : zzl5
                zzl3.zzaie.startService(intent3);
            } else {
                block25: {
                    intent3.putExtra("google.messenger", (Parcelable)zzl3.zzhri);
                    if (zzl3.zzhtv != null || zzl3.zzhtw != null) {
                        string2 = Message.obtain();
                        Message.obtain().obj = intent3;
                        try {
                            if (zzl3.zzhtv != null) {
                                zzl3.zzhtv.send((Message)string2);
                                break block24;
                            } else {
                                zzl3.zzhtw.send((Message)string2);
                            }
                            break block24;
                        }
                        catch (RemoteException remoteException) {
                            if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block25;
                            Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                        }
                    }
                }
                if (zzhtp) {
                    zzl3.zzaie.sendBroadcast(intent3);
                } else {
                    zzl3.zzaie.startService(intent3);
                }
            }
        }
        try {
            intent = zzo2.zzbyo();
            SimpleArrayMap<String, zzp> simpleArrayMap = this.zzmjj;
        }
        catch (Throwable throwable) {
            SimpleArrayMap<String, zzp> simpleArrayMap = this.zzmjj;
            // MONITORENTER : simpleArrayMap
            this.zzmjj.remove((Object)string);
            // MONITOREXIT : simpleArrayMap
            throw throwable;
        }
        this.zzmjj.remove((Object)string);
        // MONITOREXIT : simpleArrayMap
        return intent;
    }
}

