/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzq;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzh;

public final class FirebaseInstanceIdReceiver
extends WakefulBroadcastReceiver {
    private static boolean zzhzq = false;
    private static zzh zznup;
    private static zzh zznuq;

    public FirebaseInstanceIdReceiver() {
    }

    public final void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        Parcelable parcelable = intent.getParcelableExtra("wrapped_intent");
        if (parcelable instanceof Intent) {
            this.zza(context, (Intent)parcelable, intent.getAction());
            return;
        }
        this.zza(context, intent, intent.getAction());
    }

    private final void zza(Context context, Intent intent, String string) {
        String string2;
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        if ((string2 = intent.getStringExtra("gcm.rawData64")) != null) {
            intent.putExtra("rawData", Base64.decode((String)string2, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        String string3 = null;
        String string4 = intent.getStringExtra("from");
        if ("google.com/iid".equals(string4) || "gcm.googleapis.com/refresh".equals(string4) || "com.google.firebase.INSTANCE_ID_EVENT".equals(string)) {
            string3 = "com.google.firebase.INSTANCE_ID_EVENT";
        } else if ("com.google.android.c2dm.intent.RECEIVE".equals(string) || "com.google.firebase.MESSAGING_EVENT".equals(string)) {
            string3 = "com.google.firebase.MESSAGING_EVENT";
        } else {
            Log.d((String)"FirebaseInstanceId", (String)"Unexpected intent");
        }
        int n = -1;
        if (string3 != null) {
            int n2;
            Intent intent2 = intent;
            String string5 = string3;
            Context context2 = context;
            FirebaseInstanceIdReceiver firebaseInstanceIdReceiver = this;
            Context context3 = context2;
            if (zzq.isAtLeastO() && context3.getApplicationInfo().targetSdkVersion > 25) {
                if (firebaseInstanceIdReceiver.isOrderedBroadcast()) {
                    firebaseInstanceIdReceiver.setResultCode(-1);
                }
                FirebaseInstanceIdReceiver.zzan(context2, string5).zza(intent2, firebaseInstanceIdReceiver.goAsync());
                n2 = -1;
            } else {
                n2 = n = zzaa.zzchn().zza(context2, string5, intent2);
            }
        }
        if (this.isOrderedBroadcast()) {
            this.setResultCode(n);
        }
    }

    private static synchronized zzh zzan(Context context, String string) {
        if ("com.google.firebase.MESSAGING_EVENT".equals(string)) {
            if (zznuq == null) {
                zznuq = new zzh(context, string);
            }
            return zznuq;
        }
        if (zznup == null) {
            zznup = new zzh(context, string);
        }
        return zznup;
    }
}

