/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzj;
import com.google.firebase.iid.zzw;
import java.io.IOException;

public final class zzad
implements Runnable {
    private final long zznvu;
    private final PowerManager.WakeLock zznvv;
    private FirebaseInstanceId zznvw;

    zzad(FirebaseInstanceId firebaseInstanceId, long l) {
        this.zznvw = firebaseInstanceId;
        this.zznvu = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zznvv = powerManager.newWakeLock(1, "fiid-sync");
        this.zznvv.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zznvv.acquire();
        try {
            this.zznvw.zzco(true);
            if (!zzw.zzeu(this.getContext())) {
                this.zznvw.zzco(false);
                return;
            }
            if (!this.zzchr()) {
                new zzae(this).zzchs();
                return;
            }
            if (this.zzchp() && this.zzchq()) {
                this.zznvw.zzco(false);
            } else {
                this.zznvw.zzcb(this.zznvu);
            }
            return;
        }
        finally {
            this.zznvv.release();
        }
    }

    private final boolean zzchp() {
        zzac zzac2 = this.zznvw.zzcgy();
        if (zzac2 != null && !zzac2.zzqz(zzi.zzida)) {
            return true;
        }
        try {
            String string = this.zznvw.zzcgz();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzac2 == null || zzac2 != null && !string.equals(zzac2.zzlax)) {
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                Intent intent2 = new Intent("com.google.firebase.INSTANCE_ID_EVENT");
                intent2.setClass(context, FirebaseInstanceIdReceiver.class);
                intent2.putExtra("wrapped_intent", (Parcelable)intent);
                context.sendBroadcast(intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzchq() {
        zzj zzj2 = FirebaseInstanceId.zzcha();
        while (true) {
            String string;
            FirebaseInstanceId firebaseInstanceId = this.zznvw;
            synchronized (firebaseInstanceId) {
                string = zzj2.zzchg();
                if (string == null) {
                    Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
                    return true;
                }
            }
            if (!this.zzra(string)) {
                return false;
            }
            zzj2.zzqt(string);
        }
    }

    private final boolean zzra(String string) {
        block12: {
            String[] stringArray = string.split("!");
            if (stringArray.length != 2) break block12;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            try {
                switch (string2) {
                    case "S": {
                        this.zznvw.zzqr(string3);
                        if (FirebaseInstanceId.zzchb()) {
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                        }
                        break;
                    }
                    case "U": {
                        this.zznvw.zzqs(string3);
                        if (FirebaseInstanceId.zzchb()) {
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        } else {
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(iOException.getMessage());
                Log.e((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Topic sync failed: ".concat(string4) : new String("Topic sync failed: ")));
                return false;
            }
        }
        return true;
    }

    final Context getContext() {
        return this.zznvw.getApp().getApplicationContext();
    }

    final boolean zzchr() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        return connectivityManager != null && connectivityManager.getActiveNetworkInfo() != null && connectivityManager.getActiveNetworkInfo().isConnected();
    }
}

