/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.os.PowerManager;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzw;
import java.io.IOException;

final class zzac
implements Runnable {
    private final long zzolp;
    private final PowerManager.WakeLock zzolq;
    private final FirebaseInstanceId zzolr;
    private final zzw zzokq;

    zzac(FirebaseInstanceId firebaseInstanceId, zzw zzw2, long l) {
        this.zzolr = firebaseInstanceId;
        this.zzokq = zzw2;
        this.zzolp = l;
        PowerManager powerManager = (PowerManager)this.getContext().getSystemService("power");
        this.zzolq = powerManager.newWakeLock(1, "fiid-sync");
        this.zzolq.setReferenceCounted(false);
    }

    @Override
    public final void run() {
        this.zzolq.acquire();
        try {
            this.zzolr.zzcy(true);
            if (!(this.zzokq.zzcll() != 0)) {
                this.zzolr.zzcy(false);
                return;
            }
            if (!this.zzclv()) {
                new zzad(this).zzclw();
                return;
            }
            if (this.zzclt() && this.zzclu()) {
                this.zzolr.zzcy(false);
            } else {
                this.zzolr.zzcd(this.zzolp);
            }
            return;
        }
        finally {
            this.zzolq.release();
        }
    }

    private final boolean zzclt() {
        zzab zzab2 = this.zzolr.zzclc();
        if (zzab2 != null && !zzab2.zzru(this.zzokq.zzclm())) {
            return true;
        }
        try {
            String string = this.zzolr.zzcld();
            if (string == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Token retrieval failed: null");
                return false;
            }
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"Token successfully retrieved");
            }
            if (zzab2 == null || zzab2 != null && !string.equals(zzab2.zzlnm)) {
                Context context = this.getContext();
                Intent intent = new Intent("com.google.firebase.iid.TOKEN_REFRESH");
                Intent intent2 = new Intent("com.google.firebase.INSTANCE_ID_EVENT");
                intent2.setClass(context, FirebaseInstanceIdReceiver.class);
                intent2.putExtra("wrapped_intent", (Parcelable)intent);
                context.sendBroadcast(intent2);
            }
            return true;
        }
        catch (IOException | SecurityException exception) {
            String string = String.valueOf(exception.getMessage());
            Log.e((String)"FirebaseInstanceId", (String)(string.length() != 0 ? "Token retrieval failed: ".concat(string) : new String("Token retrieval failed: ")));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzclu() {
        while (true) {
            String string;
            FirebaseInstanceId firebaseInstanceId = this.zzolr;
            synchronized (firebaseInstanceId) {
                string = FirebaseInstanceId.zzcle().zzcls();
                if (string == null) {
                    Log.d((String)"FirebaseInstanceId", (String)"topic sync succeeded");
                    return true;
                }
            }
            if (!this.zzrv(string)) {
                return false;
            }
            FirebaseInstanceId.zzcle().zzro(string);
        }
    }

    private final boolean zzrv(String string) {
        block12: {
            String[] stringArray = string.split("!");
            if (stringArray.length != 2) break block12;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            try {
                switch (string2) {
                    case "S": {
                        this.zzolr.zzrm(string3);
                        if (FirebaseInstanceId.zzclf()) {
                            Log.d((String)"FirebaseInstanceId", (String)"subscribe operation succeeded");
                        }
                        break;
                    }
                    case "U": {
                        this.zzolr.zzrn(string3);
                        if (FirebaseInstanceId.zzclf()) {
                            Log.d((String)"FirebaseInstanceId", (String)"unsubscribe operation succeeded");
                        } else {
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(iOException.getMessage());
                Log.e((String)"FirebaseInstanceId", (String)(string4.length() != 0 ? "Topic sync failed: ".concat(string4) : new String("Topic sync failed: ")));
                return false;
            }
        }
        return true;
    }

    final Context getContext() {
        return this.zzolr.getApp().getApplicationContext();
    }

    final boolean zzclv() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }
}

