/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.IRpc;
import com.google.firebase.iid.zzah;
import com.google.firebase.iid.zzak;
import com.google.firebase.iid.zzaq;
import com.google.firebase.iid.zzar;
import com.google.firebase.iid.zzas;
import com.google.firebase.iid.zzau;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzl;
import com.google.firebase.iid.zzm;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    static final Executor zzah = zzn.zzba;
    private static final long zzai = TimeUnit.HOURS.toSeconds(8L);
    private static zzaq zzaj;
    private static final Executor zzak;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledThreadPoolExecutor zzal;
    private static final Executor zzam;
    private final FirebaseApp zzan;
    private final zzah zzao;
    private IRpc zzap;
    private final zzak zzaq = new zzak();
    private final zzau zzar;
    @GuardedBy(value="this")
    private boolean zzas = false;
    @GuardedBy(value="this")
    private boolean zzat;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp) {
        this(firebaseApp, new zzah(firebaseApp.getApplicationContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzah zzah2) {
        if (com.google.firebase.iid.zzah.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzaj == null) {
                zzaj = new zzaq(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.zzan = firebaseApp;
            this.zzao = zzah2;
            zzah zzah3 = zzah2;
            FirebaseApp firebaseApp2 = firebaseApp;
            FirebaseInstanceId firebaseInstanceId = this;
            if (firebaseInstanceId.zzap == null) {
                IRpc iRpc = (IRpc)firebaseApp2.get(IRpc.class);
                firebaseInstanceId.zzap = iRpc != null ? iRpc : new zzo(firebaseApp2, zzah3, zzam);
            }
            this.zzap = firebaseInstanceId.zzap;
            this.zzar = new zzau(zzaj);
            this.zzat = this.zzl();
            if (this.zzn()) {
                this.zzd();
            }
            return;
        }
    }

    private final void zzd() {
        zzar zzar2 = this.zzg();
        if (zzar2 == null || zzar2.zzj(this.zzao.zzx()) || this.zzar.zzaj()) {
            this.startSync();
        }
    }

    final FirebaseApp zze() {
        return this.zzan;
    }

    final synchronized void zza(boolean bl) {
        this.zzas = bl;
    }

    private final synchronized void startSync() {
        if (!this.zzas) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zzai);
        FirebaseInstanceId.zza(new zzas(this, this.zzao, this.zzar, l2), l);
        this.zzas = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzal == null) {
                zzal = new ScheduledThreadPoolExecutor(1);
            }
            zzal.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzd();
        return FirebaseInstanceId.zzf();
    }

    private static String zzf() {
        return com.google.firebase.iid.zzah.zza(zzaj.zzg("").getKeyPair());
    }

    public long getCreationTime() {
        return zzaj.zzg("").getCreationTime();
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        String string = FirebaseInstanceId.zzf();
        this.zza(this.zzap.deleteInstanceId(string));
        this.zzj();
    }

    @Nullable
    public String getToken() {
        zzar zzar2 = this.zzg();
        if (zzar2 == null || zzar2.zzj(this.zzao.zzx())) {
            this.startSync();
        }
        if (zzar2 != null) {
            return zzar2.zzcz;
        }
        return null;
    }

    @Nullable
    final zzar zzg() {
        return zzaj.zzc("", com.google.firebase.iid.zzah.zza(this.zzan), "*");
    }

    final String zzh() throws IOException {
        return this.getToken(com.google.firebase.iid.zzah.zza(this.zzan), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        String string3 = string2;
        String string4 = string;
        FirebaseInstanceId firebaseInstanceId = this;
        String string5 = FirebaseInstanceId.zzd(string3);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzak.execute(new zzk(firebaseInstanceId, string4, string3, taskCompletionSource, string5));
        return (String)this.zza(taskCompletionSource.getTask());
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zzj();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        String string3 = FirebaseInstanceId.zzf();
        this.zza(this.zzap.deleteToken(string3, string, string2));
        zzaj.zzd("", string, string2);
    }

    public final synchronized Task<Void> zza(String string) {
        Task<Void> task = this.zzar.zza(string);
        this.startSync();
        return task;
    }

    final void zzb(String string) throws IOException {
        zzar zzar2 = this.zzg();
        if (zzar2 == null || zzar2.zzj(this.zzao.zzx())) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzf();
        String string3 = string;
        String string4 = zzar2.zzcz;
        String string5 = string2;
        Task<Void> task = this.zzap.subscribeToTopic(string5, string4, string3);
        this.zza(task);
    }

    final void zzc(String string) throws IOException {
        zzar zzar2 = this.zzg();
        if (zzar2 == null || zzar2.zzj(this.zzao.zzx())) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzf();
        this.zza(this.zzap.unsubscribeFromTopic(string2, zzar2.zzcz, string));
    }

    static boolean zzi() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zzj() {
        zzaj.zzaf();
        if (this.zzn()) {
            this.startSync();
        }
    }

    final void zzk() {
        zzaj.zzh("");
        this.startSync();
    }

    private final boolean zzl() {
        Context context = this.zzan.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("auto_init")) {
            return sharedPreferences.getBoolean("auto_init", true);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return this.zzm();
    }

    private final boolean zzm() {
        try {
            Class.forName("com.google.firebase.messaging.FirebaseMessaging");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Context context = this.zzan.getApplicationContext();
            Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
            intent.setPackage(context.getPackageName());
            ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
            return resolveInfo != null && resolveInfo.serviceInfo != null;
        }
    }

    @VisibleForTesting
    public final synchronized boolean zzn() {
        return this.zzat;
    }

    @VisibleForTesting
    public final synchronized void zzb(boolean bl) {
        SharedPreferences.Editor editor = this.zzan.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
        editor.putBoolean("auto_init", bl);
        editor.apply();
        if (!this.zzat && bl) {
            this.zzd();
        }
        this.zzat = bl;
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final /* synthetic */ void zza(String string, String string2, TaskCompletionSource taskCompletionSource, String string3) {
        zzar zzar2 = zzaj.zzc("", string, string2);
        if (zzar2 != null && !zzar2.zzj(this.zzao.zzx())) {
            taskCompletionSource.setResult((Object)zzar2.zzcz);
            return;
        }
        String string4 = FirebaseInstanceId.zzf();
        this.zzaq.zza(string, string3, new zzl(this, string4, string, string3)).addOnCompleteListener(zzak, (OnCompleteListener)new zzm(this, string, string3, taskCompletionSource));
    }

    final /* synthetic */ void zza(String string, String string2, TaskCompletionSource taskCompletionSource, Task task) {
        if (task.isSuccessful()) {
            String string3 = (String)task.getResult();
            zzaj.zza("", string, string2, string3, this.zzao.zzx());
            taskCompletionSource.setResult((Object)string3);
            return;
        }
        taskCompletionSource.setException(task.getException());
    }

    final /* synthetic */ Task zza(String string, String string2, String string3) {
        return this.zzap.getToken(string, string2, string3);
    }

    static final /* synthetic */ void zza(Runnable runnable) {
        runnable.run();
    }

    static {
        zzak = Executors.newCachedThreadPool();
        zzam = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }
}

