/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.FirebaseApp;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class zzah {
    private final Context zzz;
    @GuardedBy(value="this")
    private String zzcb;
    @GuardedBy(value="this")
    private String zzcc;
    @GuardedBy(value="this")
    private int zzcd;
    @GuardedBy(value="this")
    private int zzce = 0;

    public zzah(Context context) {
        this.zzz = context;
    }

    public final synchronized int zzw() {
        List list;
        Intent intent;
        if (this.zzce != 0) {
            return this.zzce;
        }
        PackageManager packageManager = this.zzz.getPackageManager();
        if (packageManager.checkPermission("com.google.android.c2dm.permission.SEND", "com.google.android.gms") == -1) {
            Log.e((String)"FirebaseInstanceId", (String)"Google Play services missing or without correct permission.");
            return 0;
        }
        if (!PlatformVersion.isAtLeastO()) {
            intent = new Intent("com.google.android.c2dm.intent.REGISTER");
            intent.setPackage("com.google.android.gms");
            list = packageManager.queryIntentServices(intent, 0);
            if (list != null && list.size() > 0) {
                this.zzce = 1;
                return this.zzce;
            }
        }
        intent = new Intent("com.google.iid.TOKEN_REQUEST");
        intent.setPackage("com.google.android.gms");
        list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0) {
            this.zzce = 2;
            return this.zzce;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Failed to resolve IID implementation package, falling back");
        this.zzce = PlatformVersion.isAtLeastO() ? 2 : 1;
        return this.zzce;
    }

    public static String zza(FirebaseApp firebaseApp) {
        String string = firebaseApp.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        String string2 = firebaseApp.getOptions().getApplicationId();
        if (!string2.startsWith("1:")) {
            return string2;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        String string3 = stringArray[1];
        if (string3.isEmpty()) {
            return null;
        }
        return string3;
    }

    public static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    public final synchronized String zzx() {
        if (this.zzcb == null) {
            this.zzaa();
        }
        return this.zzcb;
    }

    public final synchronized String zzy() {
        if (this.zzcc == null) {
            this.zzaa();
        }
        return this.zzcc;
    }

    public final synchronized int zzz() {
        PackageInfo packageInfo;
        if (this.zzcd == 0 && (packageInfo = this.zze("com.google.android.gms")) != null) {
            this.zzcd = packageInfo.versionCode;
        }
        return this.zzcd;
    }

    private final synchronized void zzaa() {
        PackageInfo packageInfo = this.zze(this.zzz.getPackageName());
        if (packageInfo != null) {
            this.zzcb = Integer.toString(packageInfo.versionCode);
            this.zzcc = packageInfo.versionName;
        }
    }

    private final PackageInfo zze(String string) {
        try {
            return this.zzz.getPackageManager().getPackageInfo(string, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return null;
        }
    }
}

