/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.MessagingChannel;
import com.google.firebase.iid.zzal;
import com.google.firebase.iid.zzao;
import com.google.firebase.iid.zzau;
import com.google.firebase.iid.zzav;
import com.google.firebase.iid.zzaw;
import com.google.firebase.iid.zzay;
import com.google.firebase.iid.zzi;
import com.google.firebase.iid.zzm;
import com.google.firebase.iid.zzn;
import com.google.firebase.iid.zzo;
import com.google.firebase.iid.zzp;
import com.google.firebase.iid.zzv;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long zzaf = TimeUnit.HOURS.toSeconds(8L);
    private static zzau zzag;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    private static ScheduledThreadPoolExecutor zzah;
    private final Executor zzai;
    private final FirebaseApp zzaj;
    private final zzal zzak;
    private MessagingChannel zzal;
    private final zzao zzam = new zzao();
    private final zzay zzan;
    @GuardedBy(value="this")
    private boolean zzao = false;
    @GuardedBy(value="this")
    private boolean zzap;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
    }

    FirebaseInstanceId(FirebaseApp firebaseApp) {
        this(firebaseApp, new zzal(firebaseApp.getApplicationContext()), zzi.zze(), zzi.zze());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FirebaseInstanceId(FirebaseApp firebaseApp, zzal zzal2, Executor executor, Executor executor2) {
        if (com.google.firebase.iid.zzal.zza(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzag == null) {
                zzag = new zzau(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.zzaj = firebaseApp;
            this.zzak = zzal2;
            Executor executor3 = executor;
            zzal zzal3 = zzal2;
            FirebaseApp firebaseApp2 = firebaseApp;
            FirebaseInstanceId firebaseInstanceId = this;
            if (firebaseInstanceId.zzal == null) {
                MessagingChannel messagingChannel = (MessagingChannel)firebaseApp2.get(MessagingChannel.class);
                firebaseInstanceId.zzal = messagingChannel != null && messagingChannel.isAvailable() ? messagingChannel : new zzp(firebaseApp2, zzal3, executor3);
            }
            this.zzal = firebaseInstanceId.zzal;
            this.zzai = executor2;
            this.zzan = new zzay(zzag);
            this.zzap = this.zzq();
            if (this.zzs()) {
                this.zzf();
            }
            return;
        }
    }

    private final void zzf() {
        zzav zzav2 = this.zzi();
        if (!this.zzn() || zzav2 == null || zzav2.zzj(this.zzak.zzac()) || this.zzan.zzap()) {
            this.startSync();
        }
    }

    final FirebaseApp zzg() {
        return this.zzaj;
    }

    final synchronized void zza(boolean bl) {
        this.zzao = bl;
    }

    private final synchronized void startSync() {
        if (!this.zzao) {
            this.zza(0L);
        }
    }

    final synchronized void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zzaf);
        FirebaseInstanceId.zza(new zzaw(this, this.zzak, this.zzan, l2), l);
        this.zzao = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zza(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (zzah == null) {
                zzah = new ScheduledThreadPoolExecutor(1);
            }
            zzah.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    public String getId() {
        this.zzf();
        return FirebaseInstanceId.zzh();
    }

    private static String zzh() {
        return com.google.firebase.iid.zzal.zza(zzag.zzg("").getKeyPair());
    }

    public long getCreationTime() {
        return zzag.zzg("").getCreationTime();
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        return this.zza(com.google.firebase.iid.zzal.zza(this.zzaj), "*");
    }

    private final Task<InstanceIdResult> zza(String string, String string2) {
        String string3 = FirebaseInstanceId.zzd(string2);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzai.execute(new zzm(this, string, string2, taskCompletionSource, string3));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        String string = FirebaseInstanceId.zzh();
        this.zza(this.zzal.deleteInstanceId(string));
        this.zzl();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        zzav zzav2 = this.zzi();
        if (zzav2 == null || zzav2.zzj(this.zzak.zzac())) {
            this.startSync();
        }
        if (zzav2 != null) {
            return zzav2.zzbh;
        }
        return null;
    }

    @Nullable
    final zzav zzi() {
        return zzag.zzc("", com.google.firebase.iid.zzal.zza(this.zzaj), "*");
    }

    final String zzj() throws IOException {
        return this.getToken(com.google.firebase.iid.zzal.zza(this.zzaj), "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.zza(this.zza(string, string2)).getToken();
    }

    private final <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.zzl();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.zzd(string2);
        String string3 = FirebaseInstanceId.zzh();
        this.zza(this.zzal.deleteToken(string3, string, string2));
        zzag.zzd("", string, string2);
    }

    public final synchronized Task<Void> zza(String string) {
        Task<Void> task = this.zzan.zza(string);
        this.startSync();
        return task;
    }

    final void zzb(String string) throws IOException {
        zzav zzav2 = this.zzi();
        if (zzav2 == null || zzav2.zzj(this.zzak.zzac())) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzh();
        String string3 = string;
        String string4 = zzav2.zzbh;
        String string5 = string2;
        Task<Void> task = this.zzal.subscribeToTopic(string5, string4, string3);
        this.zza(task);
    }

    final void zzc(String string) throws IOException {
        zzav zzav2 = this.zzi();
        if (zzav2 == null || zzav2.zzj(this.zzak.zzac())) {
            throw new IOException("token not available");
        }
        String string2 = FirebaseInstanceId.zzh();
        this.zza(this.zzal.unsubscribeFromTopic(string2, zzav2.zzbh, string));
    }

    static boolean zzk() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    final synchronized void zzl() {
        zzag.zzak();
        if (this.zzs()) {
            this.startSync();
        }
    }

    final boolean zzm() {
        return this.zzal.isAvailable();
    }

    final boolean zzn() {
        return this.zzal.isChannelBuilt();
    }

    final void zzo() throws IOException {
        String string = FirebaseInstanceId.zzh();
        zzav zzav2 = this.zzi();
        String string2 = zzav2 == null ? null : zzav2.zzbh;
        this.zza(this.zzal.buildChannel(string, string2));
    }

    final void zzp() {
        zzag.zzh("");
        this.startSync();
    }

    private final boolean zzq() {
        Context context = this.zzaj.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
        if (sharedPreferences.contains("auto_init")) {
            return sharedPreferences.getBoolean("auto_init", true);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return this.zzr();
    }

    private final boolean zzr() {
        try {
            Class.forName("com.google.firebase.messaging.FirebaseMessaging");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Context context = this.zzaj.getApplicationContext();
            Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
            intent.setPackage(context.getPackageName());
            ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
            return resolveInfo != null && resolveInfo.serviceInfo != null;
        }
    }

    @VisibleForTesting
    public final synchronized boolean zzs() {
        return this.zzap;
    }

    @VisibleForTesting
    public final synchronized void zzb(boolean bl) {
        SharedPreferences.Editor editor = this.zzaj.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
        editor.putBoolean("auto_init", bl);
        editor.apply();
        if (!this.zzap && bl) {
            this.zzf();
        }
        this.zzap = bl;
    }

    private static String zzd(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    final /* synthetic */ void zza(String string, String string2, TaskCompletionSource taskCompletionSource, String string3) {
        String string4 = FirebaseInstanceId.zzh();
        zzav zzav2 = zzag.zzc("", string, string2);
        if (zzav2 != null && !zzav2.zzj(this.zzak.zzac())) {
            taskCompletionSource.setResult((Object)new zzv(string4, zzav2.zzbh));
            return;
        }
        this.zzam.zza(string, string3, new zzn(this, string4, string, string3)).addOnCompleteListener(this.zzai, (OnCompleteListener)new zzo(this, string, string3, taskCompletionSource, string4));
    }

    final /* synthetic */ void zza(String string, String string2, TaskCompletionSource taskCompletionSource, String string3, Task task) {
        if (task.isSuccessful()) {
            String string4 = (String)task.getResult();
            zzag.zza("", string, string2, string4, this.zzak.zzac());
            taskCompletionSource.setResult((Object)new zzv(string3, string4));
            return;
        }
        taskCompletionSource.setException(task.getException());
    }

    final /* synthetic */ Task zza(String string, String string2, String string3) {
        return this.zzal.getToken(string, string2, string3);
    }
}

