/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zzf;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public final class zzh
implements ServiceConnection {
    private final Context zzv;
    private final Intent zzw;
    private final ScheduledExecutorService zzx;
    private final Queue<zzd> zzy = new ArrayDeque<zzd>();
    private zzf zzz;
    private boolean zzaa = false;

    public zzh(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0));
    }

    @VisibleForTesting
    private zzh(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zzv = context.getApplicationContext();
        this.zzw = new Intent(string).setPackage(this.zzv.getPackageName());
        this.zzx = scheduledExecutorService;
    }

    public final synchronized void zza(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
        }
        this.zzy.add(new zzd(intent, pendingResult, this.zzx));
        this.zzc();
    }

    private final synchronized void zzc() {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"flush queue called");
        }
        while (!this.zzy.isEmpty()) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
            }
            if (this.zzz != null && this.zzz.isBinderAlive()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                }
                zzd zzd2 = this.zzy.poll();
                this.zzz.zza(zzd2);
                continue;
            }
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                boolean bl = !this.zzaa;
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!this.zzaa) {
                this.zzaa = true;
                try {
                    if (ConnectionTracker.getInstance().bindService(this.zzv, this.zzw, (ServiceConnection)this, 65)) {
                        return;
                    }
                    Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                }
                while (!this.zzy.isEmpty()) {
                    this.zzy.poll().finish();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzh zzh2 = this;
        synchronized (zzh2) {
            this.zzaa = false;
            this.zzz = (zzf)iBinder;
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                String string = String.valueOf(componentName);
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
            }
            this.zzc();
            return;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zzc();
    }
}

