/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;

public final class zzau {
    private static zzau zzdd;
    @GuardedBy(value="serviceClassNames")
    private final SimpleArrayMap<String, String> zzde = new SimpleArrayMap();
    private Boolean zzdf = null;
    private Boolean zzdg = null;
    final Queue<Intent> zzdh = new ArrayDeque<Intent>();
    private final Queue<Intent> zzdi = new ArrayDeque<Intent>();

    public static synchronized zzau zzai() {
        if (zzdd == null) {
            zzdd = new zzau();
        }
        return zzdd;
    }

    private zzau() {
    }

    public static void zzb(Context context, Intent intent) {
        context.sendBroadcast(zzau.zza(context, "com.google.firebase.INSTANCE_ID_EVENT", intent));
    }

    public static void zzc(Context context, Intent intent) {
        context.sendBroadcast(zzau.zza(context, "com.google.firebase.MESSAGING_EVENT", intent));
    }

    private static Intent zza(Context context, String string, Intent intent) {
        Intent intent2 = new Intent(context, FirebaseInstanceIdReceiver.class);
        intent2.setAction(string);
        intent2.putExtra("wrapped_intent", (Parcelable)intent);
        return intent2;
    }

    public final Intent zzaj() {
        return this.zzdi.poll();
    }

    public final int zzb(Context context, String string, Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Starting service: ".concat(string2) : new String("Starting service: ")));
        }
        switch (string) {
            case "com.google.firebase.INSTANCE_ID_EVENT": {
                this.zzdh.offer(intent);
                break;
            }
            case "com.google.firebase.MESSAGING_EVENT": {
                this.zzdi.offer(intent);
                break;
            }
            default: {
                String string3 = String.valueOf(string);
                Log.w((String)"FirebaseInstanceId", (String)(string3.length() != 0 ? "Unknown service action: ".concat(string3) : new String("Unknown service action: ")));
                return 500;
            }
        }
        String string4 = new Intent(string);
        string4.setPackage(context.getPackageName());
        return this.zzd(context, (Intent)string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final int zzd(Context var1_1, Intent var2_2) {
        var7_3 = var2_2;
        var6_4 = var1_1;
        var5_5 = this;
        var9_6 = var5_5.zzde;
        synchronized (var9_6) {
            var8_7 = (String)var5_5.zzde.get((Object)var7_3.getAction());
        }
        if (var8_7 != null) ** GOTO lbl40
        var9_6 = var6_4.getPackageManager().resolveService(var7_3, 0);
        if (var9_6 == null || var9_6.serviceInfo == null) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to resolve target intent service, skipping classname enforcement");
        } else {
            var10_9 = var9_6.serviceInfo;
            if (!var6_4.getPackageName().equals(var10_9.packageName) || var10_9.name == null) {
                var11_10 = var10_9.packageName;
                var12_12 = var10_9.name;
                Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(94 + String.valueOf(var11_10).length() + String.valueOf(var12_12).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(var11_10).append("/").append(var12_12).toString());
            } else {
                var8_7 = var10_9.name;
                if (var8_7.startsWith(".")) {
                    v0 = String.valueOf(var6_4.getPackageName());
                    v1 = String.valueOf(var8_7);
                    v2 = v1.length() != 0 ? v0.concat(v1) : new String(v0);
                } else {
                    v2 = var8_7;
                }
                var8_7 = v2;
                var11_11 = var5_5.zzde;
                synchronized (var11_11) {
                    var5_5.zzde.put((Object)var7_3.getAction(), (Object)var8_7);
                }
lbl40:
                // 2 sources

                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    v3 = String.valueOf(var8_7);
                    Log.d((String)"FirebaseInstanceId", (String)(v3.length() != 0 ? "Restricting intent to a specific service: ".concat(v3) : new String("Restricting intent to a specific service: ")));
                }
                var7_3.setClassName(var6_4.getPackageName(), var8_7);
            }
        }
        try {
            if (this.zzd(var1_1)) {
                var3_14 = WakefulBroadcastReceiver.startWakefulService((Context)var1_1, (Intent)var2_2);
            } else {
                var3_14 = var1_1.startService(var2_2);
                Log.d((String)"FirebaseInstanceId", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (var3_14 == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message: ServiceIntent not found.");
                return 404;
            }
            return -1;
        }
        catch (SecurityException var3_15) {
            Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message to the serviceIntent", (Throwable)var3_15);
            return 401;
        }
        catch (IllegalStateException var3_16) {
            var4_17 = String.valueOf(var3_16);
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(45 + String.valueOf(var4_17).length()).append("Failed to start service while in background: ").append(var4_17).toString());
            return 402;
        }
    }

    final boolean zzd(Context context) {
        if (this.zzdf == null) {
            this.zzdf = context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0;
        }
        if (!this.zzdf.booleanValue() && Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Missing Permission: android.permission.WAKE_LOCK this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.zzdf;
    }

    final boolean zze(Context context) {
        if (this.zzdg == null) {
            this.zzdg = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
        }
        if (!this.zzdf.booleanValue() && Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Missing Permission: android.permission.ACCESS_NETWORK_STATE this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.zzdg;
    }
}

