/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.firebase_messaging.zze;
import com.google.firebase.iid.zzaa;
import com.google.firebase.iid.zzab;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzaf;
import com.google.firebase.iid.zzag;
import com.google.firebase.iid.zzah;
import com.google.firebase.iid.zzv;
import com.google.firebase.iid.zzx;
import com.google.firebase.iid.zzy;
import com.google.firebase.iid.zzz;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzw
implements ServiceConnection {
    @GuardedBy(value="this")
    int zza = 0;
    final Messenger zzb = new Messenger((Handler)new zze(Looper.getMainLooper(), new zzz(this)));
    zzaf zzc;
    @GuardedBy(value="this")
    final Queue<zzah<?>> zzd = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzah<?>> zze = new SparseArray();
    final /* synthetic */ zzv zzf;

    private zzw(zzv zzv2) {
        this.zzf = zzv2;
    }

    final synchronized boolean zza(zzah<?> zzah2) {
        switch (this.zza) {
            case 0: {
                this.zzd.add(zzah2);
                zzw zzw2 = this;
                Preconditions.checkState((zzw2.zza == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzw2.zza = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzv.zza(zzw2.zzf), intent, (ServiceConnection)zzw2, 1)) {
                    zzw2.zza(0, "Unable to bind to service");
                } else {
                    zzv.zzb(zzw2.zzf).schedule(new zzy(zzw2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzd.add(zzah2);
                return true;
            }
            case 2: {
                this.zzd.add(zzah2);
                this.zza();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.zza;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzah zzah2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzw zzw2 = this;
        synchronized (zzw2) {
            zzah2 = (zzah)this.zze.get(n);
            if (zzah2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zze.remove(n);
            this.zzb();
        }
        Bundle bundle = message.getData();
        zzah zzah3 = zzah2;
        if (bundle.getBoolean("unsupported", false)) {
            zzah3.zza(new zzag(4, "Not supported by GmsCore"));
        } else {
            zzah3.zza(bundle);
        }
        return true;
    }

    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        zzv.zzb(this.zzf).execute(new zzab(this, iBinder));
    }

    final void zza() {
        zzv.zzb(this.zzf).execute(new zzaa(this));
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        zzv.zzb(this.zzf).execute(new zzad(this));
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.zza) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.zza = 4;
                ConnectionTracker.getInstance().unbindService(zzv.zza(this.zzf), (ServiceConnection)this);
                zzag zzag2 = new zzag(n, string);
                zzw zzw2 = this;
                Iterator iterator = zzw2.zzd.iterator();
                while (iterator.hasNext()) {
                    ((zzah)iterator.next()).zza(zzag2);
                }
                zzw2.zzd.clear();
                for (int i = 0; i < zzw2.zze.size(); ++i) {
                    ((zzah)zzw2.zze.valueAt(i)).zza(zzag2);
                }
                zzw2.zze.clear();
                return;
            }
            case 3: {
                this.zza = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.zza;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzb() {
        if (this.zza == 2 && this.zzd.isEmpty() && this.zze.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.zza = 3;
            ConnectionTracker.getInstance().unbindService(zzv.zza(this.zzf), (ServiceConnection)this);
        }
    }

    final synchronized void zzc() {
        if (this.zza == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzah zzah2 = (zzah)this.zze.get(n);
        if (zzah2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zze.remove(n);
            zzah2.zza(new zzag(3, "Timed out waiting for response"));
            this.zzb();
        }
    }

    /* synthetic */ zzw(zzv zzv2, zzx zzx2) {
        this(zzv2);
    }
}

