/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.firebase_messaging.zze;
import com.google.firebase.iid.zzac;
import com.google.firebase.iid.zzad;
import com.google.firebase.iid.zzae;
import com.google.firebase.iid.zzag;
import com.google.firebase.iid.zzah;
import com.google.firebase.iid.zzai;
import com.google.firebase.iid.zzaj;
import com.google.firebase.iid.zzak;
import com.google.firebase.iid.zzam;
import com.google.firebase.iid.zzap;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzaf
implements ServiceConnection {
    @GuardedBy(value="this")
    int zza = 0;
    final Messenger zzb = new Messenger((Handler)new zze(Looper.getMainLooper(), new zzae(this)));
    zzak zzc;
    @GuardedBy(value="this")
    final Queue<zzam<?>> zzd = new ArrayDeque();
    @GuardedBy(value="this")
    final SparseArray<zzam<?>> zze = new SparseArray();
    final /* synthetic */ zzad zzf;

    private zzaf(zzad zzad2) {
        this.zzf = zzad2;
    }

    final synchronized boolean zza(zzam<?> zzam2) {
        switch (this.zza) {
            case 0: {
                this.zzd.add(zzam2);
                zzaf zzaf2 = this;
                Preconditions.checkState((zzaf2.zza == 0 ? 1 : 0) != 0);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                zzaf2.zza = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                if (!ConnectionTracker.getInstance().bindService(zzad.zza(zzaf2.zzf), intent, (ServiceConnection)zzaf2, 1)) {
                    zzaf2.zza(0, "Unable to bind to service");
                } else {
                    zzad.zzb(zzaf2.zzf).schedule(new zzah(zzaf2), 30L, TimeUnit.SECONDS);
                }
                return true;
            }
            case 1: {
                this.zzd.add(zzam2);
                return true;
            }
            case 2: {
                this.zzd.add(zzam2);
                this.zza();
                return true;
            }
            case 3: 
            case 4: {
                return false;
            }
        }
        int n = this.zza;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(Message message) {
        zzam zzam2;
        int n = message.arg1;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
        }
        zzaf zzaf2 = this;
        synchronized (zzaf2) {
            zzam2 = (zzam)this.zze.get(n);
            if (zzam2 == null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                return true;
            }
            this.zze.remove(n);
            this.zzb();
        }
        Bundle bundle = message.getData();
        zzam zzam3 = zzam2;
        if (bundle.getBoolean("unsupported", false)) {
            zzam3.zza(new zzap(4, "Not supported by GmsCore"));
        } else {
            zzam3.zza(bundle);
        }
        return true;
    }

    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        zzad.zzb(this.zzf).execute(new zzag(this, iBinder));
    }

    final void zza() {
        zzad.zzb(this.zzf).execute(new zzaj(this));
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        zzad.zzb(this.zzf).execute(new zzai(this));
    }

    final synchronized void zza(int n, String string) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string2 = String.valueOf(string);
            Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
        }
        switch (this.zza) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.zza = 4;
                ConnectionTracker.getInstance().unbindService(zzad.zza(this.zzf), (ServiceConnection)this);
                zzap zzap2 = new zzap(n, string);
                zzaf zzaf2 = this;
                Iterator iterator = zzaf2.zzd.iterator();
                while (iterator.hasNext()) {
                    ((zzam)iterator.next()).zza(zzap2);
                }
                zzaf2.zzd.clear();
                for (int i = 0; i < zzaf2.zze.size(); ++i) {
                    ((zzam)zzaf2.zze.valueAt(i)).zza(zzap2);
                }
                zzaf2.zze.clear();
                return;
            }
            case 3: {
                this.zza = 4;
                return;
            }
            case 4: {
                return;
            }
        }
        int n2 = this.zza;
        throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
    }

    final synchronized void zzb() {
        if (this.zza == 2 && this.zzd.isEmpty() && this.zze.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.zza = 3;
            ConnectionTracker.getInstance().unbindService(zzad.zza(this.zzf), (ServiceConnection)this);
        }
    }

    final synchronized void zzc() {
        if (this.zza == 1) {
            this.zza(1, "Timed out while binding");
        }
    }

    final synchronized void zza(int n) {
        zzam zzam2 = (zzam)this.zze.get(n);
        if (zzam2 != null) {
            Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
            this.zze.remove(n);
            zzam2.zza(new zzap(3, "Timed out waiting for response"));
            this.zzb();
        }
    }

    /* synthetic */ zzaf(zzad zzad2, zzac zzac2) {
        this(zzad2);
    }
}

