/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.zzbe;
import com.google.firebase.iid.zzbi;
import com.google.firebase.iid.zzbk;
import com.google.firebase.iid.zzbl;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class zzbj
implements ServiceConnection {
    private final Context zza;
    private final Intent zzb;
    private final ScheduledExecutorService zzc;
    private final Queue<zzbi> zzd = new ArrayDeque<zzbi>();
    @Nullable
    private zzbe zze;
    @GuardedBy(value="this")
    private boolean zzf = false;

    public zzbj(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory("Firebase-FirebaseInstanceIdServiceConnection")));
    }

    @VisibleForTesting
    private zzbj(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zza = context.getApplicationContext();
        this.zzb = new Intent(string).setPackage(this.zza.getPackageName());
        this.zzc = scheduledExecutorService;
    }

    public final synchronized Task<Void> zza(Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"new intent queued in the bind-strategy delivery");
        }
        zzbi zzbi2 = new zzbi(intent);
        ScheduledExecutorService scheduledExecutorService = this.zzc;
        zzbi zzbi3 = zzbi2;
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.schedule(new zzbl(zzbi3), 9000L, TimeUnit.MILLISECONDS);
        zzbi3.zza().addOnCompleteListener((Executor)scheduledExecutorService, (OnCompleteListener)new zzbk(scheduledFuture));
        this.zzd.add(zzbi2);
        this.zza();
        return zzbi2.zza();
    }

    private final synchronized void zza() {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"flush queue called");
        }
        while (!this.zzd.isEmpty()) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"found intent to be delivered");
            }
            if (this.zze != null && this.zze.isBinderAlive()) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    Log.d((String)"FirebaseInstanceId", (String)"binder is alive, sending the intent.");
                }
                zzbi zzbi2 = this.zzd.poll();
                this.zze.zza(zzbi2);
                continue;
            }
            zzbj zzbj2 = this;
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                boolean bl = !zzbj2.zzf;
                Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!zzbj2.zzf) {
                zzbj2.zzf = true;
                try {
                    if (ConnectionTracker.getInstance().bindService(zzbj2.zza, zzbj2.zzb, (ServiceConnection)zzbj2, 65)) {
                        return;
                    }
                    Log.e((String)"FirebaseInstanceId", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"FirebaseInstanceId", (String)"Exception while binding the service", (Throwable)securityException);
                }
                zzbj2.zzf = false;
                zzbj2.zzb();
            }
            return;
        }
    }

    @GuardedBy(value="this")
    private final void zzb() {
        while (!this.zzd.isEmpty()) {
            this.zzd.poll().zzb();
        }
    }

    public final synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        String string;
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            string = String.valueOf(componentName);
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
        }
        this.zzf = false;
        if (!(iBinder instanceof zzbe)) {
            string = String.valueOf(iBinder);
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(28 + String.valueOf(string).length()).append("Invalid service connection: ").append(string).toString());
            this.zzb();
            return;
        }
        this.zze = (zzbe)iBinder;
        this.zza();
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zza();
    }
}

