/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Intent;
import android.util.Log;
import androidx.annotation.WorkerThread;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.BroadcastProcessor;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.IidBroadcastProcessor$$Lambda$0;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

class IidBroadcastProcessor
implements BroadcastProcessor {
    private final ExecutorService executor;

    IidBroadcastProcessor(ExecutorService executorService) {
        this.executor = executorService;
    }

    @Override
    public Task<Integer> process(Intent intent) {
        return Tasks.call((Executor)this.executor, (Callable)new IidBroadcastProcessor$$Lambda$0(intent));
    }

    @WorkerThread
    private static int processImpl(Intent intent) {
        String string = intent.getStringExtra("CMD");
        if (string != null) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                String string2 = String.valueOf(intent.getExtras());
                Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Received command: ").append(string).append(" - ").append(string2).toString());
            }
            if ("RST".equals(string) || "RST_FULL".equals(string)) {
                FirebaseInstanceId.getInstance().resetStorageAndScheduleSync();
            } else if ("SYNC".equals(string)) {
                FirebaseInstanceId.getInstance().forceTokenRefresh();
            }
        }
        return -1;
    }

    static final /* synthetic */ Integer lambda$process$0$IidBroadcastProcessor(Intent intent) throws Exception {
        return IidBroadcastProcessor.processImpl(intent);
    }
}

